/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util.reflection;

import java.lang.reflect.InvocationTargetException;

// TODO: Auto-generated Javadoc
/**
 * The Class MethodUtil.
 */
public class MethodUtil {

	/**
	 * Executes (@link Method#execute(Object, String, Object[])) where the parameter array is <code>null</code>.
	 *
	 * @param _instance   the instance to execute the method over
	 * @param _methName  the methodname
	 * @return the result of the method execution
	 * @throws SecurityException     if access to the information is denied.
	 * @throws IllegalArgumentException (@link java.lang.reflect.Method#invoke(java.lang.Object, java.lang.Object[]))
	 * @throws NoSuchMethodException if the method is not found
	 * @throws IllegalAccessException   (@link java.lang.reflect.Method#invoke(java.lang.Object, java.lang.Object[]))
	 * @throws InvocationTargetException (@link java.lang.reflect.Method#invoke(java.lang.Object, java.lang.Object[]))
	 */
	public static Object execute( Object _instance, String _methName) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
		return MethodUtil.execute(_instance, _methName, (Object[])null);
	}

	/**
	 * Executes the given method over the specified instance.
	 * The specified parameter is used to obtain the method to execute.
	 * 
	 * @param instance   the instance to execute the method over
	 * @param _methName  the methodname
	 * @param _params    the parameters of the method
	 * @return the result of the method execution
	 * @throws SecurityException     if access to the information is denied.
	 * @throws NoSuchMethodException if the method is not found
	 * @throws IllegalArgumentException (@link java.lang.reflect.Method#invoke(java.lang.Object, java.lang.Object[]))
	 * @throws IllegalAccessException   (@link java.lang.reflect.Method#invoke(java.lang.Object, java.lang.Object[])) 
	 * @throws InvocationTargetException (@link java.lang.reflect.Method#invoke(java.lang.Object, java.lang.Object[]))
	 */
	public static Object execute( Object instance, String _methName, Object... _params) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
		Class<?>[] _paramsClass = null;
		if( _params != null) {
			_paramsClass = new Class[ _params.length];
			for (int i = 0; i < _paramsClass.length; i++) {
				_paramsClass[i] = _params[i].getClass();
			}
		}

		java.lang.reflect.Method meth = instance.getClass().getMethod(_methName, _paramsClass);

		// If the method is protected or private makes it accessible for execution
		boolean disableAccess = false;
		if( !meth.isAccessible()){
			meth.setAccessible( true);
			disableAccess = true;
		}

		Object res =  meth.invoke(instance, _params);

		if(disableAccess){
			meth.setAccessible( false);
		}

		return res;
	}

	/**
	 * Executes (@link Method#execute(Object, String, Object[])) transforming the _param into an array of objects. 
	 * @param instance   the instance to execute the method over
	 * @param _methName  the methodname
	 * @param _param     the parameter of the method
	 * @return the result of the method execution
	 * @throws SecurityException     if access to the information is denied.
	 * @throws NoSuchMethodException if the method is not found
	 * @throws IllegalArgumentException (@link java.lang.reflect.Method#invoke(java.lang.Object, java.lang.Object[]))
	 * @throws IllegalAccessException   (@link java.lang.reflect.Method#invoke(java.lang.Object, java.lang.Object[])) 
	 * @throws InvocationTargetException (@link java.lang.reflect.Method#invoke(java.lang.Object, java.lang.Object[]))
	 */
	public static Object execute( Object instance, String _methName, Object _param) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {

		return MethodUtil.execute( instance, _methName, new Object[]{ _param});
	}
}
