package util.security;

// TODO: Auto-generated Javadoc
/**
 * The Class PasswordGenerator.
 */
public class PasswordGenerator {
  /*
   * Set of characters that is valid. Must be printable, memorable, and "won't
   * break HTML" (i.e., not ' <', '>', '&', '=', ...). or break shell commands
   * (i.e., not ' <', '>', '$', '!', ...). I, L and O are good to leave out,
   * as are numeric zero and one.
   */
  /** The good char. */
  protected static char[] goodChar = { 'a', 'b', 'c', 'd', 'e', 'f', 'g',
      'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w',
      'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K',
      'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
      '2', '3', '4', '5', '6', '7', '8', '9', '+', '-', '@', };

  /** Minimum length for a decent password. */
  public static final int MIN_LENGTH = 10;

  /** The random number generator. */
  protected static java.util.Random r = new java.util.Random();

  /**
   * Generate password with length 10 by default.
   *
   * @return the password
   */
  public static String getPassword() {
    return getPassword(MIN_LENGTH);
  }
  
  /**
   * Generate Password with length specified.
   * @param length the password length
   * @return the generated password.
   */
  public static String getPassword(int length) {
	  StringBuffer sb = new StringBuffer();
	    for (int i = 0; i < length; i++) {
	      sb.append(goodChar[r.nextInt(goodChar.length)]);
	    }
	    return sb.toString();
  }

  /**
   * The main method.
   *
   * @param argv the arguments
   */
  public static void main(String[] argv) {
    for (int i = 0; i < 20; i++) {
      System.out.println(PasswordGenerator.getPassword());
      System.out.println(PasswordGenerator.getPassword(30));
    }
  }
}
