/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All righsts reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */

package util.sql;

import java.util.ArrayList;
import java.util.ListIterator;

// TODO: Auto-generated Javadoc
/**
 * Oracle implementation of the <i>order by</i> clause process.
 * 
 * @author Ricardo Correia de Oliveira <a
 *         href="mailto:roliveira@digitalis.pt">roliveira@digitalis.pt</a><br />
 * @author Daniel Alexandre Campelo <a
 *         href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 * 
 *         Created on Jan 20, 2004
 */
public class OracleOrderByClause extends OrderByClause {

	/** The Constant serialVersionUID. */
	static final long serialVersionUID = -875342316124299464L;

	/**
	 * 
	 * Oracle's SQL representation of the <i>ascendent</i> mode.
	 */
	protected final String ASC_SQL = " ASC ";
	/**
	 * Oracle's SQL representation of the <i>descendent</i> mode.
	 */
	protected final String DESC_SQL = " DESC ";
	/**
	 * Oracle's SQL representation of the order by command.
	 */
	private final String ORDERBY_CLAUSE = "order by";

	/**
	 * Creates a <i>new order</i> by process instance.
	 * 
	 * @param maxProps
	 *            the total number of properties
	 */
	public OracleOrderByClause(int maxProps) {
		props = new ArrayList<NameModeValue>(maxProps);
	}

	/**
	 * Gets the pager query.
	 * 
	 * @return the pager query
	 * @see util.sql.OrderByClause#getPagerQuery() Returns a new instance of the
	 *      paging system with the values of this instance (Oracle
	 *      implementation)
	 */
	@Override
	public PagerQuery getPagerQuery() {
		return new OraclePagerQuery(this.getNumPages(), this.getRowsPerPage());
	}

	/**
	 * Gets the pager query.
	 * 
	 * @param numPages
	 *            the num pages
	 * @param rowsPerPage
	 *            the rows per page
	 * @return the pager query
	 * @see util.sql.OrderByClause#getPagerQuery(int,int) Returns a new instance
	 *      of the paging system (Oracle implementation)
	 */
	@Override
	public PagerQuery getPagerQuery(int numPages, int rowsPerPage) {
		return new OraclePagerQuery(numPages, rowsPerPage);
	}

	/**
	 * Gets the query order by clause.
	 * 
	 * @param query
	 *            the query to get the order by clause from
	 * @return the order by clause of the specified query
	 * @see util.sql.OrderByClause#getQueryOrderByClause(java.lang.String)
	 */
	@Override
	protected String getQueryOrderByClause(String query) {
		if (!this.hasOrderByClause(query)) {
			return "";
		}
		// TODO ALTERAR CODIGO PARA VERIFICAR SE EXISTE MAIS ALGUMA CLAUSULA
		// DEPOIS DO ORDER BY
		return query.substring(query.toLowerCase().indexOf(
				ORDERBY_CLAUSE.toLowerCase()));
	}

	/**
	 * Checks for order by clause.
	 * 
	 * @param query
	 *            the query to process
	 * @return true if query has an <i>order by</i> clause
	 * @see util.sql.OrderByClause#hasOrderByClause(java.lang.String)
	 */
	@Override
	protected boolean hasOrderByClause(String query) {
		return (query.toLowerCase().indexOf(ORDERBY_CLAUSE.toLowerCase()) != -1);
	}

	/**
	 * Process order by clause.
	 * 
	 * @return the order by clause with the attributes
	 * @see util.sql.OrderByClause#processOrderByClause()
	 */
	@Override
	public String processOrderByClause() {
		return processOrderByClause("");
	}

	/**
	 * Process order by clause.
	 * 
	 * @param orderBy
	 *            adds the attributes to the given <i>order by</i> clause
	 * @return the <i>order by</i> clause with the attributes
	 * @see util.sql.OrderByClause#processOrderByClause(java.lang.String)
	 */
	@Override
	public String processOrderByClause(String orderBy) {
		StringBuffer buf = new StringBuffer(orderBy);
		// Verifica se a clausula de orderby passada ? invalida e se n?o tem
		// propriedades
		if (orderBy.equals("") && this.props.size() == 0) {
			// N?o gera a clausula. DADOS INSUFICIENTES
			return "";
		} else if (orderBy.equals("")) {
			// Se n?o foi indicada a clausula de order by
			buf.append(" " + ORDERBY_CLAUSE + " ");
		} else if (props.size() > 0) {
			// A clausula de order by tem pelo menos um campo indicado e existe
			// pelo menos uma propriedade a adicionar
			buf.append(", ");
		}

		// TODO Verificar se a clausula de order by ? v?lida

		String separator = "";

		ListIterator<NameModeValue> lIter = props.listIterator();
		while (lIter.hasNext()) {
			// Obtem o nome do campo
			NameModeValue nameMode = lIter.next();
			if (nameMode != null) {
				// Adiciona o nome dos campos e o modo de ordena??o ? clausula
				buf.append(separator + nameMode.getAttr() + " "
						+ nameMode.getMode());
				// Verifica se o separador de campos foi inicializado
				if (separator.equals("")) {
					separator = ",";
				}
			}
		}
		// Devolve a clausula
		return buf.toString() + " ";
	}

	/**
	 * Strip order by clause.
	 * 
	 * @param query
	 *            the query to process
	 * @return the query with out the order by clause
	 * @see util.sql.OrderByClause#stripOrderByClause(java.lang.String)
	 */
	@Override
	protected String stripOrderByClause(String query) {
		if (!this.hasOrderByClause(query)) {
			return query;
		}
		// TODO ALTERAR CODIGO PARA VERIFICAR SE EXISTE MAIS ALGUMA CLAUSULA
		// DEPOIS DO ORDER BY
		return query.substring(0,
				query.toLowerCase().indexOf(ORDERBY_CLAUSE.toLowerCase()));
	}

	/**
	 * Translate mode.
	 * 
	 * @param modeCod
	 *            code to translate
	 * @return the SQL mode that corresponds to the given mode cod
	 * @see util.sql.OrderByClause#translateMode(java.lang.String)
	 */
	@Override
	protected String translateMode(String modeCod) {
		if (modeCod.equals(this.DESCEND)) {
			return this.ASC_SQL;
		} else if (modeCod.equals(this.ASCEND)) {
			return this.DESC_SQL;
		}
		return "";
	}
}