/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All righsts reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */
package util.sql;

// TODO: Auto-generated Javadoc
/** 
 * Oracle implementation of the paging system.
 * 
 * @author Ricardo Correia de Oliveira <a href="mailto:roliveira@digitalis.pt">roliveira@digitalis.pt</a><br />
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 * 
 * Created on Jan 21, 2004
 */
public class OraclePagerQuery extends PagerQuery {
	/**
	 * Creates a new pager system with the specified values.
	 * @param pageNum     the page number
	 * @param rowsPerPage number of itens per page
	 */
	public OraclePagerQuery(int pageNum, int rowsPerPage){
		this.setNumList( pageNum);
		this.setRowsPerPage( rowsPerPage);
	}
	
	/**
	 * Gets the end query.
	 *
	 * @return Oracle SQL of the final part of the paging system
	 * @see util.sql.PagerQuery#getEndQuery()
	 */
	protected String getEndQuery() {
		int startInd = ((this.getNumList()-1)*this.getRowsPerPage());
		return ") q) where numCol between "+(startInd+1)+" and "+(startInd+this.getRowsPerPage())+" ";
	}

	/**
	 * Gets the end query for total pages.
	 *
	 * @return Oracle SQL of the final part of the total pages count system.
	 * @see util.sql.PagerQuery#getEndQueryForTotalPages()
	 */
	protected String getEndQueryForTotalPages() {
		return ")";
	}

	/**
	 * Gets the inits the query.
	 *
	 * @return Oracle SQL of the initial part of the paging system
	 * @see util.sql.PagerQuery#getInitQuery()
	 */
	protected String getInitQuery() {
		return "select * from ( select rownum numCol, q.* from ( ";
	}

	/**
	 * Gets the inits the query for total pages.
	 *
	 * @return Oracle SQL of the inicial part of the total pages count system.
	 * @see util.sql.PagerQuery#getInitQueryForTotalPages()
	 */
	protected String getInitQueryForTotalPages() {
		/**
		 * TODO EFECTUAR A LIMPEZA DA QUERY
		 * 				Basta from e where para obter o total dos registos
		 */
		return "select floor(count(*)/"+this.getRowsPerPage()+") from ( ";
	}
}