/**
 * 1994-2003 Digitalis Informatica. All righsts reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de
 * Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package util.sql;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;

import oracle.jdbc.OracleResultSet;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;

import org.jboss.resource.adapter.jdbc.WrappedResultSet;

import util.StringUtil;

// TODO: Auto-generated Javadoc
/**
 * Set of utility methods to help the manipulation for the Oracle Database.
 * 
 * @author rmartins <a href="mailto:ruimartins@digitalis.pt">ruimartins@digitalis.pt</a><br />
 *         Created on Mar 7, 2005
 */
public class OracleUtilDBFunctions implements UtilDBFunctions {

    /** The instance. */
    private static OracleUtilDBFunctions instance = null;

    /** The Constant Q_IGNORE_ACCENTS_QUERY. */
    private static final String Q_IGNORE_ACCENTS_QUERY = " TRANSLATE (UPPER(@field_name),'','AEIOUAEIOUCAA')"
            + " LIKE '@start'|| TRANSLATE (UPPER (?),'','AEIOUAEIOUCAA') || '@end' ";
    static
    {
        OracleUtilDBFunctions.instance = new OracleUtilDBFunctions();
    }

    /**
     * Gets the single instance of OracleUtilDBFunctions.
     * 
     * @return single instance of OracleUtilDBFunctions
     */
    public static OracleUtilDBFunctions getInstance()
    {
        return OracleUtilDBFunctions.instance;
    }

    /**
     * Instantiates a new oracle util db functions.
     */
    private OracleUtilDBFunctions()
    {}

    /**
     * @see util.sql.UtilDBFunctions#getBlobByID(java.sql.Connection, java.lang.String, java.util.HashMap,
     *      java.lang.String)
     */
    public byte[] getBlobByID(Connection con, String tableName, HashMap<String, String> fieldName, String fieldBlob)
            throws SQLException
    {
        byte[] blobData = null;
        PreparedStatement ps = null;
        String whereStr = "";
        String whereCond = "";
        Iterator<String> it = fieldName.keySet().iterator();
        Iterator<String> itVal = fieldName.values().iterator();
        try
        {
            // Get the Large Object Manager to perform operations with
            while (it.hasNext() && itVal.hasNext())
            {
                whereStr = whereStr + whereCond + " " + it.next().toString() + " = '" + itVal.next().toString() + "'";
                whereCond = " and ";
            }
            String getBlobQuery = "SELECT " + fieldBlob + " FROM " + tableName + " WHERE " + whereStr;
            ps = con.prepareStatement(getBlobQuery);
            // ps.setString(1, idValue);
            ResultSet rs = ps.executeQuery();
            if (rs != null && rs.next())
            {
                // Open the large object for reading
                Blob blob = rs.getBlob(1);
                if (blob != null)
                {
                    blobData = blob.getBytes(1, (int) blob.length());
                }
            }
        }
        catch (SQLException e)
        {
            throw e;
        }
        finally
        {
            try
            {
                ps.close();
            }
            catch (Throwable t)
            {
            }
        }
        return blobData;
    }

    /**
     * Implements the specificy code necessary to get an Blob Object of a field for a specific table by the fieldId of
     * the table.
     * 
     * @param con
     *            Connection of database
     * @param tableName
     *            name of the table
     * @param fieldName
     *            the name of the ID field
     * @param idValue
     *            value of ID
     * @param fieldBlob
     *            the name of the blob field
     * @return byte[] the blob data value
     * @throws SQLException
     *             the sQL exception
     */
    public byte[] getBlobByID(Connection con, String tableName, String fieldName, String idValue, String fieldBlob)
            throws SQLException
    {
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();

        fieldNameMap.put(fieldName, idValue);

        return getBlobByID(con, tableName, fieldNameMap, fieldBlob);
    }

    /**
     * @see util.sql.UtilDBFunctions#getErrorMessage(java.lang.String)
     */
    public String getErrorMessage(String errorMessage)
    {
        return StringUtil.subString("ORA-[0-9]+: (.*?)(ORA-(.*)|$)", errorMessage, 1, Pattern.MULTILINE);
    }

    /**
     * Obtem array para inserir como parametro para uma stored procedure.
     * 
     * @param conn
     *            coneco
     * @param arrayName
     *            nome do array
     * @param elemnts
     *            elementos
     * @return O array com o elementos.
     * @throws SQLException
     *             the sQL exception
     */

    public Array getInputArray(Connection conn, String arrayName, String[] elemnts) throws SQLException
    {
        /*
         * ArrayDescriptor needs the original connection, in this case the oracle connection. If we use the
         * WrappedConnection a ClassCastException is throw
         */
        Connection oracleConn = conn.getMetaData().getConnection();
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(arrayName, oracleConn);
        return new ARRAY(arrayDescriptor, oracleConn, elemnts);
    }

    /**
     * Gets a SQL string comparation using <i>like</i> that is case insentive and that ignores the accents on the
     * strings.
     * 
     * @param fieldName
     *            the nane of the field
     * @return a string comparer
     */
    public String ignoreAcentsQuery(String fieldName)
    {
        /*
         * return " TRANSLATE (UPPER("+fieldName+"),'','AEIOUAEIOUCAA')" +
         * " LIKE '%'|| TRANSLATE (UPPER (?),'','AEIOUAEIOUCAA') || '%' ";
         */
        return (replaceIgnoreAcentsQueryKeys("%", "%", fieldName));
    }

    /**
     * @see util.sql.UtilDBFunctions#putBlobByID(java.sql.Connection, java.lang.String, java.util.HashMap,
     *      java.lang.String, byte[])
     */
    @SuppressWarnings("deprecation")
    public void putBlobByID(Connection con, String tableName, HashMap<String, String> fieldName, String fieldBlob,
            byte[] blobData) throws SQLException
    {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String whereStr = "";
        String whereCond = "";
        Iterator<String> it = fieldName.keySet().iterator();
        Iterator<String> itVal = fieldName.values().iterator();
        try
        {
            while (it.hasNext() && itVal.hasNext())
            {
                whereStr = whereStr + whereCond + " " + it.next().toString() + " = '" + itVal.next().toString() + "'";
                whereCond = " and ";
            }
            String putBlobQuery = "SELECT " + fieldBlob + " FROM " + tableName + " WHERE " + whereStr + " FOR UPDATE ";
            ps = con.prepareStatement(putBlobQuery);
            // ps.setString(1, idValue);
            rs = ps.executeQuery();
            if (rs.next())
            {
                BLOB blob = ((OracleResultSet) ((WrappedResultSet) rs).getUnderlyingResultSet()).getBLOB(1);
                // limpa os bytes do blob caso existam.
                if (blob != null && blobData != null)
                {
                    blob.trim(0);
                    OutputStream outstream = blob.getBinaryOutputStream();
                    outstream.write(blobData);
                    outstream.flush();
                    outstream.close();
                }
            }
            else
            {
                System.out.println("Nao encontrou o registo ");
            }
        }
        catch (SQLException e)
        {
            throw e;
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
        finally
        {
            try
            {
                ps.close();
                rs.close();
            }
            catch (Throwable t)
            {
            }
        }
    }

    /**
     * Implements the specificy code necessary to set an Blob Object to a field for a specific table by the fieldId of
     * the table.
     * 
     * @param con
     *            Connection of database
     * @param tableName
     *            name of the table
     * @param fieldName
     *            the name of the ID field
     * @param idValue
     *            value of ID
     * @param fieldBlob
     *            the name of the blob field
     * @param blobData
     *            the blobData value
     * @throws SQLException
     *             the sQL exception
     */
    public void putBlobByID(Connection con, String tableName, String fieldName, String idValue, String fieldBlob,
            byte[] blobData) throws SQLException
    {
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();

        fieldNameMap.put(fieldName, idValue);

        putBlobByID(con, tableName, fieldNameMap, fieldBlob, blobData);
    }

    /**
     * Replace ignore acents query keys.
     * 
     * @param start
     *            the start
     * @param end
     *            the end
     * @param fieldName
     *            the field name
     * @return the string
     */
    private String replaceIgnoreAcentsQueryKeys(String start, String end, String fieldName)
    {
        String query = new String(Q_IGNORE_ACCENTS_QUERY);
        query = query.replaceAll("@field_name", fieldName);
        query = query.replaceAll("@start", start);
        return (query.replaceAll("@end", end));
    }

    /**
     * Gets a SQL string comparation using <i>like</i> that is case insentive, that ignores the accents on the strings.
     * Also the query should match where the field value starts with the defined Statement object parameter.
     * 
     * @param fieldName
     *            the name of the field
     * @return a string comparer
     */
    public String startsWithIgnoreAcentsQuery(String fieldName)
    {
        return (replaceIgnoreAcentsQueryKeys("", "%", fieldName));
    }
}
