/**
 * 1994-2003 Digitalis Informatica. All righsts reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de
 * Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package util.sql;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

// TODO: Auto-generated Javadoc
/**
 * Set of utility methods to help the manipulation for the PostGreSQL Database.
 * 
 * @author rmartins Created on jun 24, 2005
 */

public class PGUtilDBFunctions implements UtilDBFunctions {

    /** The instance. */
    private static PGUtilDBFunctions instance = null;

    /**
     * Gets a SQL string comparation using <i>like</i> that is case insentive and that ignores the accents on the
     * strings.
     */
    private static final String Q_IGNORE_ACCENTS_QUERY = " TRANSLATE (UPPER(@field_name),'','AEIOUAEIOUCAA')"
            + " LIKE '@start'|| TRANSLATE (UPPER (?),'','AEIOUAEIOUCAA') || '@end' ";
    static
    {
        PGUtilDBFunctions.instance = new PGUtilDBFunctions();
    }

    /**
     * Gets the single instance of PGUtilDBFunctions.
     * 
     * @return single instance of PGUtilDBFunctions
     */
    public static PGUtilDBFunctions getInstance()
    {
        return PGUtilDBFunctions.instance;
    }

    /**
     * Instantiates a new pG util db functions.
     */
    private PGUtilDBFunctions()
    {}

    /**
     * @see util.sql.UtilDBFunctions#getBlobByID(java.sql.Connection, java.lang.String, java.util.HashMap,
     *      java.lang.String)
     */
    @SuppressWarnings("deprecation")
    public byte[] getBlobByID(Connection con, String tableName, HashMap<String, String> fieldName, String fieldBlob)
            throws SQLException
    {
        byte[] blobData = null;
        PreparedStatement ps = null;
        String whereStr = "";
        String whereCond = "";
        Iterator<String> fieldNameIteractor = fieldName.keySet().iterator();
        try
        {
            // All LargeObject API calls must be within a transaction block
            con.setAutoCommit(false);
            // Get the Large Object Manager to perform operations with

            LargeObjectManager lobj = ((PGConnection) ((WrappedConnection) con).getUnderlyingConnection())
                    .getLargeObjectAPI();

            while (fieldNameIteractor.hasNext())
            {
                String fieldNameKey = fieldNameIteractor.next().toString();
                whereStr = whereStr + whereCond + " " + fieldNameKey + " = '" + fieldName.get(fieldNameKey) + "'";
                whereCond = " and ";
            }
            String getBlobQuery = "SELECT " + fieldBlob + " FROM " + tableName + " WHERE " + whereStr;
            ps = con.prepareStatement(getBlobQuery);
            // ps.setString(1, idValue);
            ResultSet rs = ps.executeQuery();
            if (rs != null && rs.next())
            {
                // Open the large object for reading
                int oid = rs.getInt(1);
                if (oid > 0)
                {
                    LargeObject obj = lobj.open(oid, LargeObjectManager.READ);
                    // Read the data
                    blobData = new byte[obj.size()];
                    obj.read(blobData, 0, obj.size());
                    // Close the object
                    obj.close();
                }
                rs.close();
            }
        }
        catch (SQLException e)
        {
            throw e;
        }
        finally
        {
            try
            {
                ps.close();
            }
            catch (Throwable t)
            {
            }
        }
        return blobData;
    }

    /**
     * Implements the specificy code necessary to get an Blob Object of a field for a specific table by the fieldId of
     * the table.
     * 
     * @param con
     *            Connection of database
     * @param tableName
     *            name of the table
     * @param fieldName
     *            the name of the ID field
     * @param idValue
     *            value of ID
     * @param fieldBlob
     *            the name of the blob field
     * @return byte[] the blob data value
     * @throws SQLException
     *             the sQL exception
     */
    public byte[] getBlobByID(Connection con, String tableName, String fieldName, String idValue, String fieldBlob)
            throws SQLException
    {
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();

        fieldNameMap.put(fieldName, idValue);

        return getBlobByID(con, tableName, fieldNameMap, fieldBlob);
    }

    /**
     * @see util.sql.UtilDBFunctions#getErrorMessage(java.lang.String)
     */
    public String getErrorMessage(String errorMessage)
    {

        return errorMessage;
    }

    /**
     * @see util.sql.UtilDBFunctions#getInputArray(java.sql.Connection, java.lang.String, java.lang.String[])
     */
    public Array getInputArray(Connection conn, String arrayName, String[] elemnts) throws SQLException
    {
        return null;
    }

    /**
     * Gets a SQL string comparation using <i>like</i> that is case insentive and that ignores the accents on the
     * strings.
     * 
     * @param fieldName
     *            the nane of the field
     * @return a string comparer
     */
    public String ignoreAcentsQuery(String fieldName)
    {
        return (replaceIgnoreAcentsQueryKeys("%", "%", fieldName));
    }

    /**
     * @see util.sql.UtilDBFunctions#putBlobByID(java.sql.Connection, java.lang.String, java.util.HashMap,
     *      java.lang.String, byte[])
     */
    @SuppressWarnings("deprecation")
    public void putBlobByID(Connection con, String tableName, HashMap<String, String> fieldName, String fieldBlob,
            byte[] blobData) throws SQLException
    {
        PreparedStatement ps = null;
        String whereStr = "";
        String whereCond = "";
        Iterator<String> fieldNameIteractor = fieldName.keySet().iterator();
        try
        {
            // All LargeObject API calls must be within a transaction block
            con.setAutoCommit(false);
            while (fieldNameIteractor.hasNext())
            {
                // Bug 7883
                // whereStr = whereStr + whereCond + " " +
                // fieldName.keySet().iterator().next().toString() + " =
                // '"+fieldName.values().iterator().next().toString()+"'";
                String fieldNameKey = fieldNameIteractor.next().toString();
                whereStr = whereStr + whereCond + " " + fieldNameKey + " = '" + fieldName.get(fieldNameKey) + "'";
                whereCond = " and ";
            }
            String putBlobQuery = "update " + tableName + " set " + fieldBlob + " = ? where " + whereStr;
            LargeObjectManager lobj = ((PGConnection) ((WrappedConnection) con).getUnderlyingConnection())
                    .getLargeObjectAPI();
            // Create a new large object
            int oid = lobj.create(LargeObjectManager.READ | LargeObjectManager.WRITE);
            // Open the large object for writing
            LargeObject obj = lobj.open(oid, LargeObjectManager.WRITE);
            obj.write(blobData, 0, blobData.length);
            // Close the large object
            obj.close();
            ps = con.prepareStatement(putBlobQuery);
            ps.setInt(1, oid);
            // ps.setString(2, idValue);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e)
        {
            throw e;
        }
        finally
        {
            try
            {
                ps.close();
            }
            catch (Throwable t)
            {
            }
        }
    }

    /**
     * Implements the specificy code necessary to set an Blob Object to a field for a specific table by the fieldId of
     * the table.
     * 
     * @param con
     *            Connection of database
     * @param tableName
     *            name of the table
     * @param fieldName
     *            the name of the ID field
     * @param idValue
     *            value of ID
     * @param fieldBlob
     *            the name of the blob field
     * @param blobData
     *            the blobData value
     * @throws SQLException
     *             the sQL exception
     */
    public void putBlobByID(Connection con, String tableName, String fieldName, String idValue, String fieldBlob,
            byte[] blobData) throws SQLException
    {
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();

        fieldNameMap.put(fieldName, idValue);

        putBlobByID(con, tableName, fieldNameMap, fieldBlob, blobData);
    }

    /**
     * Replace ignore acents query keys.
     * 
     * @param start
     *            the start
     * @param end
     *            the end
     * @param fieldName
     *            the field name
     * @return the string
     */
    private String replaceIgnoreAcentsQueryKeys(String start, String end, String fieldName)
    {
        String query = new String(Q_IGNORE_ACCENTS_QUERY);
        query = query.replaceAll("@field_name", fieldName);
        query = query.replaceAll("@start", start);
        return (query.replaceAll("@end", end));
    }

    /**
     * Gets a SQL string comparation using <i>like</i> that is case insentive, that ignores the accents on the strings.
     * Also the query should match where the field value starts with the defined Statement object parameter.
     * 
     * @param fieldName
     *            the name of the field
     * @return a string comparer
     */
    public String startsWithIgnoreAcentsQuery(String fieldName)
    {
        return (replaceIgnoreAcentsQueryKeys("", "%", fieldName));
    }

}
