/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All righsts reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */

package util.sql;

// TODO: Auto-generated Javadoc
/**
 * Prepares the paging system.
 * 
 * @author Ricardo Correia de Oliveira <a href="mailto:roliveira@digitalis.pt">roliveira@digitalis.pt</a><br />
 * @author Daniel Alexandre Campelo <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 * 
 * Created on Jan 21, 2004
 */
public abstract class PagerQuery {
	/**
	 * Page number.
	 */
	private int numList = 1;
	/**
	 * Number of itens per page.
	 * Defaults to <code>1000</code>.
	 */
	private int rowsPerPage = 1000;

	/**
	 * Gets the final part of the paging system.
	 * @return the final part of the paging system.
	 */
	protected abstract String getEndQuery();
	/**
	 * Gets the final part of the total pages count system.
	 * @return the final part of the total pages count system
	 */
	protected abstract String getEndQueryForTotalPages();
	/**
	 * Gets the inicial part of the paging system.
	 * @return the inicial part of the paging system
	 */
	protected abstract String getInitQuery();

	/**
	 * Gets the inicial part of the total pages count system.
	 * @return the inicial part of the total pages count system.
	 */
	protected abstract String getInitQueryForTotalPages();
	/**
	 * Gets the page number.
	 * @return the page number
	 */
	public int getNumList() {
		return numList;
	}
	/**
	 * Gets the number of itens per page.
	 * @return number of itens per page
	 */
	public int getRowsPerPage() {
		return rowsPerPage;
	}
	
	/**
	 * Gets the total number of pages based on the defined number of itens per page and the specified total number of itens.
	 * @param numRows total number of rows
	 * @return the total number of pages
	 */
	public int getTotalPages(long numRows){
		if(numRows <= 0){
			return 0;
		}
		return (int)Math.ceil( (float)numRows/(float)this.getRowsPerPage());
	}
	/**
	 * Processes the query to obtain the rows that are in range.
	 * @param query  the query to process
	 * @return the processed query
	 */
	public String processQuery(String query){
		return this.getInitQuery()+" "+query+" "+this.getEndQuery();
	}

	/**
	 * Processes the query to obtain the total number of pages.
	 * @param query the query to process
	 * @return the processed query
	 */
	public String processQueryForTotalPages(String query){
		return this.getInitQueryForTotalPages()+" "+query+" "+this.getEndQueryForTotalPages();
	}

	/**
	 * Sets the page number.
	 * @param i the page number
	 */
	public void setNumList(int i) {
		if(i > 0){
			numList = i;
		}
	}

	/**
	 * Sets the number of itens page.
	 * @param i the number of itens page.
	 */
	public void setRowsPerPage(int i) {
		if(i > 0){
			rowsPerPage = i;
		}
	}
}