/**
 * 1994-2003 Digitalis Informatica. All righsts reserved.
 *
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt
 *
 */

package util.sql;

import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;

// TODO: Auto-generated Javadoc
/**
 * Set of utility methods to help the manipulation for the Database.
 *
 * @author rmartins
 * Created on jun 24, 2005
 */

public interface UtilDBFunctions {

	/**
	 * Gets the blob by id.
	 *
	 * @param con the con
	 * @param tableName the table name
	 * @param fieldNameMap the field name map
	 * @param fieldBlob the field blob
	 * @return the blob by id
	 * @throws SQLException the sQL exception
	 */
	public byte[] getBlobByID(Connection con, String tableName, HashMap<String,String> fieldNameMap, String fieldBlob) throws SQLException;

	/**
	 * Implements the specificy code necessary to get an Blob Object of a field for a specific table
	 * by the fieldId of the table.
	 *
	 * @param con Connection of database
	 * @param tableName name of the table
	 * @param fieldName the name of the ID field
	 * @param idValue value of ID
	 * @param fieldBlob the name of the blob field
	 * @return byte[] the blob data value
	 * @throws SQLException the sQL exception
	 */
	public byte[] getBlobByID(Connection con, String tableName, String fieldName, String idValue, String fieldBlob) throws SQLException;

	/**
	 * Handles the database error message so that the codes are striped and no more then the last error level is shown.
	 * @param errorMessage the message to handle
	 * @return the last level message
	 */
	public String getErrorMessage(String errorMessage);

	/**
	 * Obt�m array para inserir como parametro para uma stored procedure.
	 *
	 * @param conn conec��o
	 * @param arrayName nome do array
	 * @param elemnts elementos
	 * @return O array com o elementos.
	 * @throws SQLException the sQL exception
	 */
	public Array getInputArray(Connection conn, String arrayName, String[] elemnts) throws SQLException;

	/**
	 * Gets a SQL string comparation using <i>like</i> that is case insentive and that ignores the accents on the strings.
	 * @param fieldName the nane of the field
	 * @return a string comparer
	 */
	public String ignoreAcentsQuery(String fieldName);

	/**
	 * Put blob by id.
	 *
	 * @param con the con
	 * @param tableName the table name
	 * @param fieldName the field name
	 * @param fieldBlob the field blob
	 * @param blobData the blob data
	 * @throws SQLException the sQL exception
	 */
	public void putBlobByID(Connection con, String tableName, HashMap<String,String> fieldName, String fieldBlob, byte[] blobData) throws SQLException;

	/**
	 * Implements the specificy code necessary to set an Blob Object to a field for a specific table
	 * by the fieldId of the table.
	 *
	 * @param con Connection of database
	 * @param tableName name of the table
	 * @param fieldName the name of the ID field
	 * @param idValue value of ID
	 * @param fieldBlob the name of the blob field
	 * @param blobData  the blobData value
	 * @throws SQLException the sQL exception
	 */
	public void putBlobByID(Connection con, String tableName, String fieldName, String idValue, String fieldBlob, byte[] blobData) throws SQLException;

	/**
	 * Gets a SQL string comparation using <i>like</i> that is case insentive, that ignores the accents on the strings and should match where the field value starts with the given prefix.
	 *
	 * @param fieldName the name of the field
	 * @return a string comparer
	 */
	public String startsWithIgnoreAcentsQuery(String fieldName);
}
