package util.system;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

// TODO: Auto-generated Javadoc
/**
 * The Class BaseConfigurations.
 * 
 * @author Galaio da Silva<jgalaio@digitalis.pt>
 * @date 27/07/2009
 * @since 10.2.5
 */
public abstract class BaseConfigurations {

    /**
     * The Class Obsolet.
     */
    public class Obsolet {

        /** the new propertie name. */
        private String newPropertie;

        /** the old propertie name. */
        private String oldPropertieName;

        /**
         * The constructor for <code>Obsolet</code>.
         * 
         * @param oldPropertieName
         *            the old propertie name.
         * @param newPropertie
         *            the new propertie name.
         */
        public Obsolet(String oldPropertieName, String newPropertie)
        {
            super();
            this.oldPropertieName = oldPropertieName;
            this.newPropertie = newPropertie;
        }

        /**
         * Gets the new propertie.
         * 
         * @return the newPropertie
         */
        public String getNewPropertie()
        {
            return newPropertie;
        }

        /**
         * Gets the old propertie name.
         * 
         * @return the oldPropertieName
         */
        public String getOldPropertieName()
        {
            return oldPropertieName;
        }

        /**
         * Sets the new propertie.
         * 
         * @param newPropertie
         *            the newPropertie to set
         */
        public void setNewPropertie(String newPropertie)
        {
            this.newPropertie = newPropertie;
        }

        /**
         * Sets the old propertie name.
         * 
         * @param oldPropertieName
         *            the oldPropertieName to set
         */
        public void setOldPropertieName(String oldPropertieName)
        {
            this.oldPropertieName = oldPropertieName;
        }
    }

    /** The defauld value for property. */
    private String defautValue;
    // TODO: Luis - Se hover necessidade modificar properties, deve-se adaptar este funcionamento nas restantes classes
    // que leem .properties
    /** The obsolet. */
    public ArrayList<Obsolet> obsolet = new ArrayList<Obsolet>();

    /** The Off value for property. */
    private String offValue;

    /** The On value for property. */
    private String onValue;

    /** The properties for this configuration. */
    public Properties properties = null;

    /** The properties fileName. */
    private String propertiesFileName = null;

    /**
     * Gets the defaut value.
     * 
     * @return the defautValue
     */
    public String getDefautValue()
    {
        return defautValue;
    }

    /**
     * Get the declared obsolet propertie.
     * 
     * @return <code>ArrayList</code> of <code>Configuration</code>
     */
    public abstract ArrayList<Obsolet> getObsolet();

    /**
     * Gets the off value.
     * 
     * @return the offValue
     */
    public String getOffValue()
    {
        return offValue;
    }

    /**
     * Gets the on value.
     * 
     * @return the onValue
     */
    public String getOnValue()
    {
        return onValue;
    }

    /**
     * Gets the properties file name.
     * 
     * @return the propertiesFileName
     */
    public String getPropertiesFileName()
    {
        return propertiesFileName;
    }

    /**
     * Gets the property.
     * 
     * @param name
     *            the property name.
     * @return the propriety.
     */
    public String getProperty(String name)
    {
        return this.properties.getProperty(name);
    }

    /**
     * Get the Configuration for parameter:.
     */
    public void init()
    {
        try
        {
            this.properties = SystemUtil.getResourceAsProperties(this.propertiesFileName);
            ArrayList<Obsolet> obsoletList = getObsolet();
            for (Obsolet obsolet: obsoletList)
            {
                if (this.properties.containsKey(obsolet.getOldPropertieName()))
                {
                    String value = this.properties.getProperty(obsolet.getOldPropertieName());
                    this.properties.remove(obsolet.getOldPropertieName());
                    this.properties.put(obsolet.getNewPropertie(), value);
                }
            }
        }
        catch (IOException e)
        {
            this.properties = new Properties();
        }
    }

    /**
     * Saves the properties into the properties file.
     * 
     * @throws IOException
     *             Signals that an I/O exception has occurred.
     */
    public void saveConfigurations() throws IOException
    {
        FileOutputStream out = null;
        try
        {
            String headerText = "";
            out = new FileOutputStream(SystemUtil.getResourceAsFile(this.getPropertiesFileName(), null));
            out.write(headerText.getBytes());
            this.properties.store(out, null);
            out.flush();
        }
        finally
        {
            if (out != null)
            {
                out.close();
            }
        }
    }

    /**
     * Sets the defaut value.
     * 
     * @param defautValue
     *            the defautValue to set
     */
    public void setDefautValue(String defautValue)
    {
        this.defautValue = defautValue;
    }

    /**
     * Sets the off value.
     * 
     * @param offValue
     *            the offValue to set
     */
    public void setOffValue(String offValue)
    {
        this.offValue = offValue;
    }

    /**
     * Sets the on value.
     * 
     * @param onValue
     *            the onValue to set
     */
    public void setOnValue(String onValue)
    {
        this.onValue = onValue;
    }

    /**
     * Sets the properties file name.
     * 
     * @param propertiesFileName
     *            the propertiesFileName to set
     */
    public void setPropertiesFileName(String propertiesFileName)
    {
        this.propertiesFileName = propertiesFileName;
    }

    /**
     * Sets the specified property to be writed to configuration file at the end of execution.
     * 
     * @param name
     *            the propriety name.
     * @param value
     *            the property value.
     */
    public void setProperty(String name, String value)
    {
        this.properties.setProperty(name, value);
    }
}
