/**
 * First created between November and December 2003
 *
 * 1994-2003 Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 * 
 */
package util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

// TODO: Auto-generated Javadoc
/**
 * Set of utility methods to help the retrieval of data from a XML document. 
 * 
 * @author Daniel Alexandre Campelo  <a href="mailto:dcampelo@digitalis.pt">dcampelo@digitalis.pt</a><br />
 */
public class XMLUtil {

	// TODO : Commented as it is not used (or at least it shouldn't!!)
	
//	/**
//	 * Gets an attribute of the element at a given position if the XML document.
//	 * @deprecated As this method does not make use of the XPath API
//	 * @param doc    the XML document
//	 * @param module the element name
//	 * @param attr   the attribute name to get the value from
//	 * @param index  the element position
//	 * @return the value of the attribute or null if not found
//	 */
//	public static String getModuleAttribute( Document doc, String module, String attr, int index){
//	  //Obtem o valor do atributo
//	  return XMLUtil.getModuleAttribute( doc.getDocumentElement(), module, attr, index);
//	}
//	
//	/**
//	 * Obtem o attributo 'attr' do registo na posio 'index' do modulo 'module'
//	 * @deprecated
//	 * @param elem
//	 * @param module
//	 * @param attr
//	 * @param index
//	 * @return
//	 */
//	public static String getModuleAttribute( Element elem, String module, String attr, int index){
//	  //Obtem o elemento do grupo de resultados
//
//	  Element modElem = XMLUtil.getElement( elem, module);
//
//	  // Verifica se o elemento correspondente ao modulo foi encontrado
//	  if(modElem == null){
//	  	return null;
//	  }
//	  //Obtem o valor do atributo
//	  return XMLUtil.getSubElementAttributeValue( modElem, attr, index);
//	}
//
//	/**
//	 * Procura por um sub-elemento de <code>baseElem</code> 
//	 * que tenha o nome <code>elemName</code> e que se encontre 
//	 * na posio indicado por <code>index</code>.
//	 * 
//	 * @deprecated
//	 * @param baseElem
//	 * @param elemName
//	 * @param index
//	 * @return O elemento ou <code>null</code> se no encontrado
//	 */
//	public synchronized static Element getElement( Document doc, String elemName, int index){
//		return getElement( doc.getDocumentElement(), elemName, index);
//	}
//
//	/**
//	 * Procura por um sub-elemento de <code>baseElem</code> 
//	 * que tenha o nome <code>elemName</code> e que se encontre 
//	 * na posio indicado por <code>index</code>.
//	 * 
//	 * @deprecated
//	 * @param baseElem
//	 * @param elemName
//	 * @param index
//	 * @return O elemento ou <code>null</code> se no encontrado
//	 */
//	public synchronized static Element getElement( Element baseElem, String elemName, int index){
//		Element elemRes = null;
//		//Verifica se o elemento pedido  o que foi passado
//		if(baseElem.getNodeName().equals( elemName)){
//			elemRes = baseElem;
//		}else{
//			//Obtem a lista dos elementos com o nome igual ao pedido
//			NodeList list = baseElem.getElementsByTagName( elemName);
//
//			// Obtem a ocorrencia do proximo elemento na lista 
//			if(list != null){
//				//Verifica se existe algum elemento com o nome indicado
//				int pos = XMLUtil.getNextElementPos(list, index);
//				//Obtem o elemento da posio desejada, ou null se no existir nenhum
//				//elemento na posio especificada
//				if(pos != -1){
//					elemRes = (Element)list.item( pos);
//				}
//			}
//		}
//		//Devolve o elemento encontrado, ou null se o modulo base no for encontrado ou no existir nenhum elemento na posio indicada
//		return elemRes;
//	}
//	
//	/**
//	 * Procura por um sub-elemento de <code>baseElem</code> 
//	 * que tenha o nome <code>elemName</code> e que se encontre 
//	 * na posio indicado por <code>index</code>.
//	 * O mesmo que <code>getElement( baseElem, elemName, 0);</code>
//	 * 
//	 * @deprecated
//	 * @param baseElem
//	 * @param elemName
//	 * @return O elemento ou <code>null</code> se no encontrado
//	 */
//	public static Element getElement( Document doc, String elemName){
//		return getElement( doc.getDocumentElement(), elemName);
//	}
//	
//	/**
//	 * Procura por um sub-elemento de <code>baseElem</code> 
//	 * que tenha o nome <code>elemName</code> e que se encontre 
//	 * na posio indicado por <code>index</code>.
//	 * O mesmo que <code>getElement( baseElem, elemName, 0);</code>
//	 * 
//	 * @deprecated
//	 * @param baseElem
//	 * @param elemName
//	 * @return O elemento ou <code>null</code> se no encontrado
//	 */
//	public static Element getElement( Element baseElem, String elemName){
//		//Devolve o elemento encontrado
//		return XMLUtil.getElement( baseElem, elemName, 0);
//	}
//	
//	/**
//	 * Obtem o conteudo de um determinado
//	 * 
//	 * @deprecated
//	 * @param elem
//	 * @param elemName
//	 * @param index
//	 * @return o valor interno do elemento ou null se o elemento no existir. 
//	 */
//	public static String getElementValue( Element elem, String elemName, int index){
//		Element elemRes = XMLUtil.getElement( elem, elemName, index);
//		String value;
//		if(elemRes != null) {
//			value = elemRes.getFirstChild().getNodeValue();
//		} else {
//			value = null;
//		}
//		return value;
//	}
//	/**
//	 * Obtem o conteudo de um determinado. O mesmo que <code>XMLUtil.getElementValue( elem, elemName, 0);</code>
//	 * 
//	 * @deprecated
//	 * @param elem
//	 * @param elemName
//	 * @return o valor interno do elemento ou null se o elemento no existir. 
//	 */
//	public static String getElementValue( Element elem, String elemName){
//		return XMLUtil.getElementValue( elem, elemName, 0);
//	}
//
//	/**
//	 * Obtem o attributo de um determinado elemento. 
//	 * 
//	 * @deprecated
//	 * @param elem
//	 * @param baseElement
//	 * @param attrName
//	 * @param index
//	 * @return o valor do attributo, ou null se o elemento ou o attributo no existir.
//	 */
//	public static String getAttributeValue(Element elem, String baseElement, String attrName, int index){
//		Element elemRes = XMLUtil.getElement( elem, baseElement, index);
//		String attr = null;
//		if(elemRes != null){
//			attr = elemRes.getAttribute( attrName);
//		}
//		return attr;
//	}
//	/**
//	 * Obtem o attributo de um determinado elemento. O mesmo que <code>XMLUtil.getAttributeValue(elem, baseElement, attrName, 0);</code>
//	 * 
//	 * @deprecated
//	 * @param elem
//	 * @param baseElement
//	 * @param attrName
//	 * @return
//	 */
//	public static String getAttributeValue(Element elem, String baseElement, String attrName){
//		return XMLUtil.getAttributeValue(elem, baseElement, attrName, 0);
//	}
//	
//	/**
//	 * Obtem os subElementos de um determinado elemento
//	 * 
//	 * @deprecated
//	 * @param elem
//	 * @param elemName
//	 * @return o subelemento do elemento pedido.
//	 */
//	public static NodeList getSubElements(Document doc, String elemName){
//		return XMLUtil.getSubElements( doc.getDocumentElement(), elemName);
//	}
//	
//	/**
//	 * Obtem os subElementos de um determinado elemento
//	 * 
//	 * @deprecated
//	 * @param elem
//	 * @param elemName
//	 * @return o subelemento do elemento pedido.
//	 */
//	public static NodeList getSubElements(Element elem, String elemName){
//		if(elem == null) return null;
//		Element elemT = XMLUtil.getElement(elem, elemName);
//		if( elemT != null){
//			return elemT.getChildNodes();
//		}
//		return null;
//	}
//
//	/**
//	 * Obtem os subElementos de um determinado elemento
//	 * 
//	 * @deprecated
//	 * @param elem
//	 * @param elemName
//	 * @return o subelemento do elemento pedido.
//	 */
//	public static int countSubElements(Element elem, String elemName){
//		if(elem == null) return 0;
//		Element elemT = XMLUtil.getElement(elem, elemName);
//
//		if( elemT != null){
//			NodeList list = elemT.getChildNodes();
//			
//			// Verifica se contem child nodes
//			if(list != null){
//				int counter = 0;
//				for(int index=0 ; index!=-1 ; counter++){
//					index = getNextElementPos( list, counter);
//				}
//				return counter;
//			}
//		}
//		return 0;
//	}
//
//	/**
//	 * Obtem o attributo de um determinado elemento.
//	 * 
//	 * @deprecated
//	 * @param elem
//	 * @param baseElement
//	 * @param attrName
//	 * @param index
//	 * @return o valor do attributo, ou null se o elemento ou o attributo no existir.
//	 */
//	public static String getSubElementAttributeValue(Element elem, String attrName, int index){
//		if(elem == null ) return null;
//		NodeList childs = elem.getChildNodes();
//		
//		if(childs == null){
//			return null;
//		}
//		
//		int pos = XMLUtil.getNextElementPos( childs, index);
//		
//		String attr = null;
//		if(pos != -1){
//			Element elemRes = (Element)childs.item( pos);
//			attr = elemRes.getAttribute( attrName);
//		}
//		return attr;
//	}
//
//	/**
//	 * Obtem o attributo de um determinado elemento. O mesmo que <code>XMLUtil.getAttributeValue(elem, baseElement, attrName, 0);</code>
//	 * 
//	 * @deprecated
//	 * @param elem
//	 * @param baseElement
//	 * @param attrName
//	 * @return
//	 */
//	public static String getSubElementAttributeValue(Element elem, String attrName){
//		return XMLUtil.getSubElementAttributeValue(elem, attrName, 0);
//	}
//
//	/**
//	 * 
//	 * @deprecated
//	 * @param elem
//	 * @param index
//	 * @return A descrio do 'index' subelemento
//	 */
//	public static String getSubElementDescription(Element elem, int index){
//		if(elem == null ) return null;
//		// Obtem todos os subElementos
//		NodeList childs = elem.getChildNodes();
//		if(childs == null){
//			return null;
//		}
//		// Verifica qual a posio na lista do elemento pretendido
//		int pos = XMLUtil.getNextElementPos( childs, index);
//		
//		String attr = null;
//		
//		// Verifica se existe o elemento pedido
//		if(pos != -1){
//			// Obtem-se os sub nodes do elemento
//			Element elemRes = (Element)childs.item( pos);
//
//			NodeList nodes = elemRes.getChildNodes();
//
//			if(nodes == null){
//				return null;
//			}
//
//			// Percorre-se os nodes para obter a descrio do elemento
//			for(int i=0;i<nodes.getLength() && attr == null ;i++){
//				Node node = nodes.item( i);
//
//				//Verifica se  o node que contem a descrio
//				if(node.getNodeType() == Node.TEXT_NODE){
//					// Obtem a descrio 
//					attr = node.getNodeValue();
//				}
//			}
//		}
//		return attr;
//	}
//	/**
//	 * @deprecated
//	 * @param elem
//	 * @return A descrio do primeiro subelemento
//	 */
//	public static String getSubElementDescription(Element elem){
//		return getSubElementDescription(elem, 0);
//	}
//	/**
//	 * Obtem a posio do proximo Elemento na nodelist.
//	 * 
//	 * @deprecated
//	 * @param list
//	 * @param startIndex
//	 * @return
//	 */
//	 public static int getNextElementPos(NodeList list, int elemNum){
//		int nextIndex = -1;
//		int counter = 0;
//		int startPos;
//		
//		// Verifica se a lista contem algum elemento
//		if(list == null || list.getLength() == 0){
//			return -1;
//		}
//
//		// Procura pelo index onde se encontra o elemento 'elemNum'
//		for(startPos = 0 ; startPos < list.getLength() && counter<elemNum; startPos++){
//			Node node = list.item( startPos);
//			if(node.getNodeType() == Node.ELEMENT_NODE){
//				counter++;
//			}
//		}
//
//		// Obtem o elemento seguinte
//		for(int i = startPos ; i<list.getLength() && nextIndex == -1 ; i++){
//			Node node = list.item( i);
//			if(node.getNodeType() == Node.ELEMENT_NODE){
//				nextIndex = i;
//			}
//		}
//		return nextIndex;
//	}

	/**
	 * Gets the number of <code>Nodes</code> that correspond to the XPath criteria.
	 * @param _node the node to use as context node, base node for relative XPath
	 * @param path  the path for the attribute (XPath)
	 * @return the number of <code>nodes</code>.
	 * @throws TransformerException if an error occur while processing the path over the XML
	 */
	public static int countElements( Node _node, String path)throws TransformerException{
		try{
			String xpath = path;
			if(xpath.indexOf("count(") != 0){
				 xpath = "count("+xpath+")";
			 }

			return (int)XPathAPI.eval( _node, xpath).num();
		} catch(NullPointerException npe){
			return -1;
		}
	}

	/**
	 * Gets the string representation of the result of the XPath over the XML.
	 * Best used with XPath functions
	 * @param _node the node to use as context node, base node for relative XPath
	 * @param path  the XPath to process
	 * @return the result of the XPath
	 * @throws TransformerException if an error occur while processing the path over the XML
	 */
	public static String eval( Node _node, String path)throws TransformerException{
		return XPathAPI.eval(_node, path).toString();
	}
	/**
	 * Gets the value of the path specified attribute.
	 * The value is obtained throught the <code>getNodeValue</code> method of the <code>Node</code> class.
	 * 
	 * @param _node the node to use as context node, base node for relative XPath
	 * @param path  the path for the attribute (XPath)
	 * @return the value of the node specified by the path
	 * @throws TransformerException if an error occur while processing the path over the XML
	 */
	public static String getElementAttrValue( Node _node, String path)throws TransformerException{
		try{
			Node node = XPathAPI.selectSingleNode( _node, path);
			return node.getNodeValue();
		} catch(NullPointerException npe){
			return null;
		}
	}

	/**
	 * Gets the value of the path specified attribute.
	 * The value is obtained throught the <code>getNodeValue</code> method of the <code>Node</code> class.
	 * 
	 * @param _node the node to use as context node, base node for relative XPath
	 * @param path  the path for the attribute (XPath)
	 * @param defaultValue the default value to return if the value marked by the path is null or not available
	 * @return the value of the node specified by the path
	 * @throws TransformerException if an error occur while processing the path over the XML
	 */
	public static String getElementAttrValue( Node _node, String path, String defaultValue)throws TransformerException{
		try{
			String value = getElementAttrValue(_node, path);
			if(value == null){
				return defaultValue;
			} else {
				return value;
			}
		} catch(NullPointerException npe){
			return defaultValue;
		}
	}
	/**
	 * Gets the number of <code>Nodes</code> that correspond to the XPath criteria.
	 * @param _node the node to use as context node, base node for relative XPath
	 * @param path  the path for the attribute (XPath)
	 * @return the number of <code>nodes</code>.
	 * @throws TransformerException if an error occur while processing the path over the XML
	 */
	public static NodeList getElements( Node _node, String path) throws TransformerException{
		return XPathAPI.selectNodeList( _node, path);
	}
	
	/**
	 * Gets the element's <code>text</code> specified by the path.
	 * Adds the "<code>/text()</code>" XPath function call to the specified path, no validation is made, so the function must not be set on the path parameter
	 * 
	 * @param _node the node to use as context node, base node for relative XPath
	 * @param path  the element to get the text from (XPath)
	 * @return the text element's value or null if no text is defined for the element or the element is not found
	 * @throws TransformerException if an error occur while processing the path over the XML
	 */
	public static String getElementText(Node _node, String path) throws TransformerException{
		try{
			Node node = XPathAPI.selectSingleNode( _node, path+"/text()");
			return node.getNodeValue();
		} catch(NullPointerException npe){
			return null;
		}
	}
    
    /**
	 * Creates a new 'empty' document.
	 * @return a new document
	 * @throws ParserConfigurationException if an error occur during the creation of the new document
	 */
	public static Document getNewDocument() throws  ParserConfigurationException {
		Document doc = null;
		//Obtem a fabrica de construtores de documentos
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		//Obtem um novo construtor de documentos
		DocumentBuilder docBuilder = factory.newDocumentBuilder();
		doc = docBuilder.newDocument();
		return doc;
	}
	
	/**
	 * Gets the <code>Node</code> refered by the path.
	 * @param _node the node to use as context node, base node for relative XPath
	 * @param path  the path for the element (XPath)
	 * @return the node
	 * @throws TransformerException if an error occur while processing the path over the XML
	 */
	public static Node getNode( Node _node, String path)throws TransformerException{
		return XPathAPI.selectSingleNode( _node, path);
	}

	/**
	 * Gets the <code>Element</code> refered by the path. 
	 * @param _node the node to use as context node, base node for relative XPath
	 * @param path  the path for the element (XPath)
	 * @return the element
	 * @throws TransformerException if an error occur while processing the path over the XML
	 */
	public static Element getNodeElement( Node _node, String path)throws TransformerException{
		return (Element)getNode( _node, path);
	}
	
	/**
	 * Loads a XML document from a file.
	 *
	 * @param _path the file location (path)
	 * @return the document representation
	 * @throws IOException if an error occur during the load of the file content
	 * @throws SAXException if an error occur while loading/parsing the file
	 * @throws ParserConfigurationException if an error occur during the preparation of the XML parser
	 * @see #readDocument(InputStream)
	 */
	public static Document openDocument(String _path) throws  IOException, SAXException, ParserConfigurationException {
		InputStream in = new FileInputStream(new File( _path));
		Document doc = null;

		try{
			doc = readDocument( in);

		}finally{
			try{ in.close();
			} catch(Throwable t){}
		}
		return doc;
	}
	/**
	 * Loads a XML document from a stream.
	 * @param _in the stream to read the XML content from
	 * @return the document representation
	 * @throws IOException if an error occur during the reading of the stream content
	 * @throws SAXException if an error occur while loading/parsing the file
	 * @throws ParserConfigurationException if an error occur during the preparation of the XML parser
	 */
	public static Document readDocument(InputStream _in) throws  IOException, SAXException, ParserConfigurationException {
		Document doc = null;
		//Obtem a fabrica de construtores de documentos
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		//Obtem um novo construtor de documentos
		DocumentBuilder docBuilder = factory.newDocumentBuilder();

		doc = docBuilder.parse( _in);

		return doc;
	}
	
	/**
	 * Loads a XML document from a stream.
	 *
	 * @param _in the stream to read the XML content from
	 * @param systemId the system id
	 * @return the document representation
	 * @throws IOException if an error occur during the reading of the stream content
	 * @throws SAXException if an error occur while loading/parsing the file
	 * @throws ParserConfigurationException if an error occur during the preparation of the XML parser
	 */
	public static Document readDocument(InputStream _in, String systemId) throws  IOException, SAXException, ParserConfigurationException {
		Document doc = null;
		//Obtem a fabrica de construtores de documentos
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		//Obtem um novo construtor de documentos
		DocumentBuilder docBuilder = factory.newDocumentBuilder();

		doc = docBuilder.parse( _in, systemId);

		return doc;
	}
	/**
	 * Loads a XML document from a stream.
	 * @param _in the stream to read the XML content from
	 * @return the document representation
	 * @throws IOException if an error occur during the reading of the stream content
	 * @throws SAXException if an error occur while loading/parsing the file
	 * @throws ParserConfigurationException if an error occur during the preparation of the XML parser
	 */
	public static Document readDocument(Reader _in) throws  IOException, SAXException, ParserConfigurationException {
		Document doc = null;
		//Obtem a fabrica de construtores de documentos
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		//Obtem um novo construtor de documentos
		DocumentBuilder docBuilder = factory.newDocumentBuilder();

		doc = docBuilder.parse( new InputSource(_in));

		return doc;
	}

	/**
	* Gets the string representation of the XML node.
	*  
	* @param node  node to get the string represntation
	* @return the string representation
	* @throws IOException if an error occur while processing the XML to string format
	*/
	public static String toString(Node node) throws  IOException {
		StringWriter writer		= new StringWriter();
		XMLSerializer serial	= new XMLSerializer();
		OutputFormat format	= new OutputFormat();

		serial.setOutputCharStream(writer);
		format.setPreserveSpace(true);
		serial.setOutputFormat(format);
	
		if( node.getNodeType() == Node.DOCUMENT_NODE ) {
			serial.serialize((Document)node);
		}
		else {
			serial.serialize((Element)node);
		}
		return writer.toString();
	}
	/**
	* Gets the string representation of the XML node.
	*  
	* @param node  node to get the string represntation
    * @param encoding the character encoding name to be used
	* @return the string representation
	* @throws IOException if an error occur while processing the XML to string format
	*/
	public static String toString(Node node, String encoding ) throws  IOException {
		StringWriter writer		= new StringWriter();
		XMLSerializer serial	= new XMLSerializer();
		OutputFormat format	= new OutputFormat();

		serial.setOutputCharStream(writer);
		format.setPreserveSpace(true);
        format.setEncoding( encoding );
		serial.setOutputFormat(format);
	
		if( node.getNodeType() == Node.DOCUMENT_NODE ) {
			serial.serialize((Document)node);
		}
		else {
			serial.serialize((Element)node);
		}
		return writer.toString();
	}
}