/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities;

import pt.digitalis.dif.controller.http.HTTPControllerConfiguration;
import pt.digitalis.dif.controller.security.managers.IAuthorizationManager;
import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.annotations.Registrable;
import pt.digitalis.dif.dem.annotations.entities.ApplicationDefinition;
import pt.digitalis.dif.dem.annotations.security.Group;
import pt.digitalis.dif.dem.annotations.security.User;
import pt.digitalis.dif.dem.annotations.stage.Init;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.manager.RegistrationManagerException;
import pt.digitalis.dif.exception.security.AuthorizationManagerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.presentation.config.PresentationConfiguration;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.RuleGroupException;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.netqa.model.netQAFactory;
import pt.digitalis.netqa.rules.NetQAFlow;
import pt.digitalis.netqa.rules.NetQARules;
import pt.digitalis.netqa.rules.exceptions.NetQAException;
import pt.digitalis.siges.SIGESAppRegistrationUtils;
import pt.digitalis.siges.cmenet.business.definitions.Catalog;
import pt.digitalis.siges.cmenet.business.session.CMEnetDDMSession;
import pt.digitalis.siges.entities.cmenet.config.ConfigCMEService;
import pt.digitalis.siges.entities.csenet.situacaoaluno.GestaoSituacaoDeAlunoService;
import pt.digitalis.siges.model.SIGESFactory;
import pt.digitalis.siges.presentation.utils.NetPAExecutionContext;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;

@ApplicationDefinition(id="netqa", name="netQ@", provider="digitalis")
@Registrable(defaultRegisterName="Digitalis Inform\u00e1tica")
@Group(groupName="QualidadeBackOffice", fullName="Grupo dos utilizadores da \u00e1rea da Qualidade")
@User(userName="qualidade", fullName="User \u00e1rea qualidade", profile="QualidadeBackOffice")
public class NetQAApplication {
    @Init
    public void init() throws NetQAException, BusinessException, RegistrationManagerException, MissingContextException, RuleGroupException, DataSetException, AuthorizationManagerException, ConfigurationException {
        HTTPControllerConfiguration controllerConfig = HTTPControllerConfiguration.getInstance();
        controllerConfig.setShowSubFooter(Boolean.valueOf(false));
        controllerConfig.setRegistrationActive(Boolean.valueOf(false));
        NetPAExecutionContext.setContext((NetPAExecutionContext)NetPAExecutionContext.NETQA_QUALIDADE);
        CMEnetDDMSession.addEmptyProfilesToSession = true;
        netQAFactory.getSession();
        SIGESFactory.getSession(null);
        NetQARules.getInstance();
        NetQAFlow.getInstance();
        PresentationConfiguration presentationConfiguration = PresentationConfiguration.getInstance();
        presentationConfiguration.setTheme("light");
        HTTPControllerConfiguration httpConfiguration = HTTPControllerConfiguration.getInstance();
        httpConfiguration.setShowSubFooter(Boolean.valueOf(true));
        httpConfiguration.setRegistrationActive(Boolean.valueOf(false));
        Catalog.registerDashboards();
        try {
            IConfigurations config = (IConfigurations)DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class);
            config.writeConfiguration((Object)presentationConfiguration);
            config.writeConfiguration((Object)httpConfiguration);
        }
        catch (Exception e) {
            DIFLogger.getLogger().warn((Object)"[CMEnet] Could not save customized preferences");
            e.printStackTrace();
        }
        SIGESAppRegistrationUtils.autoRegistoSeAppBORegistada((String)"CSE", (String)"csenet");
        SIGESAppRegistrationUtils.autoRegistoSeAppBORegistada((String)"CSD", (String)"fcdnet");
        SIGESAppRegistrationUtils.autoRegistoSeAppBORegistada((String)"CSD", (String)"csdnet");
        IAuthorizationManager authManager = (IAuthorizationManager)DIFIoCRegistry.getRegistry().getImplementation(IAuthorizationManager.class);
        authManager.grantDefaultAccessToGroup("QualidadeBackOffice", Entity.SERVICE, GestaoSituacaoDeAlunoService.class.getSimpleName());
        authManager.grantDefaultAccessToGroup("Administrators", Entity.SERVICE, ConfigCMEService.class.getSimpleName());
    }
}

