/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.admin;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.dif.controller.security.managers.IAuthorizationManager;
import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.dataminer.definition.Area;
import pt.digitalis.dif.dataminer.definition.DashboardManager;
import pt.digitalis.dif.dataminer.definition.IIndicator;
import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.parameter.InjectParameterErrors;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.annotations.parameter.Rule;
import pt.digitalis.dif.dem.annotations.parameter.Rules;
import pt.digitalis.dif.dem.annotations.presentation.OnAJAX;
import pt.digitalis.dif.dem.annotations.presentation.OnAJAXSubmit;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.InjectMessages;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.dem.managers.IDEMManager;
import pt.digitalis.dif.dem.objects.parameters.errors.ParameterErrors;
import pt.digitalis.dif.exception.security.AuthorizationManagerException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.presentation.ajax.IJSONResponse;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseComboBox;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetGrid;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.ICalcField;
import pt.digitalis.dif.presentation.views.jsp.taglibs.objects.beans.Option;
import pt.digitalis.dif.utils.extensions.document.DocumentRepositoryEntry;
import pt.digitalis.dif.utils.extensions.document.DocumentRepositoryException;
import pt.digitalis.dif.utils.extensions.document.IDocumentRepositoryManager;
import pt.digitalis.netqa.entities.admin.calcs.NodeActions;
import pt.digitalis.netqa.entities.admin.calcs.NodeDescCalc;
import pt.digitalis.netqa.entities.frontoffice.FrontofficePrivateService;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractFrontOfficeStage;
import pt.digitalis.netqa.entities.integrations.IntegrationsPrivateService;
import pt.digitalis.netqa.entities.reports.ReportsPrivateService;
import pt.digitalis.netqa.model.InetQAService;
import pt.digitalis.netqa.model.data.UONode;
import pt.digitalis.netqa.netQAConfigurations;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;

@StageDefinition(name="netQ@ Configuration", service="NetQAAdminService")
@View(target="netqa/admin/config.jsp")
@Callback
public class ConfigNetQA
extends AbstractFrontOfficeStage {
    @Inject
    protected IAuthorizationManager authorizationManager;
    @Parameter(constraints="required", defaultValue="22", linkToForm="config")
    protected Long calendarEndHour;
    @Parameter(constraints="required", defaultValue="8", linkToForm="config")
    protected Long calendarStartHour;
    @Inject
    protected IConfigurations configurations;
    @Inject
    protected InetQAService dbnetQAService;
    @Inject
    protected IDEMManager demManager;
    @Inject
    protected IDocumentRepositoryManager documentRepositoryManager;
    @InjectParameterErrors
    protected ParameterErrors errors;
    @Parameter(constraints="required", linkToForm="config")
    protected String filtrarListasPorRegenciaModo;
    @Parameter(linkToForm="config")
    protected Boolean forceProprietarySSOForNodes;
    @Parameter(constraints="required", linkToForm="nodeDetailForm")
    protected Boolean formNodeActive;
    @Parameter(linkToForm="nodeDetailForm")
    protected String formNodeDescription;
    @Parameter(constraints="required", linkToForm="nodeDetailForm")
    protected String formNodeKeyword;
    @Parameter(constraints="required", linkToForm="nodeDetailForm")
    protected String formNodeName;
    @Parameter(linkToForm="nodeDetailForm", constraints="max=999")
    protected Number formNodePosition;
    @Parameter(constraints="required", linkToForm="nodeDetailForm")
    protected String formNodeURL;
    @Parameter(constraints="required", linkToForm="nodeDetailForm")
    protected Boolean formNodeVisible;
    @Parameter
    protected String grantAccessToDocentes;
    @Inject
    protected IIdentityManager identityManager;
    @Parameter(constraints="required", linkToForm="upload")
    protected DocumentRepositoryEntry image;
    @Parameter(linkToForm="config")
    protected String indicadorLinha1_left;
    @Parameter(linkToForm="config")
    protected String indicadorLinha1_left_title;
    @Parameter(linkToForm="config")
    protected String indicadorLinha1_right;
    @Parameter(linkToForm="config")
    protected String indicadorLinha1_right_title;
    @Parameter(linkToForm="config")
    protected String indicadorLinha2_left;
    @Parameter(linkToForm="config")
    protected String indicadorLinha2_left_title;
    @Parameter(linkToForm="config")
    protected String indicadorLinha2_right;
    @Parameter(linkToForm="config")
    protected String indicadorLinha2_right_title;
    @Parameter(linkToForm="config")
    protected String indicadorLinha3_left;
    @Parameter(linkToForm="config")
    protected String indicadorLinha3_left_title;
    @Parameter(linkToForm="config")
    protected String indicadorLinha3_right;
    @Parameter(linkToForm="config")
    protected String indicadorLinha3_right_title;
    @Parameter(linkToForm="config")
    protected String mainNetQAPlusServerBaseURL;
    @Parameter(linkToForm="config")
    @Rules(value={@Rule(ruleId="dependent", parameters="mainNetQAPlusServerBaseURL", value="PLUS_NODE"), @Rule(ruleId="dependent", parameters="forceProprietarySSOForNodes", value="PLUS_MAIN")})
    protected String mode;
    @Parameter(linkToForm="config")
    protected Boolean multiInstituicoesAtivas;
    @Parameter(constraints="required", linkToForm="upload")
    protected Long nodeID;
    @InjectMessages
    protected Map<String, String> stageMessages;

    @OnAJAX(value="changeAccess")
    public Boolean changeAccess() throws AuthorizationManagerException {
        if (this.grantAccessToDocentes != null) {
            Boolean grantAccess = Boolean.parseBoolean(this.grantAccessToDocentes);
            if (grantAccess.booleanValue()) {
                this.authorizationManager.grantAccessToGroup("docentes", Entity.SERVICE, FrontofficePrivateService.class.getSimpleName());
                this.authorizationManager.grantAccessToGroup("docentes", Entity.SERVICE, IntegrationsPrivateService.class.getSimpleName());
                this.authorizationManager.grantAccessToGroup("docentes", Entity.SERVICE, ReportsPrivateService.class.getSimpleName());
                this.context.addResultMessage("ok", this.stageMessages.get("acessoDocentes"), this.stageMessages.get("acessoDocentesGranted"), true, false);
            } else {
                this.authorizationManager.revokeAccessFromGroup("docentes", Entity.SERVICE, FrontofficePrivateService.class.getSimpleName());
                this.authorizationManager.revokeAccessFromGroup("docentes", Entity.SERVICE, IntegrationsPrivateService.class.getSimpleName());
                this.authorizationManager.revokeAccessFromGroup("docentes", Entity.SERVICE, ReportsPrivateService.class.getSimpleName());
                this.context.addResultMessage("ok", this.stageMessages.get("acessoDocentes"), this.stageMessages.get("acessoDocentesRevoked"), true, false);
            }
        }
        return true;
    }

    @Execute
    public void execute() throws AuthorizationManagerException, IdentityManagerException, ConfigurationException {
        netQAConfigurations c = netQAConfigurations.getInstance();
        this.filtrarListasPorRegenciaModo = c.getFiltrarListasPorRegenciaModo();
        this.multiInstituicoesAtivas = c.getMultiInstituicoesAtivas();
        this.calendarStartHour = c.getCalendarStartHour();
        this.calendarEndHour = c.getCalendarEndHour();
        this.indicadorLinha1_left = c.getIndicadorLinha1_left();
        this.indicadorLinha1_left_title = c.getIndicadorLinha1_left_title();
        this.indicadorLinha1_right = c.getIndicadorLinha1_right();
        this.indicadorLinha1_right_title = c.getIndicadorLinha1_right_title();
        this.indicadorLinha2_left = c.getIndicadorLinha2_left();
        this.indicadorLinha2_left_title = c.getIndicadorLinha2_left_title();
        this.indicadorLinha2_right = c.getIndicadorLinha2_right();
        this.indicadorLinha2_right_title = c.getIndicadorLinha2_right_title();
        this.indicadorLinha3_left = c.getIndicadorLinha3_left();
        this.indicadorLinha3_left_title = c.getIndicadorLinha3_left_title();
        this.indicadorLinha3_right = c.getIndicadorLinha3_right();
        this.indicadorLinha3_right_title = c.getIndicadorLinha3_right_title();
        this.mode = c.getMode();
        this.mainNetQAPlusServerBaseURL = c.getNetQAPlusMainServerBaseURL();
        this.forceProprietarySSOForNodes = c.getForceProprietarySSOForNodes();
        this.context.addStageResult("currentState", (Object)this.authorizationManager.hasAccessGroup(this.identityManager.getGroup("docentes"), Entity.SERVICE, FrontofficePrivateService.class.getSimpleName()));
    }

    @OnAJAX(value="indicadores")
    public IJSONResponse getIndicadores() {
        HashMap<String, String> indicators = new HashMap<String, String>();
        DashboardManager catalog = DashboardManager.getInstance((String)"CMEnetCatalogInstance");
        for (Area area : catalog.getAreas().values()) {
            for (IIndicator indicator : area.getIndicators().values()) {
                indicators.put(area.getId() + ":" + indicator.getId(), "[" + area.getTitle() + "] " + StringUtils.nvl((String)indicator.getGroupTitle(), (String)"").replace("|", " - ") + ": " + indicator.getTitle());
            }
        }
        JSONResponseComboBox response = new JSONResponseComboBox();
        response.setRecords(indicators);
        return response;
    }

    public List<Option<String>> getModeList() {
        ArrayList<Option<String>> list = new ArrayList<Option<String>>();
        list.add(new Option("NORMAL", (Object)this.stageMessages.get("mode.NORMAL")));
        StringBuffer mainDescBuffer = new StringBuffer();
        mainDescBuffer.append(this.stageMessages.get("mode.PLUS_MAIN"));
        mainDescBuffer.append("<br/><a href='javascript:configNodes();' class='leftPad25'>" + this.stageMessages.get("configNodes") + "</a>");
        list.add(new Option("PLUS_MAIN", (Object)mainDescBuffer.toString()));
        list.add(new Option("PLUS_NODE", (Object)this.stageMessages.get("mode.PLUS_NODE")));
        return list;
    }

    @OnAJAX(value="nodes")
    public IJSONResponse getNodes() {
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.dbnetQAService.getUONodeDataSet());
        response.setHandleRESTActions(true, true, true, true, null);
        response.addCalculatedField("desc", (ICalcField)new NodeDescCalc(this.context.getSession()));
        response.addCalculatedField("actions", (ICalcField)new NodeActions(this.stageMessages, this.context.getSession()));
        return response;
    }

    public List<Option<String>> getOptionsFiltrarListas() {
        ArrayList<Option<String>> list = new ArrayList<Option<String>>();
        list.add(new Option("1", (Object)this.stageMessages.get("filterOptions.semFiltro")));
        list.add(new Option("2", (Object)this.stageMessages.get("filterOptions.filtrarSempre")));
        return list;
    }

    public List<Option<String>> getSimNaoList() {
        ArrayList<Option<String>> list = new ArrayList<Option<String>>();
        list.add(new Option("true", (Object)this.stageMessages.get("yes")));
        list.add(new Option("false", (Object)this.stageMessages.get("no")));
        return list;
    }

    @OnAJAXSubmit(value="config")
    public void submitConfig() throws Exception {
        if (!this.errors.hasErrors()) {
            netQAConfigurations c = netQAConfigurations.getInstance();
            c.setFiltrarListasPorRegenciaModo(this.filtrarListasPorRegenciaModo);
            c.setMultiInstituicoesAtivas(this.multiInstituicoesAtivas);
            c.setCalendarStartHour(this.calendarStartHour);
            c.setCalendarEndHour(this.calendarEndHour);
            c.setIndicadorLinha1_left(this.indicadorLinha1_left);
            c.setIndicadorLinha1_left_title(this.indicadorLinha1_left_title);
            c.setIndicadorLinha1_right(this.indicadorLinha1_right);
            c.setIndicadorLinha1_right_title(this.indicadorLinha1_right_title);
            c.setIndicadorLinha2_left(this.indicadorLinha2_left);
            c.setIndicadorLinha2_left_title(this.indicadorLinha2_left_title);
            c.setIndicadorLinha2_right(this.indicadorLinha2_right);
            c.setIndicadorLinha2_right_title(this.indicadorLinha2_right_title);
            c.setIndicadorLinha3_left(this.indicadorLinha3_left);
            c.setIndicadorLinha3_left_title(this.indicadorLinha3_left_title);
            c.setIndicadorLinha3_right(this.indicadorLinha3_right);
            c.setIndicadorLinha3_right_title(this.indicadorLinha3_right_title);
            c.setMode(this.mode);
            c.setNetQAPlusMainServerBaseURL(this.mainNetQAPlusServerBaseURL);
            c.setForceProprietarySSOForNodes(this.forceProprietarySSOForNodes);
            this.configurations.writeConfiguration((Object)c);
        }
    }

    @OnAJAXSubmit(value="upload")
    protected void uploadReportImage() throws DocumentRepositoryException, DataSetException {
        UONode node;
        if (this.nodeID != null && this.image != null && (node = (UONode)this.dbnetQAService.getUONodeDataSet().get(this.nodeID.toString())) != null) {
            this.image = this.documentRepositoryManager.addDocument(this.image);
            node.setLogoDocumentId(this.image.getId());
            this.dbnetQAService.getUONodeDataSet().update((IBeanAttributes)node);
        }
    }
}

