/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.admin;

import com.google.inject.Inject;
import java.util.Map;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.annotations.presentation.OnAJAX;
import pt.digitalis.dif.dem.annotations.presentation.OnAJAXSubmit;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.InjectMessages;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.dem.managers.impl.model.IReportManagerService;
import pt.digitalis.dif.dem.objects.parameters.types.StringArray;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Sort;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.presentation.ajax.IJSONResponse;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetComboBox;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetGrid;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.ICalcField;
import pt.digitalis.dif.utils.extensions.document.DocumentRepositoryEntry;
import pt.digitalis.dif.utils.extensions.document.DocumentRepositoryException;
import pt.digitalis.dif.utils.extensions.document.IDocumentRepositoryManager;
import pt.digitalis.dif.utils.identity.IdentityManagerCache;
import pt.digitalis.netqa.entities.admin.calcs.ReportActions;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractFrontOfficeStage;
import pt.digitalis.netqa.model.InetQAService;
import pt.digitalis.netqa.model.data.Report;
import pt.digitalis.utils.common.IBeanAttributes;

@StageDefinition(name="netQ@ Reports Configuration", service="NetQAAdminService")
@View(target="netqa/admin/configReports.jsp")
@Callback
public class ConfigReports
extends AbstractFrontOfficeStage {
    @Parameter(constraints="required", linkToForm="categoriesForm")
    protected String categoriesFormDescription;
    @Parameter(linkToForm="categoriesForm")
    protected Long categoriesFormId;
    @Parameter(constraints="required", linkToForm="edit")
    protected Long categorytId;
    @Parameter(constraints="maxsize=4000", linkToForm="edit")
    protected String description;
    @Parameter(constraints="required", linkToForm="upload")
    protected DocumentRepositoryEntry document;
    @Parameter(constraints="required", linkToForm="upload")
    protected Long documentReportId;
    @Inject
    protected IDocumentRepositoryManager documentRepositoryManager;
    @Parameter(linkToForm="edit")
    protected Long id;
    @Parameter(linkToForm="edit")
    protected Long jasperReportId;
    @Inject
    protected InetQAService netQAService;
    @Inject
    protected IReportManagerService reportManagerService;
    @Parameter(constraints="maxsize=4000", linkToForm="edit")
    protected StringArray restrictAccessToGroups;
    @InjectMessages
    protected Map<String, String> stageMessages;
    @Parameter(constraints="required,maxsize=200", linkToForm="edit")
    protected String titleCol;
    @Parameter(linkToForm="edit")
    protected Boolean visible;

    @OnAJAX(value="generateReport")
    protected Boolean generateReport() throws BusinessException {
        throw new BusinessException("Not implemented yet!");
    }

    @OnAJAX(value="categories")
    public IJSONResponse getCategories() {
        JSONResponseDataSetComboBox response = new JSONResponseDataSetComboBox((IDataSet)this.netQAService.getReportCategoryDataSet(), "description");
        return response;
    }

    @OnAJAX(value="categoriesForEdit")
    public IJSONResponse getCategoriesForEdit() {
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.netQAService.getReportCategoryDataSet());
        response.setHandleRESTActions(true, true, true, true, null);
        response.addDefaultSort(new Sort(SortMode.ASCENDING, "description"));
        return response;
    }

    @OnAJAX(value="reports")
    public IJSONResponse getReports() {
        String[] fields = new String[]{"id", "title", "description", "visible", "documentId", "jasperReportId", "restrictAccessToGroups", Report.FK().reportCategory().ID(), Report.FK().reportCategory().DESCRIPTION()};
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.netQAService.getReportDataSet(), fields);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Report.FK().reportCategory(), JoinType.NORMAL);
        response.setHandleRESTActions(true, true, true, true, null);
        response.addCalculatedField("actions", (ICalcField)new ReportActions(this.stageMessages, this.context.getSession()));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, Report.FK().reportCategory().DESCRIPTION()));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "id"));
        return response;
    }

    @OnAJAX(value="reporttemplates")
    public IJSONResponse getReportTemplates() {
        JSONResponseDataSetComboBox response = new JSONResponseDataSetComboBox((IDataSet)this.reportManagerService.getJasperReportTemplateDataSet(), "title");
        response.addFilter(new Filter("isEnabled", FilterType.EQUALS, "true"));
        return response;
    }

    @OnAJAX(value="usergroups")
    public IJSONResponse getUserGroups() throws IdentityManagerException, DataSetException {
        JSONResponseDataSetComboBox response = new JSONResponseDataSetComboBox((IDataSet)IdentityManagerCache.getGroupsCache((boolean)false), "name");
        return response;
    }

    @OnAJAXSubmit(value="upload")
    protected void uploadReportDocument() throws DataSetException, DocumentRepositoryException {
        Report report;
        if (this.documentReportId != null && this.document != null && (report = (Report)this.netQAService.getReportDataSet().get(this.documentReportId.toString())) != null) {
            this.document = this.documentRepositoryManager.addDocument(this.document);
            report.setDocumentId(this.document.getId());
            this.netQAService.getReportDataSet().update((IBeanAttributes)report);
        }
    }
}

