/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice;

import javax.servlet.http.HttpServletRequest;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.annotations.presentation.OnAJAX;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.Init;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Sort;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.presentation.ajax.IJSONResponse;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetGrid;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.AbstractCalcField;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.ICalcField;
import pt.digitalis.netqa.entities.frontoffice.InstituicaoStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractFrontOfficeStage;
import pt.digitalis.netqa.netQAConfigurations;
import pt.digitalis.siges.entities.csenet.situacaoaluno.GestaoSituacaoDeAluno;
import pt.digitalis.siges.entities.csenet.situacaoaluno.GestaoSituacaoDeAlunoDocentes;
import pt.digitalis.siges.model.data.cse.Alunos;
import pt.digitalis.siges.model.data.cse.Histalun;
import pt.digitalis.siges.model.storedprocs.SIGESStoredProcedures;
import pt.digitalis.siges.users.preferences.NetpaUserPreferences;
import pt.digitalis.siges.users.preferences.NetpaUserPreferencesException;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;

@StageDefinition(name="Alunos", service="FrontofficePrivateService")
@View(target="netqa/frontoffice/alunos.jsp")
@Callback
public class AlunosStage
extends AbstractFrontOfficeStage {
    @Parameter
    protected String alunoFilter;

    @Execute
    public void execute() throws ConfigurationException {
        if (netQAConfigurations.getInstance().isModeNetQAPlusServer()) {
            this.context.redirectTo(InstituicaoStage.class.getSimpleName());
        }
    }

    @OnAJAX(value="alunos")
    public IJSONResponse getAlunos() throws Exception {
        final String anoLectivo = this.getNetQAUser().getAnoLectivo().getCodeLectivo();
        String[] fields = new String[]{Histalun.FK().id().CODECURSO(), Histalun.FK().id().CODEALUNO(), Histalun.FK().alunos().individuo().NOME(), Histalun.FK().alunos().cursos().NAMECURSO()};
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid(this.context, (IDataSet)this.siges.getCSE().getHistalunDataSet(), fields);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Histalun.FK().alunos(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Histalun.FK().alunos().individuo(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Histalun.FK().alunos().cursos(), JoinType.NORMAL);
        response.addFilter(new Filter(Histalun.FK().id().CODELECTIVO(), FilterType.EQUALS, anoLectivo));
        response.addFilter(new Filter("codeActCse", FilterType.EQUALS, "S"));
        if (StringUtils.isNotBlank((String)this.alunoFilter)) {
            if (StringUtils.isNumeric((String)this.alunoFilter)) {
                response.addFilter(new Filter(Histalun.FK().id().CODEALUNO(), FilterType.LIKE, this.alunoFilter));
            } else {
                response.addFilter(new Filter(Histalun.FK().alunos().individuo().NAMECOMPLETO(), FilterType.LIKE, this.alunoFilter));
            }
        }
        final String stageAlunoID = this.getIsBackoffice() != false ? GestaoSituacaoDeAluno.class.getSimpleName() : (this.getIsDocente() != false ? GestaoSituacaoDeAlunoDocentes.class.getSimpleName() : null);
        final boolean hasAccessToSituacaoAluno = this.context.getSession().isLogged() && StringUtils.isNotBlank((String)stageAlunoID) && this.context.getSession().getUser().canAccess(Entity.STAGE, stageAlunoID);
        response.addCalculatedField("content", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return "descDiscip";
            }

            public String getValue(Object record, String calcFieldID) {
                Alunos aluno = ((Histalun)record).getAlunos();
                StringBuffer buffer = new StringBuffer();
                buffer.append("<div id='homelists'><dl>\n");
                if (hasAccessToSituacaoAluno) {
                    buffer.append("<dt><a href='page?stage=" + stageAlunoID + "&anoLetivo=" + anoLectivo + "&codeCurso=" + aluno.getId().getCodeCurso() + "&codeAluno=" + aluno.getId().getCodeAluno() + "'>[" + aluno.getId().getCodeAluno() + "] " + aluno.getIndividuo().getNameCompleto() + "</a></dt>\n");
                } else {
                    buffer.append("<dt>" + aluno.getIndividuo().getNameCompleto() + " [" + aluno.getId().getCodeAluno() + "]</dt>\n");
                }
                buffer.append("</dl>\n");
                return buffer.toString();
            }
        });
        response.addCalculatedField("cursoCalc", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return Histalun.FK().id().CODECURSO();
            }

            public String getValue(Object record, String calcFieldID) {
                Histalun histalun = (Histalun)record;
                return "[" + histalun.getCursos().getCodeCurso() + "] " + histalun.getCursos().getNameCurso();
            }
        });
        if (this.getIsDocente().booleanValue()) {
            StringBuffer sqlFiltro = new StringBuffer();
            sqlFiltro.append("((this_.CD_CURSO, this_.CD_ALUNO) IN\n");
            sqlFiltro.append("     (SELECT CD_CURSO, CD_ALUNO\n");
            sqlFiltro.append("      FROM   INSCRI\n");
            sqlFiltro.append("      WHERE  CD_DISCIP IN " + this.getQueryUCDocenciaRegencia() + "\n");
            sqlFiltro.append("  AND    CD_LECTIVO = '" + anoLectivo + "'\n");
            sqlFiltro.append("     )\n");
            sqlFiltro.append(" OR\n");
            sqlFiltro.append(" this_.CD_CURSO IN (SELECT R.CD_CURSO\n");
            sqlFiltro.append("                    FROM   REG_DOCENTE R, TBTIPO_REGENCIA T\n");
            sqlFiltro.append("                    WHERE  R.ID_TIPO_REG = T.ID\n");
            sqlFiltro.append("                    AND    T.TIPO        = 'C'\n");
            sqlFiltro.append("                    AND    R.CD_DOCENTE  = " + this.docenteUser.getCodeFuncionario().toString() + "\n");
            sqlFiltro.append("                 AND    R.CD_LECTIVO = '" + anoLectivo + "'\n");
            sqlFiltro.append("                   )\n");
            sqlFiltro.append(")\n");
            response.addFilter(new Filter(FilterType.SQL, sqlFiltro.toString()));
        }
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "cursoCalc"));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, Histalun.FK().id().CODECURSO()));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, Histalun.FK().alunos().individuo().NAMECOMPLETO()));
        response.setHandleRESTActions(true, false, false, false, null);
        response.addExcelHeader((String)this.stageMessages.get("title"), "");
        response.addNewExcelHeaderEmptyLine();
        response.addExcelHeader((String)this.stageMessages.get("filtroAnoLectivo") + ": ", SIGESStoredProcedures.getAnoLectivoDescription((String)anoLectivo));
        response.addNewExcelHeaderEmptyLine();
        return response;
    }

    @Override
    @Init
    public void init() throws DataSetException, NetpaUserPreferencesException, BusinessException, ConfigurationException {
        super.init();
        NetpaUserPreferences.getUserPreferences((IDIFContext)this.context);
        HttpServletRequest originalRequest = (HttpServletRequest)this.context.getRequest().getAttribute("originalRequest");
        originalRequest.getSession().setAttribute("podeVisualizarPhoto", (Object)true);
    }
}

