/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice;

import com.google.inject.Inject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.dataminer.definition.DashboardManager;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.annotations.presentation.OnAJAX;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.dataset.Sort;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.model.sql.SQLDataSet;
import pt.digitalis.dif.model.sql.SQLDialect;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.presentation.ajax.IJSONResponse;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetCalendar;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetGrid;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.AbstractCalcField;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.ICalcField;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.RuleGroupException;
import pt.digitalis.dif.utils.extensions.cms.ContentItem;
import pt.digitalis.dif.utils.extensions.cms.IContentManager;
import pt.digitalis.dif.utils.extensions.cms.exception.ContentManagerException;
import pt.digitalis.dif.utils.extensions.cms.exception.NoAccessException;
import pt.digitalis.dif.utils.extensions.document.IDocumentRepositoryManager;
import pt.digitalis.netqa.entities.frontoffice.CursosStage;
import pt.digitalis.netqa.entities.frontoffice.InstituicaoStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractEntityPageStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.CatalogIndicadoresCurso;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.HorarioAulaDesc;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.NetQAPagesContentHelper;
import pt.digitalis.netqa.netQAConfigurations;
import pt.digitalis.netqa.rules.exceptions.NetQAException;
import pt.digitalis.siges.SIGESException;
import pt.digitalis.siges.model.data.csd.RegDocente;
import pt.digitalis.siges.model.data.cse.Cursos;
import pt.digitalis.siges.model.data.cse.Plandisc;
import pt.digitalis.siges.model.data.cse.PlandiscAtrib;
import pt.digitalis.siges.model.data.fuc.Fuc;
import pt.digitalis.siges.model.data.rac.RelatorioCurso;
import pt.digitalis.siges.presentation.utils.SideMenuOption;
import pt.digitalis.siges.users.preferences.NetpaUserPreferencesException;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;

@StageDefinition(name="Curso", service="FrontofficePrivateService")
@View(target="netqa/frontoffice/curso.jsp")
@Callback
public class CursoStage
extends AbstractEntityPageStage {
    @Parameter
    protected String codeCurso;
    @Parameter
    protected String content;
    @Inject
    protected IContentManager contentManager;
    protected Cursos curso = null;
    @Inject
    protected IDocumentRepositoryManager documentRepositoryManager;

    @Execute
    public void execute() throws MissingContextException, DataSetException, RuleGroupException, SIGESException, NoAccessException, ContentManagerException, IdentityManagerException, NetpaUserPreferencesException, HibernateException, InternalFrameworkException, NetQAException, BusinessException, SQLException, ConfigurationException {
        if (netQAConfigurations.getInstance().isModeNetQAPlusServer()) {
            this.context.redirectTo(InstituicaoStage.class.getSimpleName());
        } else {
            Query query;
            this.siges.getSession().beginTransaction();
            if (this.getIsDocente().booleanValue() && this.isAplicarFiltroRegenciaAsListas() && (query = this.siges.getCSD().getRegDocenteDataSet().query().equals(RegDocente.FK().funcionarios().CODEFUNCIONARIO(), this.docenteUser.getCodeFuncionario().toString()).equals(RegDocente.FK().cursosByCdCurso().CODECURSO(), this.codeCurso).equals(RegDocente.FK().tableLectivo().CODELECTIVO(), this.netQAUser.getAnoLectivo().getCodeLectivo())).count() == 0L) {
                this.context.addResultMessage("warn", (String)this.stageMessages.get("acessoIndevido"), (String)this.stageMessages.get("acessoIndevidoDesc"), true, true);
                this.context.redirectTo(CursosStage.class.getSimpleName());
            }
            Query queryRAC = this.siges.getRAC().getRelatorioCursoDataSet().query().equals(RelatorioCurso.FK().cursos().CODECURSO(), this.codeCurso).equals(Fuc.FK().tableLectivo().CODELECTIVO(), this.netQAUser.getAnoLectivo().getCodeLectivo()).equals("estado", "P").isNotNull("idDocumento").sortBy(Fuc.FK().cursos().NAMECURSO());
            List racs = queryRAC.asList();
            for (RelatorioCurso rc : racs) {
                this.documentRepositoryManager.authorizeDocumentForCurrentSession(this.context.getSession(), rc.getIdDocumento());
            }
            if (racs.size() == 1) {
                this.context.addStageResult("singleRAC", racs.get(0));
            } else if (!racs.isEmpty()) {
                this.context.addStageResult("listRACSs", (Object)racs);
            }
            Cursos curso = this.getCurso();
            if (curso != null) {
                this.context.addStageResult("codeCurso", (Object)curso.getCodeCurso());
                this.context.addStageResult("nameCurso", (Object)curso.getNameCurso());
                this.context.addStageResult("nameCursoAbbr", (Object)curso.getNameCurAbr());
                this.context.addStageResult("codeOficial", (Object)curso.getCodeOficial());
                this.context.addStageResult("grau1", (Object)curso.getDescGrau1());
                this.context.addStageResult("grau2", (Object)curso.getDescGrau2());
                this.context.addStageResult("descDepart", (Object)(curso.getTableDepart() == null ? "" : curso.getTableDepart().getDescDepart()));
                this.context.addStageResult("descInstituic", (Object)(curso.getTableInstituic() == null ? "" : curso.getTableInstituic().getDescInstituic()));
                this.context.addStageResult("homePage", (Object)curso.getHomePage());
            }
            ContentItem contentItem = NetQAPagesContentHelper.getContentForCurso(this.codeCurso, (IDIFUser)this.context.getSession().getUser());
            this.context.addStageResult("content", (Object)contentItem);
            if (this.context.getSession().isLogged()) {
                this.context.addStageResult("contentEditable", (Object)this.getNetQAUser().getCursoViewingRights().isContentCursoEditable());
            }
            this.siges.getSession().getTransaction().commit();
            CatalogIndicadoresCurso.registerDashboards();
            DashboardManager.getInstance((String)"netQACatalogInstanceCursos").grantDirectAccessToAllIndicators(this.context.getSession());
        }
    }

    public SQLDataSet getAulasDataSet() throws HibernateException, IdentityManagerException, NetpaUserPreferencesException, InternalFrameworkException, SIGESException, MissingContextException, DataSetException, RuleGroupException {
        String anoLetivo = this.netQAUser.getAnoLectivo().getCodeLectivo();
        StringBuffer buf = new StringBuffer();
        buf.append("select campo_referencia||'|'||nr_aula id,\n");
        buf.append("       DATA_INICIO startDt,\n");
        buf.append("       to_char(DATA_INICIO,'YYYY-MM-DD HH24:MI:SS') startDtStr,\n");
        buf.append("       DATA_FINAL endDt,\n");
        buf.append("       to_char(DATA_FINAL,'YYYY-MM-DD HH24:MI:SS') endDtStr,\n");
        buf.append("       ' ['||CALC.DEVOLVE_DS_PERIODO(CD_PERIODO)||']<br/>'||'||DS_DISCIP<br/>'||nvl(NM_DOCENTE,'" + (String)this.stageMessages.get("semDocente") + "')||' ('||CD_TURMA||')<br/>' /* ||SALA*/ \"title\",\n");
        buf.append("       SALA \"location\",\n");
        buf.append("       '<span style=''display:none;''>'||to_char(DATA_INICIO,'YYYYMM')||'</span>'||\n");
        buf.append("           to_char(DATA_INICIO,'fmMonth YYYY') as anomes,\n");
        buf.append("       v.*\n");
        buf.append(" from (\n");
        buf.append("    SELECT TRUNC(sysdate,'IW') + DIA_SEMANA-2 + (C.HORA_INICIO/60/24) DATA_INICIO,\n");
        buf.append("           TRUNC(sysdate,'IW') + DIA_SEMANA-2 + ((C.HORA_INICIO+H.DURACAO_AULA)/60/24) DATA_FINAL,\n");
        buf.append("           MANU_CSD.DEVOLVE_NM_DOCENTE(A.CD_DISCIP) DS_DISCIP,\n");
        buf.append("           MANU_CSD.DEVOLVE_NM_DOCENTE(A.CD_DOCENTE) NM_DOCENTE,\n");
        buf.append("           MANU_CSH.DEVOLVE_DS_TBSALA(A.CD_SALA) SALA,\n");
        buf.append("           A.CAMPO_REFERENCIA, A.NR_AULA, C.DIA_SEMANA, C.HORA_INICIO,\n");
        buf.append("           A.CD_PERIODO, A.CD_DISCIP, A.CD_TURMA, A.CD_DOCENTE, A.CD_SALA, H.DURACAO_AULA, A.CD_COR, \n");
        buf.append("           C.CD_INSTITUICAO||C.DIA_SEMANA||C.HORA_INICIO||A.NR_AULA ID_AULA\n");
        buf.append("    FROM   VWCONFIGURACAO_HORARIO C, VWHORARIO_REFERENCIA H, VWDETALHE_HORARIO_REF A\n");
        buf.append("    WHERE  C.CAMPO_REFERENCIA = H.CAMPO_REFERENCIA\n");
        buf.append("    AND    H.CAMPO_REFERENCIA = A.CAMPO_REFERENCIA\n");
        buf.append("    AND    H.NR_AULA          = A.NR_AULA\n");
        buf.append("    AND    C.CD_LECTIVO       = '" + anoLetivo + "'\n");
        buf.append("   AND MANU_CSD.DEVOLVE_CURSO_TURMA(a.cd_lectivo, a.cd_periodo, a.cd_discip, a.cd_turma) = " + this.codeCurso);
        buf.append("    ORDER BY C.DIA_SEMANA, C.HORA_INICIO, A.NR_AULA, A.NR_DETALHE\n");
        buf.append(") v\n");
        this.siges.getSession().beginTransaction();
        SQLDataSet ds = new SQLDataSet(this.siges.getSession().connection(), buf.toString(), SQLDialect.ORACLE);
        ds.setIdAttribute("id");
        return ds;
    }

    @OnAJAX(value="horarioCurso")
    public IJSONResponse getCalendarData() throws HibernateException, IdentityManagerException, NetpaUserPreferencesException, InternalFrameworkException, SIGESException, MissingContextException, DataSetException, RuleGroupException {
        JSONResponseDataSetCalendar response = new JSONResponseDataSetCalendar((IDataSet)this.getAulasDataSet());
        response.addCalculatedField("notes", (ICalcField)new HorarioAulaDesc(this.stageMessages));
        response.setColumnMappingForEventId("id");
        response.setColumnMappingForTitle("title");
        response.setColumnMappingForStartDate("startDtStr");
        response.setColumnMappingForEndDate("endDtStr");
        response.setColumnMappingForIsAllDay("allDay");
        response.setColumnMappingForLocation("location");
        response.setColumnMappingForNotes("notes");
        response.addDefaultSort(new Sort(SortMode.ASCENDING, "id"));
        return response;
    }

    @OnAJAX(value="caracteristicasCurso")
    public IJSONResponse getCaracteristicasPorCurso() {
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSE().getPlandiscAtribDataSet());
        String[] fields = new String[]{PlandiscAtrib.FK().plandisc().ramos().NAMERAMO(), PlandiscAtrib.FK().plandisc().ramos().planos().NAMEPLANO(), PlandiscAtrib.FK().plandisc().id().CODEDISCIP(), PlandiscAtrib.FK().plandisc().tableDiscip().DESCDISCIP(), "codeASCur", PlandiscAtrib.FK().plandisc().idiomasDic().SIGLA(), PlandiscAtrib.FK().tablePeriodos().DESCPERIODO(), PlandiscAtrib.FK().plandisc().NUMBERCREEUR(), PlandiscAtrib.FK().plandisc().tableEstruturaDiscip().DESCRICAO()};
        response.setFields(fields);
        response.addFilter(new Filter(PlandiscAtrib.FK().plandisc().ramos().planos().cursos().CODECURSO(), FilterType.EQUALS, this.codeCurso.toString()));
        response.addFilter(new Filter(PlandiscAtrib.FK().plandisc().ramos().planos().CODEPUBLICO(), FilterType.EQUALS, "S"));
        response.addFilter(new Filter(PlandiscAtrib.FK().plandisc().CODEACTIVA(), FilterType.EQUALS, "S"));
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)PlandiscAtrib.FK().plandisc().tableDiscip(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)PlandiscAtrib.FK().plandisc().idiomasDic(), JoinType.LEFT_OUTER_JOIN);
        response.addCalculatedField("tipo", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return PlandiscAtrib.FK().plandisc().tableEstruturaDiscip().DESCRICAO();
            }

            public String getValue(Object record, String calcFieldID) {
                PlandiscAtrib plandiscAtrib = (PlandiscAtrib)record;
                StringBuffer buf = new StringBuffer();
                buf.append(plandiscAtrib.getPlandisc().getTableEstruturaDiscip().getDescricao());
                if (plandiscAtrib.getPlandisc().getTableGrupos() != null) {
                    buf.append(" ( " + (String)CursoStage.this.stageMessages.get("grupo") + " " + plandiscAtrib.getPlandisc().getTableGrupos().getCodeGrupo() + ")");
                }
                return buf.toString();
            }
        });
        response.addCalculatedField("planoRamoCalc", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return PlandiscAtrib.FK().id().CODEPLANO();
            }

            public String getValue(Object record, String calcFieldID) {
                PlandiscAtrib plandiscAtrib = (PlandiscAtrib)record;
                return "[" + plandiscAtrib.getPlandisc().getRamos().getPlanos().getId().getCodePlano() + "] - " + plandiscAtrib.getPlandisc().getRamos().getPlanos().getNamePlano() + " | [" + plandiscAtrib.getPlandisc().getRamos().getId().getCodeRamo() + "] " + plandiscAtrib.getPlandisc().getRamos().getNameRamo();
            }
        });
        response.addCalculatedField("planoRamoOrderByCalc", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return PlandiscAtrib.FK().id().CODEPLANO();
            }

            public String getValue(Object record, String calcFieldID) {
                PlandiscAtrib plandiscAtrib = (PlandiscAtrib)record;
                return "<span>" + StringUtils.fillStringLeft((String)Long.toString(99L - plandiscAtrib.getPlandisc().getRamos().getPlanos().getId().getCodePlano()), (int)2, (String)"0") + "-" + StringUtils.fillStringLeft((String)plandiscAtrib.getPlandisc().getRamos().getId().getCodeRamo().toString(), (int)2, (String)"0") + "</span> ";
            }
        });
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "planoRamoCalc"));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, Plandisc.FK().id().CODEPLANO()));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, Plandisc.FK().id().CODERAMO()));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, Plandisc.FK().plandiscAtribs().CODEASCUR()));
        return response;
    }

    public Cursos getCurso() throws DataSetException {
        if (this.curso == null && StringUtils.isNotBlank((String)this.codeCurso)) {
            this.curso = (Cursos)this.siges.getCSE().getCursosDataSet().query().equals("codeCurso", this.codeCurso).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Cursos.FK().tableInstituic(), JoinType.LEFT_OUTER_JOIN).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Cursos.FK().tableDepart(), JoinType.LEFT_OUTER_JOIN).singleValue();
        }
        return this.curso;
    }

    @Override
    public List<SideMenuOption> getRightNavBarLinks() {
        ArrayList<SideMenuOption> titles = new ArrayList<SideMenuOption>();
        try {
            if (this.getNetQAUser().getCursoViewingRights().canViewApresentacao().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("apresentacao"), "apresentacaoAnchor"));
            }
            if (this.getNetQAUser().getCursoViewingRights().canViewCaracteristicas().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("caracteristicas"), "caracteristicasAnchor"));
            }
            if (this.getNetQAUser().getCursoViewingRights().canViewPlanoEstudos().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("planoEstudos"), "planoEstudosAnchor"));
            }
            if (this.getNetQAUser().getCursoViewingRights().canViewDSD().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("dsd"), "dsdAnchor"));
            }
            if (this.getNetQAUser().getCursoViewingRights().canViewRegencia().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("regencia"), "regenciaAnchor"));
            }
            if (this.getNetQAUser().getCursoViewingRights().canViewProjetos().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("projetos"), "projetosAnchor"));
            }
            if (this.getNetQAUser().getCursoViewingRights().canViewAlunos().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("alunos"), "alunosAnchor"));
            }
            if (this.getNetQAUser().getCursoViewingRights().canViewPautas().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("pautas"), "pautasAnchor"));
            }
            if (this.getNetQAUser().getCursoViewingRights().canViewHorario().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("horario"), "horarioAnchor"));
            }
            if (this.getNetQAUser().getCursoViewingRights().canViewSumarios().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("sumarios"), "sumariosAnchor"));
            }
            if (this.getNetQAUser().getCursoViewingRights().canViewInqueritos().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("inqueritos"), "inqueritosAnchor"));
            }
            if (this.getNetQAUser().getCursoViewingRights().canViewRAC().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("rac"), "racAnchor"));
            }
            if (this.getNetQAUser().getCursoViewingRights().canViewIndicadores().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("indicadores"), "indicadoresAnchor"));
            }
        }
        catch (NetQAException e) {
            e.printStackTrace();
        }
        return titles;
    }
}

