/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice;

import org.hibernate.HibernateException;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.annotations.presentation.OnAJAX;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.Sort;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.presentation.ajax.IJSONResponse;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetGrid;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.AbstractCalcField;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.ICalcField;
import pt.digitalis.netqa.entities.frontoffice.CursoStage;
import pt.digitalis.netqa.entities.frontoffice.InstituicaoStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractFrontOfficeStage;
import pt.digitalis.netqa.netQAConfigurations;
import pt.digitalis.siges.SIGESException;
import pt.digitalis.siges.model.data.cse.Cursos;
import pt.digitalis.siges.users.preferences.NetpaUserPreferencesException;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;

@StageDefinition(name="Cursos", service="FrontofficePrivateService")
@View(target="netqa/frontoffice/cursos.jsp")
@Callback
public class CursosStage
extends AbstractFrontOfficeStage {
    @Parameter
    protected String cursoFilter;

    @Execute
    public void execute() throws ConfigurationException {
        if (netQAConfigurations.getInstance().isModeNetQAPlusServer()) {
            this.context.redirectTo(InstituicaoStage.class.getSimpleName());
        }
    }

    @OnAJAX(value="cursos")
    public IJSONResponse getCursos() throws NetpaUserPreferencesException, IdentityManagerException, HibernateException, InternalFrameworkException, SIGESException, Exception {
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSE().getCursosDataSet(), new String[]{Cursos.FK().CODECURSO(), "nameCurso"});
        response.addFilter(new Filter("codeActivo", FilterType.EQUALS, "S"));
        response.addFilter(new Filter("codePublico", FilterType.EQUALS, "S"));
        response.addFilter(new Filter("valido", FilterType.EQUALS, "S"));
        if (StringUtils.isNotBlank((String)this.cursoFilter)) {
            if (StringUtils.isNumeric((String)this.cursoFilter)) {
                response.addFilter(new Filter("codeCurso", FilterType.LIKE, this.cursoFilter));
            } else {
                response.addFilter(new Filter("nameCurso", FilterType.LIKE, this.cursoFilter));
            }
        }
        response.addCalculatedField("content", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return "nameCurso";
            }

            public String getValue(Object record, String calcFieldID) {
                Cursos curso = (Cursos)record;
                StringBuffer buffer = new StringBuffer();
                buffer.append("<div id='homelists'><dl>\n");
                buffer.append("<dt><a href='page?stage=" + CursoStage.class.getSimpleName() + "&codeCurso=" + curso.getCodeCurso() + "'>[" + curso.getCodeCurso() + "] " + curso.getNameCurso() + "</a></dt>\n");
                buffer.append("</dl>\n");
                return buffer.toString();
            }
        });
        String anoLectivo = this.getNetQAUser().getAnoLectivo().getCodeLectivo();
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "planoRamoCalc"));
        if (this.getIsDocente().booleanValue() && this.isAplicarFiltroRegenciaAsListas()) {
            response.addFilter(new Filter(Cursos.FK().regDocentesForCdCurso().funcionarios().CODEFUNCIONARIO(), FilterType.EQUALS, this.docenteUser.getCodeFuncionario().toString()));
            response.addFilter(new Filter(Cursos.FK().regDocentesForCdCurso().tableLectivo().CODELECTIVO(), FilterType.EQUALS, anoLectivo));
        }
        return response;
    }
}

