/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.annotations.presentation.OnAJAX;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.dataset.Sort;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.model.sql.SQLDataSet;
import pt.digitalis.dif.model.sql.SQLDialect;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.presentation.ajax.IJSONResponse;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetCalendar;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.ICalcField;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.RuleGroupException;
import pt.digitalis.dif.utils.extensions.cms.ContentItem;
import pt.digitalis.dif.utils.extensions.cms.IContentManager;
import pt.digitalis.dif.utils.extensions.cms.exception.ContentManagerException;
import pt.digitalis.dif.utils.extensions.cms.exception.NoAccessException;
import pt.digitalis.dif.utils.extensions.document.IDocumentRepositoryManager;
import pt.digitalis.netqa.entities.frontoffice.DocentesStage;
import pt.digitalis.netqa.entities.frontoffice.InstituicaoStage;
import pt.digitalis.netqa.entities.frontoffice.NetQADataProviderStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractEntityPageStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.HorarioAulaDesc;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.NetQAPagesContentHelper;
import pt.digitalis.netqa.netQAConfigurations;
import pt.digitalis.netqa.rules.exceptions.NetQAException;
import pt.digitalis.siges.SIGESException;
import pt.digitalis.siges.model.data.csp.Funcionarios;
import pt.digitalis.siges.model.data.web_csd.CurriculumDoc;
import pt.digitalis.siges.presentation.utils.SideMenuOption;
import pt.digitalis.siges.users.preferences.NetpaUserPreferences;
import pt.digitalis.siges.users.preferences.NetpaUserPreferencesException;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;

@StageDefinition(name="Docente", service="FrontofficePrivateService")
@View(target="netqa/frontoffice/docente.jsp")
@Callback
public class DocenteStage
extends AbstractEntityPageStage {
    @Parameter
    protected String codeFuncionario;
    @Parameter
    protected String content;
    @Inject
    protected IContentManager contentManager;
    @Inject
    protected IDocumentRepositoryManager documentRepositoryManager;
    protected Funcionarios funcionario = null;

    @Execute
    public void execute() throws MissingContextException, DataSetException, RuleGroupException, SIGESException, NoAccessException, ContentManagerException, IdentityManagerException, NetpaUserPreferencesException, HibernateException, InternalFrameworkException, ConfigurationException {
        if (netQAConfigurations.getInstance().isModeNetQAPlusServer()) {
            this.context.redirectTo(InstituicaoStage.class.getSimpleName());
        } else if (this.getFuncionario() == null) {
            this.context.addResultMessage("warn", (String)this.stageMessages.get("acessoIndevido"), (String)this.stageMessages.get("acessoIndevidoDesc"), true, true);
            this.context.redirectTo(DocentesStage.class.getSimpleName());
        } else {
            Query queryCVs = this.siges.getWEBCSD().getCurriculumDocDataSet().query().equals(CurriculumDoc.FK().funcionarios().CODEFUNCIONARIO(), this.codeFuncionario).isNotNull("documentId").addJoin((AbstractBeanRelationsAttributes.AbstractRelations)CurriculumDoc.FK().curriculumModelos(), JoinType.NORMAL).sortBy("documentDate", SortMode.DESCENDING);
            List curriculums = queryCVs.asList();
            for (CurriculumDoc curriculum : curriculums) {
                this.documentRepositoryManager.authorizeDocumentForCurrentSession(this.context.getSession(), curriculum.getDocumentId());
            }
            if (curriculums.size() == 1) {
                this.context.addStageResult("singleCV", curriculums.get(0));
            } else if (!curriculums.isEmpty()) {
                this.context.addStageResult("listCVs", (Object)curriculums);
            }
            ContentItem contentItem = NetQAPagesContentHelper.getContentForDocente(this.codeFuncionario, (IDIFUser)this.context.getSession().getUser());
            this.context.addStageResult("content", (Object)contentItem);
            if (this.context.getSession().isLogged()) {
                this.context.addStageResult("contentEditable", (Object)(this.netQAUser.isAdministrator() || this.netQAUser.isBOUser() || this.codeFuncionario.equals(NetpaUserPreferences.getUserPreferences((IDIFContext)this.context).getCodeFuncionario()) ? 1 : 0));
            }
            if (this.getFuncionario().getIndividuo().getIdiomasDic() != null) {
                this.context.addStageResult("idiomaMaterno", (Object)this.getFuncionario().getIndividuo().getIdiomasDic().getIdioma());
            }
        }
    }

    public SQLDataSet getAulasDataSet() throws HibernateException, IdentityManagerException, NetpaUserPreferencesException, InternalFrameworkException, SIGESException, MissingContextException, DataSetException, RuleGroupException {
        String anoLetivo = this.netQAUser.getAnoLectivo().getCodeLectivo();
        StringBuffer buf = new StringBuffer();
        buf.append("select campo_referencia||'|'||nr_aula id,\n");
        buf.append("       DATA_INICIO startDt,\n");
        buf.append("       to_char(DATA_INICIO,'YYYY-MM-DD HH24:MI:SS') startDtStr,\n");
        buf.append("       DATA_FINAL endDt,\n");
        buf.append("       to_char(DATA_FINAL,'YYYY-MM-DD HH24:MI:SS') endDtStr,\n");
        buf.append("       ' ['||CALC.DEVOLVE_DS_PERIODO(CD_PERIODO)||']<br/>'||MANU_CSE.DEVOLVE_DS_DISCIP(CD_DISCIP)||' ('||CD_TURMA||')<br/>' /*||SALA*/ \"title\",\n");
        buf.append("       SALA \"location\",\n");
        buf.append("       '<span style=''display:none;''>'||to_char(DATA_INICIO,'YYYYMM')||'</span>'||\n");
        buf.append("           to_char(DATA_INICIO,'fmMonth YYYY') as anomes,\n");
        buf.append("       v.*\n");
        buf.append(" from (\n");
        buf.append("    SELECT TRUNC(sysdate,'IW') + DIA_SEMANA-2 + (C.HORA_INICIO/60/24) DATA_INICIO,\n");
        buf.append("           TRUNC(sysdate,'IW') + DIA_SEMANA-2 + ((C.HORA_INICIO+H.DURACAO_AULA)/60/24) DATA_FINAL,\n");
        buf.append("           MANU_CSD.DEVOLVE_NM_DOCENTE(A.CD_DOCENTE) NM_DOCENTE,\n");
        buf.append("           MANU_CSH.DEVOLVE_DS_TBSALA(A.CD_SALA) SALA,\n");
        buf.append("           A.CAMPO_REFERENCIA, A.NR_AULA, C.DIA_SEMANA, C.HORA_INICIO,\n");
        buf.append("           A.CD_PERIODO, A.CD_DISCIP, A.CD_TURMA, A.CD_DOCENTE, A.CD_SALA, H.DURACAO_AULA, A.CD_COR, \n");
        buf.append("           C.CD_INSTITUICAO||C.DIA_SEMANA||C.HORA_INICIO||A.NR_AULA ID_AULA\n");
        buf.append("    FROM   VWCONFIGURACAO_HORARIO C, VWHORARIO_REFERENCIA H, VWDETALHE_HORARIO_REF A\n");
        buf.append("    WHERE  C.CAMPO_REFERENCIA = H.CAMPO_REFERENCIA\n");
        buf.append("    AND    H.CAMPO_REFERENCIA = A.CAMPO_REFERENCIA\n");
        buf.append("    AND    H.NR_AULA          = A.NR_AULA\n");
        buf.append("    --AND    C.CD_INSTITUICAO   = :CD_INSTITUICAO\n");
        buf.append("    AND    C.CD_LECTIVO       = '" + anoLetivo + "'\n");
        buf.append(" AND A.CD_DOCENTE = " + this.codeFuncionario + "\n");
        buf.append("    ORDER BY C.DIA_SEMANA, C.HORA_INICIO, A.NR_AULA, A.NR_DETALHE\n");
        buf.append(") v\n");
        this.siges.getSession().beginTransaction();
        SQLDataSet ds = new SQLDataSet(this.siges.getSession().connection(), buf.toString(), SQLDialect.ORACLE);
        ds.setIdAttribute("id");
        return ds;
    }

    @OnAJAX(value="horarioDocente")
    public IJSONResponse getCalendarData() throws HibernateException, IdentityManagerException, NetpaUserPreferencesException, InternalFrameworkException, SIGESException, MissingContextException, DataSetException, RuleGroupException {
        JSONResponseDataSetCalendar response = new JSONResponseDataSetCalendar((IDataSet)this.getAulasDataSet());
        response.addCalculatedField("notes", (ICalcField)new HorarioAulaDesc(this.stageMessages));
        response.setColumnMappingForEventId("id");
        response.setColumnMappingForTitle("title");
        response.setColumnMappingForStartDate("startDtStr");
        response.setColumnMappingForEndDate("endDtStr");
        response.setColumnMappingForIsAllDay("allDay");
        response.setColumnMappingForLocation("location");
        response.setColumnMappingForNotes("notes");
        response.addDefaultSort(new Sort(SortMode.ASCENDING, "id"));
        return response;
    }

    public Funcionarios getFuncionario() throws DataSetException, NetpaUserPreferencesException, IdentityManagerException, MissingContextException, HibernateException, InternalFrameworkException, RuleGroupException, SIGESException, ConfigurationException {
        if (this.funcionario == null && StringUtils.isNotBlank((String)this.codeFuncionario)) {
            Query<Funcionarios> query = null;
            if (this.getIsDocente().booleanValue() && this.isAplicarFiltroRegenciaAsListas()) {
                query = NetQADataProviderStage.getQueryDocentesParaDocente(this.siges, this.docenteUser.getCodeFuncionario(), this.getNetQAUser());
                query.setDistinct(true);
                query.addField("codeFuncionario");
                query.addField(Funcionarios.FK().individuo().NOME());
            } else {
                query = this.siges.getCSP().getFuncionariosDataSet().query();
            }
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Funcionarios.FK().individuo(), JoinType.NORMAL).equals("codeFuncionario", this.codeFuncionario);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Funcionarios.FK().individuo().idiomasDic(), JoinType.LEFT_OUTER_JOIN);
            this.funcionario = (Funcionarios)query.singleValue();
        }
        return this.funcionario;
    }

    @Override
    public List<SideMenuOption> getRightNavBarLinks() {
        ArrayList<SideMenuOption> titles = new ArrayList<SideMenuOption>();
        try {
            if (this.getNetQAUser().getDocenteViewingRights().canViewApresentacao().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("apresentacao"), "apresentacaoAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewCaracteristicas().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("caracteristicas"), "caracteristicasAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewHistoricoAnoLetivo().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("historicoAnoLetivo"), "historicoAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewCargosGestao().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("cargosGestao"), "cargosAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewRegencia().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("regencia"), "regenciaAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewDSD().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("dsd"), "dsdAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewHabilitacoesLiterarias().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("habilitacoesLiterarias"), "habilitacoesLiterariasAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewInvestigacao().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("investigacao"), "investigacaoAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewOrientacaoTeses().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("orientacaoTeses"), "orientacaoTesesAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewPremiosLouvores().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("premiosLouvoresAnchor"), "premiosLouvoresAnchorAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewOrientacaoTeses().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("formacaoComplementar"), "formacaoComplementarAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewExperienciaProfissional().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("experienciaProfissional"), "experienciaProfissionalAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewProjetos().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("projetos"), "projetosAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewOutrasActividades().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("outrasActividades"), "outrasActividadesAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewHorario().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("horario"), "horarioAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewSumarios().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("sumarios"), "sumariosAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewPautas().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("pautas"), "pautasAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewInqueritos().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("inqueritos"), "inqueritosAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewIdiomas().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("idiomas"), "idiomasAnchor"));
            }
            if (this.getNetQAUser().getDocenteViewingRights().canViewCurriculum().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("curriculum"), "curriculumAnchor"));
            }
        }
        catch (NetQAException e) {
            e.printStackTrace();
        }
        return titles;
    }
}

