/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice;

import org.hibernate.HibernateException;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.annotations.presentation.OnAJAX;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.presentation.ajax.IJSONResponse;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetGrid;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.AbstractCalcField;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.ICalcField;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.RuleGroupException;
import pt.digitalis.netqa.entities.frontoffice.DocenteStage;
import pt.digitalis.netqa.entities.frontoffice.InstituicaoStage;
import pt.digitalis.netqa.entities.frontoffice.NetQADataProviderStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractFrontOfficeStage;
import pt.digitalis.netqa.netQAConfigurations;
import pt.digitalis.siges.SIGESException;
import pt.digitalis.siges.model.data.csp.Funcionarios;
import pt.digitalis.siges.users.preferences.NetpaUserPreferencesException;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;

@StageDefinition(name="Docentes", service="FrontofficePrivateService")
@View(target="netqa/frontoffice/docentes.jsp")
@Callback
public class DocentesStage
extends AbstractFrontOfficeStage {
    @Parameter
    protected String docenteFilter;

    @Execute
    public void execute() throws ConfigurationException {
        if (netQAConfigurations.getInstance().isModeNetQAPlusServer()) {
            this.context.redirectTo(InstituicaoStage.class.getSimpleName());
        }
    }

    @OnAJAX(value="docentes")
    public IJSONResponse getDocentes() throws MissingContextException, HibernateException, IdentityManagerException, NetpaUserPreferencesException, InternalFrameworkException, DataSetException, RuleGroupException, SIGESException, ConfigurationException {
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSP().getFuncionariosDataSet(), new String[]{"codeFuncionario", Funcionarios.FK().individuo().NAMECOMPLETO()});
        response.addFilter(new Filter("docente", FilterType.EQUALS, "S"));
        response.addFilter(new Filter("activo", FilterType.EQUALS, "S"));
        if (StringUtils.isNotBlank((String)this.docenteFilter)) {
            if (StringUtils.isNumeric((String)this.docenteFilter)) {
                response.addFilter(new Filter("codeFuncionario", FilterType.LIKE, this.docenteFilter));
            } else {
                response.addFilter(new Filter(Funcionarios.FK().individuo().NAMECOMPLETO(), FilterType.LIKE, this.docenteFilter));
            }
        }
        response.addCalculatedField("content", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return "descDiscip";
            }

            public String getValue(Object record, String calcFieldID) {
                Funcionarios funcionario = (Funcionarios)record;
                StringBuffer buffer = new StringBuffer();
                buffer.append("<div id='homelists'><dl>\n");
                buffer.append("<dt><a href='page?stage=" + DocenteStage.class.getSimpleName() + "&codeFuncionario=" + funcionario.getCodeFuncionario() + "'>[" + funcionario.getCodeFuncionario() + "] " + funcionario.getIndividuo().getNameCompleto() + "</a></dt>\n");
                buffer.append("</dl>\n");
                return buffer.toString();
            }
        });
        if (this.getIsDocente().booleanValue() && this.isAplicarFiltroRegenciaAsListas()) {
            response.setQuery(NetQADataProviderStage.getQueryDocentesParaDocente(this.siges, this.docenteUser.getCodeFuncionario(), this.getNetQAUser()));
            response.setDistinctEntities(Boolean.valueOf(true), Boolean.valueOf(false));
        }
        return response;
    }
}

