/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice;

import pt.digitalis.dif.dataminer.definition.Area;
import pt.digitalis.dif.dataminer.definition.DashboardManager;
import pt.digitalis.dif.dataminer.definition.IIndicator;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractFrontOfficeStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.NetQADashboardDefinition;
import pt.digitalis.netqa.netQAConfigurations;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;

@StageDefinition(name="Private Home", service="FrontofficePrivateService")
@View(target="netqa/homePrivate.jsp")
@Callback
public class HomePrivada
extends AbstractFrontOfficeStage {
    private NetQADashboardDefinition dashboardDefinition = new NetQADashboardDefinition();

    private void addIndicatorToDash(Integer dashBoardLine, String indicatorID, String indicatorTitle) {
        if (StringUtils.isNotBlank((String)indicatorID)) {
            String[] indicatorParts = indicatorID.split(":");
            String parsedAreaID = indicatorParts[0];
            String parsedIndicatorID = indicatorParts[1];
            DashboardManager manager = DashboardManager.getInstance((String)"CMEnetCatalogInstance");
            if (((IIndicator)((Area)manager.getAreas().get(parsedAreaID)).getIndicators().get(parsedIndicatorID)).isVisible()) {
                manager.grantDirectAccessToIndicator(this.context.getSession(), parsedAreaID, parsedIndicatorID);
                this.dashboardDefinition.addIndicator(dashBoardLine, parsedAreaID, parsedIndicatorID, indicatorTitle);
            }
        }
    }

    @Execute
    public void execute() throws ConfigurationException {
        netQAConfigurations c = netQAConfigurations.getInstance();
        this.addIndicatorToDash(1, c.getIndicadorLinha1_left(), c.getIndicadorLinha1_left_title());
        this.addIndicatorToDash(1, c.getIndicadorLinha1_right(), c.getIndicadorLinha1_right_title());
        this.addIndicatorToDash(2, c.getIndicadorLinha2_left(), c.getIndicadorLinha2_left_title());
        this.addIndicatorToDash(2, c.getIndicadorLinha2_right(), c.getIndicadorLinha2_right_title());
        this.addIndicatorToDash(3, c.getIndicadorLinha3_left(), c.getIndicadorLinha3_left_title());
        this.addIndicatorToDash(3, c.getIndicadorLinha3_right(), c.getIndicadorLinha3_right_title());
    }

    public NetQADashboardDefinition getDashboardDefinition() {
        return this.dashboardDefinition;
    }
}

