/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.comquest.business.presentation.calcfields.SurveyReportFormatCalc;
import pt.digitalis.comquest.entities.calcfields.SurveyStateDescription;
import pt.digitalis.comquest.model.IComQuestService;
import pt.digitalis.comquest.model.data.Survey;
import pt.digitalis.comquest.model.data.SurveyInstance;
import pt.digitalis.comquest.model.data.SurveyReportInstance;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.annotations.presentation.OnAJAX;
import pt.digitalis.dif.dem.annotations.stage.InjectMessages;
import pt.digitalis.dif.model.dataset.ConditionOperator;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterExtendedSQL;
import pt.digitalis.dif.model.dataset.FilterSet;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.dataset.Sort;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.model.dataset.UnsupportedDataSetFeature;
import pt.digitalis.dif.model.sql.SQLDataSet;
import pt.digitalis.dif.model.sql.SQLDialect;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.presentation.ajax.IJSONResponse;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetGrid;
import pt.digitalis.dif.presentation.views.jsp.taglibs.AbstractDIFTag;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.AbstractCalcField;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.Checked2;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.ConcatenateFields;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.Decode;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.ICalcField;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.NumericFormater;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.YearCalc;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.RuleGroupException;
import pt.digitalis.dif.utils.extensions.document.IDocumentRepositoryManager;
import pt.digitalis.fcdnet.model.IFCDnetService;
import pt.digitalis.fcdnet.model.data.Producao;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractFrontOfficeStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.InscriSituacaoCalc;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.InscriTurmasListCalc;
import pt.digitalis.netqa.rules.NetQAUser;
import pt.digitalis.netqa.rules.NetQAUtils;
import pt.digitalis.siges.SIGESException;
import pt.digitalis.siges.entities.csdnet.docente.atividadesnaoletivas.calcfields.AlunoParticipacaoJuriTeseCalcField;
import pt.digitalis.siges.entities.csenet.situacaoaluno.SituacaoAlunoHistoricosCalc;
import pt.digitalis.siges.entities.model.AnoLectivoCalcField;
import pt.digitalis.siges.entities.model.PeriodoLectivoCalcField;
import pt.digitalis.siges.model.ISIGESInstance;
import pt.digitalis.siges.model.SIGESFactory;
import pt.digitalis.siges.model.data.csd.DocTurma;
import pt.digitalis.siges.model.data.csd.FormacaoDoc;
import pt.digitalis.siges.model.data.csd.JuriTese;
import pt.digitalis.siges.model.data.csd.OutrasActiv;
import pt.digitalis.siges.model.data.csd.PremiosDoc;
import pt.digitalis.siges.model.data.csd.RegDocente;
import pt.digitalis.siges.model.data.cse.Histalun;
import pt.digitalis.siges.model.data.cse.Inscri;
import pt.digitalis.siges.model.data.cse.TableDiscip;
import pt.digitalis.siges.model.data.csp.Cargo;
import pt.digitalis.siges.model.data.csp.CargoInst;
import pt.digitalis.siges.model.data.csp.Funcionarios;
import pt.digitalis.siges.model.data.csp.HabilitLiter;
import pt.digitalis.siges.model.data.csp.HabilitProfis;
import pt.digitalis.siges.model.data.lnd.AlunosPautas;
import pt.digitalis.siges.model.data.lnd.Pautas;
import pt.digitalis.siges.model.data.siges.IdiomasIndividuo;
import pt.digitalis.siges.model.data.web_projeto.Projeto;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.DateUtils;
import pt.digitalis.utils.common.StringUtils;

@StageDefinition(name="Data Provider", service="FrontofficePrivateService")
public class NetQADataProviderStage
extends AbstractFrontOfficeStage {
    @Parameter(constraints="numeric")
    protected String codeCurso;
    @Parameter(constraints="numeric")
    protected String codeDiscip;
    @Parameter(constraints="numeric")
    protected String codeFuncionario;
    @Parameter(constraints="numeric")
    protected String codePauta;
    @Inject
    protected IComQuestService comquest;
    @Inject
    protected IDocumentRepositoryManager documentRepositoryManager;
    @Inject
    protected IFCDnetService fcdService;
    @Parameter
    protected String filterTextAlunos;
    @Parameter
    protected String filterTextDSD;
    @Parameter
    protected String filterTextExperienciaProfissional;
    @Parameter
    protected String filterTextFormacaoComplementar;
    @Parameter
    protected String filterTextHabilitacao;
    @Parameter
    protected String filterTextInvestigacao;
    @Parameter
    protected String filterTextorientacaoTeses;
    @Parameter
    protected String filterTextParticipacaoJuris;
    @Parameter
    protected String filterTextOutrasActividades;
    @Parameter
    protected String filterTextPremiosLouvores;
    @Parameter
    protected String filterTextProjetos;
    @Parameter
    protected String filterTextSumarios;
    @InjectMessages
    protected Map<String, String> messages;
    @Parameter(constraints="numeric")
    protected String surveyId;

    public static Query<Funcionarios> getQueryDocentesParaDocente(ISIGESInstance siges, Long codeDocente, NetQAUser netQAUser) throws DataSetException, MissingContextException, RuleGroupException, SIGESException {
        Query query = siges.getCSP().getFuncionariosDataSet().query();
        query.equals(Funcionarios.FK().docTurmas().id().CODELECTIVO(), netQAUser.getAnoLectivo().getCodeLectivo());
        query.equals("activo", "S");
        FilterSet filterSetRegencias = ((FilterSet)query.filterSet(ConditionOperator.OR)).equals("codeFuncionario", codeDocente.toString());
        if (netQAUser.getRegenteUCs().size() > 0) {
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Funcionarios.FK().docTurmas(), JoinType.LEFT_OUTER_JOIN);
            filterSetRegencias.in(Funcionarios.FK().docTurmas().id().CODEDISCIP(), CollectionUtils.listToCommaSeparatedString((List)netQAUser.getRegenteUCs()));
        }
        if (netQAUser.getRegenteCursos().size() > 0) {
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Funcionarios.FK().docTurmas(), JoinType.LEFT_OUTER_JOIN);
            filterSetRegencias.addFilter((Filter)new FilterExtendedSQL("MANU_CSD.DEVOLVE_CURSO_TURMA('" + netQAUser.getAnoLectivo().getCodeLectivo() + "', {periodo}, {discip}, {turma}) in (" + CollectionUtils.listToCommaSeparatedString((List)netQAUser.getRegenteCursos()) + ")", new String[]{"periodo", Funcionarios.FK().docTurmas().id().CODEDURACAO(), "discip", Funcionarios.FK().docTurmas().id().CODEDISCIP(), "turma", Funcionarios.FK().docTurmas().id().CODETURMA()}));
        }
        return query;
    }

    public static Query<TableDiscip> getQueryUCParaDocente(ISIGESInstance siges, Long codeDocente, NetQAUser netQAUser) throws DataSetException, MissingContextException, RuleGroupException, SIGESException {
        Query query = siges.getCSE().getTableDiscipDataSet().query();
        query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TableDiscip.FK().turmas(), JoinType.NORMAL);
        query.equals(TableDiscip.FK().turmas().id().CODELECTIVO(), netQAUser.getAnoLectivo().getCodeLectivo());
        query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TableDiscip.FK().turmas().docTurmas(), JoinType.LEFT_OUTER_JOIN);
        FilterSet filterSetUCs = ((FilterSet)query.filterSet(ConditionOperator.OR)).equals(TableDiscip.FK().turmas().docTurmas().id().CODEDOCENTE(), codeDocente.toString());
        if (netQAUser.getRegenteUCs().size() > 0) {
            filterSetUCs.addFilter(new Filter("codeDiscip", FilterType.IN, CollectionUtils.listToCommaSeparatedString((List)netQAUser.getRegenteUCs())));
        }
        if (netQAUser.getRegenteCursos().size() > 0) {
            filterSetUCs.addFilter((Filter)new FilterExtendedSQL("MANU_CSD.DEVOLVE_CURSO_TURMA('" + netQAUser.getAnoLectivo().getCodeLectivo() + "', {periodo}, {discip}, {turma}) in (" + CollectionUtils.listToCommaSeparatedString((List)netQAUser.getRegenteCursos()) + ")", new String[]{"periodo", TableDiscip.FK().turmas().id().CODEDURACAO(), "discip", TableDiscip.FK().turmas().id().CODEDISCIP(), "turma", TableDiscip.FK().turmas().id().CODETURMA()}));
        }
        return query;
    }

    public void addLine(StringBuffer buffer, boolean newLine, String value, String template) {
        if (StringUtils.isNotBlank((String)value)) {
            String newContent = "";
            newContent = StringUtils.isNotBlank((String)template) ? template.replace("$value", value) : value;
            if (newLine && buffer.length() > 0) {
                buffer.append("<br/>");
            }
            buffer.append(newContent);
        }
    }

    @OnAJAX(value="formacaoComplementar")
    public IJSONResponse geFormacaoComplementar() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        String[] fields = new String[]{"id", "dateFim", "dateInicio", "descCurso", "codeTipo", "numberDias", "numberHoras", FormacaoDoc.FK().tableLocalTrab().CODELOCALTRAB(), FormacaoDoc.FK().tableLocalTrab().DESCLOCALTRAB(), FormacaoDoc.FK().tableNaciona().CODENACIONA(), FormacaoDoc.FK().tableNaciona().ISO(), FormacaoDoc.FK().tableClassAct().CODECLASSACT(), FormacaoDoc.FK().tableClassAct().DESCCLASSACT(), "linkInfo", "idCategoria"};
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSD().getFormacaoDocDataSet(), fields);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)FormacaoDoc.FK().tableLocalTrab(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)FormacaoDoc.FK().tableNaciona(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)FormacaoDoc.FK().tableClassAct(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter(FormacaoDoc.FK().funcionarios().CODEFUNCIONARIO(), FilterType.EQUALS, this.codeFuncionario));
        response.addCalculatedField("ano", (ICalcField)new YearCalc("dateInicio"));
        if (StringUtils.isNotBlank((String)this.filterTextFormacaoComplementar)) {
            response.addFilterSet(ConditionOperator.OR).like("descCurso", this.filterTextFormacaoComplementar).like(FormacaoDoc.FK().tableLocalTrab().DESCLOCALTRAB(), this.filterTextFormacaoComplementar).like(FormacaoDoc.FK().tableNaciona().DESCNACIONA(), this.filterTextFormacaoComplementar).like(FormacaoDoc.FK().tableClassAct().DESCCLASSACT(), this.filterTextFormacaoComplementar);
        }
        LinkedHashMap<String, String> tipos = new LinkedHashMap<String, String>();
        tipos.put("F", this.messages.get("formador"));
        tipos.put("M", this.messages.get("formando"));
        response.addCalculatedField("descTipoCalc", (ICalcField)new Decode("codeTipo", tipos));
        response.addMandatorySort(new Sort(SortMode.DESCENDING, "descTipoCalc"));
        response.addMandatorySort(new Sort(SortMode.DESCENDING, "dateInicio"));
        return response;
    }

    @OnAJAX(value="alunoscurso")
    public IJSONResponse getAlunosCurso() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeCurso)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSE().getHistalunDataSet(), new String[]{Histalun.FK().id().CODEALUNO(), Histalun.FK().id().CODECURSO(), "codeASCur", "numberCreEur", "numberCreEurApr", "numberDiscip", "numberDisApr", Histalun.FK().alunos().individuo().NAMECOMPLETO()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Histalun.FK().alunos().individuo(), JoinType.NORMAL);
        response.addFilter(new Filter(Histalun.FK().id().CODELECTIVO(), FilterType.EQUALS, this.getNetQAUser().getAnoLectivo().getCodeLectivo()));
        response.addFilter(new Filter(Histalun.FK().id().CODECURSO(), FilterType.EQUALS, this.codeCurso));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, Histalun.FK().alunos().individuo().NAMECOMPLETO()));
        if (StringUtils.isNotBlank((String)this.filterTextAlunos)) {
            response.addFilterSet(ConditionOperator.OR).like(Histalun.FK().id().CODEALUNO(), this.filterTextAlunos).like(Histalun.FK().alunos().individuo().NAMECOMPLETO(), this.filterTextAlunos);
        }
        SituacaoAlunoHistoricosCalc calc = new SituacaoAlunoHistoricosCalc(this.stageMessages);
        calc.setLazyLoadRelations(true);
        response.addCalculatedField("tiposAluno", (ICalcField)calc);
        response.addCalculatedField("situacoesAluno", (ICalcField)calc);
        return response;
    }

    @OnAJAX(value="alunospauta")
    public IJSONResponse getAlunosPauta() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codePauta)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getLND().getAlunosPautasDataSet(), new String[]{AlunosPautas.FK().alunos().id().CODECURSO(), AlunosPautas.FK().alunos().id().CODEALUNO(), AlunosPautas.FK().alunos().individuo().NAMECOMPLETO(), "dateNota", "numberNota", AlunosPautas.FK().tableStatus().DESCSTATUS()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)AlunosPautas.FK().alunos(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)AlunosPautas.FK().alunos().individuo(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)AlunosPautas.FK().tableStatus(), JoinType.NORMAL);
        response.addFilter(new Filter(AlunosPautas.FK().pautas().CODEPAUTA(), FilterType.EQUALS, this.codePauta));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, AlunosPautas.FK().alunos().individuo().NAMECOMPLETO()));
        return response;
    }

    @OnAJAX(value="alunosdisciplina")
    public IJSONResponse getAlunosUC() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeDiscip)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSE().getInscriDataSet(), new String[]{Inscri.FK().id().CODEALUNO(), Inscri.FK().id().CODECURSO(), "numberNotFin", Inscri.FK().tableQualita().DESCQUALITA(), Inscri.FK().histPeriodos().histalun().cursos().NAMECURSO(), Inscri.FK().histPeriodos().histalun().alunos().individuo().NAMECOMPLETO()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Inscri.FK().histPeriodos().histalun().alunos().individuo(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Inscri.FK().histPeriodos().histalun().cursos(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Inscri.FK().tableStatus(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Inscri.FK().tableQualita(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter(Inscri.FK().id().CODELECTIVO(), FilterType.EQUALS, this.getNetQAUser().getAnoLectivo().getCodeLectivo()));
        response.addFilter(new Filter(Inscri.FK().id().CODEDISCIP(), FilterType.EQUALS, this.codeDiscip));
        if (StringUtils.isNotBlank((String)this.filterTextAlunos)) {
            response.addFilterSet(ConditionOperator.OR).like(Inscri.FK().id().CODEALUNO(), this.filterTextAlunos).like(Inscri.FK().id().CODECURSO(), this.filterTextAlunos).like(Inscri.FK().histPeriodos().histalun().alunos().individuo().NAMECOMPLETO(), this.filterTextAlunos).like("codeTurmaC", this.filterTextAlunos).like("codeTurmaE", this.filterTextAlunos).like("codeTurmaL", this.filterTextAlunos).like("codeTurmaO", this.filterTextAlunos).like("codeTurmaP", this.filterTextAlunos).like("codeTurmaS", this.filterTextAlunos).like("codeTurmaT", this.filterTextAlunos).like("codeTurmaTp", this.filterTextAlunos).like(Inscri.FK().histPeriodos().histalun().cursos().NAMECURSO(), this.filterTextAlunos);
        }
        response.addCalculatedField("turmas", (ICalcField)new InscriTurmasListCalc());
        response.addCalculatedField("situacao", (ICalcField)new InscriSituacaoCalc());
        response.addCalculatedField("nota", (ICalcField)new NumericFormater("numberNotFin", "##0.00"));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, Inscri.FK().histPeriodos().histalun().alunos().individuo().NAMECOMPLETO()));
        return response;
    }

    @OnAJAX(value="atividadesNaoLetivas")
    public IJSONResponse getAtividadesNaoLetivas() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        String[] fields = new String[]{"id", "idDocente", "idProdAssoc", "tipoProducao", Producao.FK().tableItemAtividade().tableGrupoAtividade().ID(), Producao.FK().tableItemAtividade().tableGrupoAtividade().DESCRICAO(), Producao.FK().tableItemAtividade().ID(), Producao.FK().tableItemAtividade().DESCRICAO(), "titulo", "anoProducao", "paisIso", Producao.FK().tableMeioDivulgacao().ID(), Producao.FK().tableMeioDivulgacao().DESCRICAO(), "idiomaIso", "link", "doi", "wos", "relevante"};
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.fcdService.getProducaoDataSet(), fields);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Producao.FK().tableItemAtividade(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Producao.FK().tableItemAtividade().tableGrupoAtividade(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Producao.FK().tableMeioDivulgacao(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter("idDocente", FilterType.EQUALS, this.codeFuncionario));
        if (StringUtils.isNotBlank((String)this.filterTextInvestigacao)) {
            response.addFilterSet(ConditionOperator.OR).like("titulo", this.filterTextInvestigacao).like(Producao.FK().tableItemAtividade().tableGrupoAtividade().DESCRICAO(), this.filterTextInvestigacao).like(Producao.FK().tableItemAtividade().DESCRICAO(), this.filterTextInvestigacao).like("anoProducao", this.filterTextInvestigacao).like(Producao.FK().tableMeioDivulgacao().DESCRICAO(), this.filterTextInvestigacao);
        }
        LinkedHashMap<String, String> tiposProducao = new LinkedHashMap<String, String>();
        tiposProducao.put("TECNICA", this.messages.get("TECNICA"));
        tiposProducao.put("CIENTIFICA", this.messages.get("CIENTIFICA"));
        tiposProducao.put("ARTISTICA", this.messages.get("ARTISTICA"));
        tiposProducao.put("OUTRAS", this.messages.get("OUTRAS"));
        response.addCalculatedField("descTipoProducao", (ICalcField)new Decode("tipoProducao", tiposProducao));
        response.addCalculatedField("descRelevante", (ICalcField)new Checked2("relevante", "true", this.messages.get("sim"), this.messages.get("nao")));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "descTipoProducao"));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "tipoProducao"));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, Producao.FK().tableItemAtividade().tableGrupoAtividade().DESCRICAO()));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, Producao.FK().tableItemAtividade().DESCRICAO()));
        response.addMandatorySort(new Sort(SortMode.DESCENDING, "anoProducao"));
        return response;
    }

    @OnAJAX(value="aulasdisciplina")
    public IJSONResponse getAulasUC() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeDiscip)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select campo_referencia||'|'||nr_aula id,\n");
        sql.append("       manu_csh.DESCRICAO_DIA_SEMANA(ch.dia_semana) dia_semana,\n");
        sql.append("       manu_csh.MIN_TO_HORA(ch.hora_inicio) hora_inicio,\n");
        sql.append("       ch.duracao_celula,\n");
        sql.append("       ds_discip,\n");
        sql.append("       cd_turma,\n");
        sql.append("       i.nm_completo docente,\n");
        sql.append("       ds_sala\n");
        sql.append("  from horario_referencia hr\n");
        sql.append("  join detalhe_horario_ref dhr\n");
        sql.append("    on dhr.campo_referencia = hr.campo_referencia\n");
        sql.append("   and dhr.nr_aula = hr.nr_aula\n");
        sql.append("  join configuracao_horario ch\n");
        sql.append("    on ch.campo_referencia = hr.campo_referencia\n");
        sql.append("  join tbsala s\n");
        sql.append("    on s.cd_sala = dhr.cd_sala\n");
        sql.append("  join tbdiscip d\n");
        sql.append("    on d.cd_discip = dhr.cd_discip\n");
        sql.append("  left outer join funcionarios f\n");
        sql.append("    on dhr.cd_docente = f.cd_funcionario\n");
        sql.append("  left outer join individuo i\n");
        sql.append("    on i.id_individuo = f.id_individuo\n");
        sql.append(" where dhr.cd_lectivo = " + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "\n");
        sql.append(" and dhr.cd_discip = " + this.codeDiscip + "\n");
        sql.append(" order by ch.dia_semana, ch.hora_inicio\n");
        SIGESFactory.openTransaction(null);
        SQLDataSet ds = new SQLDataSet(this.siges.getSession(), sql.toString(), SQLDialect.ORACLE);
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)ds);
        return response;
    }

    @OnAJAX(value="cargosdocente")
    public IJSONResponse getCargosDocente() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSP().getCargoDataSet(), new String[]{Cargo.FK().tableCargo().DESCCARGO(), Cargo.FK().cargoInsts().tableInstituic().DESCINSTITUIC(), Cargo.FK().id().DATEINICIO()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Cargo.FK().tableCargo(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Cargo.FK().cargoInsts(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Cargo.FK().cargoInsts().tableInstituic(), JoinType.LEFT_OUTER_JOIN);
        response.addCalculatedField("descricaoCargo", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return Cargo.FK().tableCargo().DESCCARGO();
            }

            public String getValue(Object record, String calcFieldID) {
                Cargo cargo = (Cargo)record;
                String result = cargo.getTableCargo().getDescCargo();
                if (StringUtils.isNotBlank((String)cargo.getDescricao())) {
                    result = result + " (" + cargo.getDescricao() + ")";
                }
                return result;
            }
        });
        response.addCalculatedField("estado", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return null;
            }

            public String getValue(Object record, String calcFieldID) {
                Cargo cargo = (Cargo)record;
                if (new Character('S').equals(cargo.getCodeActual())) {
                    return "<b>" + (String)NetQADataProviderStage.this.stageMessages.get("atual") + "</b>";
                }
                return cargo.getDateFim() == null ? "" : DateUtils.simpleDateToString((Date)cargo.getDateFim());
            }
        });
        response.addCalculatedField("instituicoes", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return null;
            }

            public String getValue(Object record, String calcFieldID) {
                Cargo cargo = (Cargo)record;
                if (cargo.getCargoInsts().isEmpty()) {
                    return null;
                }
                ArrayList<String> instituicoesList = new ArrayList<String>();
                for (CargoInst cargoInstituics : cargo.getCargoInsts()) {
                    instituicoesList.add(cargoInstituics.getTableInstituic().getDescInstituic());
                }
                return CollectionUtils.listToSeparatedString(instituicoesList, (String)"<br/>");
            }
        });
        response.addFilter(new Filter(Cargo.FK().funcionarios().CODEFUNCIONARIO(), FilterType.EQUALS, this.codeFuncionario));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "codeActual"));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "dateFim"));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, Cargo.FK().tableCargo().DESCCARGO()));
        return response;
    }

    @OnAJAX(value="dsdcurso")
    public IJSONResponse getDSDCurso() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeCurso)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSD().getDocTurmaDataSet(), new String[]{DocTurma.FK().id().CODEDOCENTE(), DocTurma.FK().id().CODELECTIVO(), DocTurma.FK().id().CODEDISCIP(), DocTurma.FK().id().CODETURMA(), "factorPond", DocTurma.FK().id().CODEDURACAO(), "numberHoraAnual", "numberHoraSemnl", DocTurma.FK().turma().tableDiscip().DESCDISCIP(), DocTurma.FK().tableTiposOcupacao().DESCTIPOOCUP(), DocTurma.FK().funcionarios().individuo().NAMECOMPLETO()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)DocTurma.FK().funcionarios().individuo(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)DocTurma.FK().tableTiposOcupacao(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)DocTurma.FK().cursos(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter(DocTurma.FK().id().CODELECTIVO(), FilterType.EQUALS, this.getNetQAUser().getAnoLectivo().getCodeLectivo()));
        response.addFilter((Filter)new FilterExtendedSQL("nvl({curso},MANU_CSD.DEVOLVE_CURSO_TURMA({letivo}, {duracao}, {discip}, {turma}))= " + this.codeCurso, new String[]{"curso", DocTurma.FK().cursos().CODECURSO(), "letivo", DocTurma.FK().id().CODELECTIVO(), "duracao", DocTurma.FK().id().CODEDURACAO(), "discip", DocTurma.FK().id().CODEDISCIP(), "turma", DocTurma.FK().id().CODETURMA()}));
        if (StringUtils.isNotBlank((String)this.filterTextDSD)) {
            response.addFilterSet(ConditionOperator.OR).like(DocTurma.FK().id().CODEDISCIP(), this.filterTextDSD).like(DocTurma.FK().id().CODEDOCENTE(), this.filterTextDSD).like(DocTurma.FK().id().CODETURMA(), this.filterTextDSD).like(DocTurma.FK().turma().tableDiscip().DESCDISCIP(), this.filterTextDSD).like(DocTurma.FK().funcionarios().individuo().NAMECOMPLETO(), this.filterTextDSD);
        }
        response.addCalculatedField("duracao", (ICalcField)new PeriodoLectivoCalcField(DocTurma.FK().id().CODEDURACAO()));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, DocTurma.FK().id().CODEDURACAO()));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, DocTurma.FK().turma().tableDiscip().DESCDISCIP()));
        return response;
    }

    @OnAJAX(value="dsddocente")
    public IJSONResponse getDSDDocente() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSD().getDocTurmaDataSet(), new String[]{DocTurma.FK().id().CODEDOCENTE(), DocTurma.FK().id().CODETURMA(), DocTurma.FK().id().CODEDISCIP(), DocTurma.FK().id().CODEDURACAO(), "factorPond", "numberHoraAnual", "numberHoraSemnl", DocTurma.FK().tableTiposOcupacao().DESCTIPOOCUP(), DocTurma.FK().turma().tableDiscip().CODEDISCIP(), DocTurma.FK().turma().tableDiscip().DESCDISCIP()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)DocTurma.FK().funcionarios().individuo(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)DocTurma.FK().tableTiposOcupacao(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter(DocTurma.FK().id().CODELECTIVO(), FilterType.EQUALS, this.getNetQAUser().getAnoLectivo().getCodeLectivo()));
        response.addFilter(new Filter(DocTurma.FK().id().CODEDOCENTE(), FilterType.EQUALS, this.codeFuncionario));
        if (StringUtils.isNotBlank((String)this.filterTextDSD)) {
            response.addFilterSet(ConditionOperator.OR).like(DocTurma.FK().id().CODEDISCIP(), this.filterTextDSD).like(DocTurma.FK().id().CODETURMA(), this.filterTextDSD).like(DocTurma.FK().turma().tableDiscip().DESCDISCIP(), this.filterTextDSD);
        }
        response.addCalculatedField("duracao", (ICalcField)new PeriodoLectivoCalcField(DocTurma.FK().id().CODEDURACAO()));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "duracao"));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, Inscri.FK().histPeriodos().histalun().alunos().individuo().NAMECOMPLETO()));
        return response;
    }

    @OnAJAX(value="dsddisciplina")
    public IJSONResponse getDSDUC() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeDiscip)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSD().getDocTurmaDataSet(), new String[]{DocTurma.FK().id().CODEDOCENTE(), DocTurma.FK().id().CODETURMA(), DocTurma.FK().id().CODEDISCIP(), DocTurma.FK().id().CODEDURACAO(), "factorPond", "numberHoraAnual", "numberHoraSemnl", DocTurma.FK().tableTiposOcupacao().DESCTIPOOCUP(), DocTurma.FK().id().CODEDOCENTE(), DocTurma.FK().funcionarios().individuo().NAMECOMPLETO()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)DocTurma.FK().funcionarios().individuo(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)DocTurma.FK().tableTiposOcupacao(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter(DocTurma.FK().id().CODELECTIVO(), FilterType.EQUALS, this.getNetQAUser().getAnoLectivo().getCodeLectivo()));
        response.addFilter(new Filter(DocTurma.FK().id().CODEDISCIP(), FilterType.EQUALS, this.codeDiscip));
        if (StringUtils.isNotBlank((String)this.filterTextDSD)) {
            response.addFilterSet(ConditionOperator.OR).like(DocTurma.FK().id().CODEDISCIP(), this.filterTextDSD).like(DocTurma.FK().id().CODEDOCENTE(), this.filterTextDSD).like(DocTurma.FK().id().CODETURMA(), this.filterTextDSD).like(DocTurma.FK().funcionarios().individuo().NAMECOMPLETO(), this.filterTextDSD);
        }
        response.addCalculatedField("duracao", (ICalcField)new PeriodoLectivoCalcField(DocTurma.FK().id().CODEDURACAO()));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, Inscri.FK().histPeriodos().histalun().alunos().individuo().NAMECOMPLETO()));
        return response;
    }

    public Boolean getExisteMV() throws DataSetException {
        Boolean existeMV = false;
        SIGESFactory.openTransaction(null);
        SQLDataSet ds = new SQLDataSet(this.siges.getSession(), "select * from all_mviews where mview_name = 'INQUIRIDOS_QUERY'", SQLDialect.ORACLE);
        if (ds.query().count() > 0L) {
            existeMV = true;
        }
        return existeMV;
    }

    @OnAJAX(value="experienciaProfissionalDocente")
    public IJSONResponse getExperienciasProfissionaisDocentes() throws UnsupportedDataSetFeature, DataSetException {
        String[] fields = new String[]{"nameEmpresa", "descricao", "dateInicio", "dateFim"};
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSP().getHabilitProfisDataSet(), fields);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)HabilitProfis.FK().tableProfissao(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)HabilitProfis.FK().tableNaciona(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter(HabilitProfis.FK().funcionarios().CODEFUNCIONARIO(), FilterType.EQUALS, this.codeFuncionario));
        if (StringUtils.isNotBlank((String)this.filterTextExperienciaProfissional)) {
            response.addFilterSet(ConditionOperator.OR).like("nameEmpresa", this.filterTextExperienciaProfissional).like("descricao", this.filterTextExperienciaProfissional).like(HabilitProfis.FK().tableNaciona().DESCPAIS(), this.filterTextExperienciaProfissional).like(HabilitProfis.FK().tableProfissao().DESCPROFISSAO(), this.filterTextExperienciaProfissional);
        }
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "dateInicio"));
        response.addCalculatedField("descricaoCalc", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return null;
            }

            public String getValue(Object record, String calcFieldID) {
                HabilitProfis experiencia = (HabilitProfis)record;
                StringBuffer buffer = new StringBuffer();
                NetQADataProviderStage.this.addLine(buffer, true, experiencia.getNameEmpresa(), null);
                if (experiencia.getTableNaciona() != null) {
                    NetQADataProviderStage.this.addLine(buffer, false, experiencia.getTableNaciona().getDescPais(), StringUtils.isNotBlank((String)experiencia.getNameEmpresa()) ? " ($value)" : null);
                }
                if (experiencia.getTableProfissao() != null) {
                    NetQADataProviderStage.this.addLine(buffer, true, experiencia.getTableProfissao().getDescProfissao(), null);
                }
                NetQADataProviderStage.this.addLine(buffer, true, experiencia.getDescricao(), null);
                return buffer.toString();
            }
        });
        return response;
    }

    @OnAJAX(value="habilitacoesLiterarias")
    public IJSONResponse getHabilitacoesLiterarias() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        String[] fields = new String[]{HabilitLiter.FK().funcionarios().CODEFUNCIONARIO(), HabilitLiter.FK().id().CODENIVEL(), HabilitLiter.FK().tableHabilitacoes().CODEHABILITACAO(), HabilitLiter.FK().tableHabilitacoes().DESCHABILITACAO(), HabilitLiter.FK().tableNaciona().CODENACIONA(), HabilitLiter.FK().tableNaciona().ISO(), HabilitLiter.FK().tableInstProv().CODEINSTITUICAO(), HabilitLiter.FK().tableInstProv().DESCINSTITUICAO(), HabilitLiter.FK().tableCursosProv().CODECURSO(), HabilitLiter.FK().tableCursosProv().DESCCURSO(), HabilitLiter.FK().tableEspcAcad().CODEESPCACAD(), HabilitLiter.FK().tableEspcAcad().DESCESPCACAD(), HabilitLiter.FK().tableAreaEstudo().CODEAREAESTUDO(), HabilitLiter.FK().tableAreaEstudo().DESCAREAESTUDO(), "dateObtencao", HabilitLiter.FK().tableClassQual().CODECLASSQUAL(), HabilitLiter.FK().tableClassQual().DESCCLASSQUAL(), "dateEquivalencia", "descricao", "codeTipo", "codeActual"};
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSP().getHabilitLiterDataSet(), fields);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)HabilitLiter.FK().tableHabilitacoes(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)HabilitLiter.FK().tableNaciona(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)HabilitLiter.FK().tableInstProv(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)HabilitLiter.FK().tableCursosProv(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)HabilitLiter.FK().tableEspcAcad(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)HabilitLiter.FK().tableAreaEstudo(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)HabilitLiter.FK().tableClassQual(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter(HabilitLiter.FK().id().CODEFUNCIONARIO(), FilterType.EQUALS, this.codeFuncionario));
        response.addCalculatedField("ano", (ICalcField)new YearCalc("dateObtencao"));
        if (StringUtils.isNotBlank((String)this.filterTextHabilitacao)) {
            response.addFilterSet(ConditionOperator.OR).like(HabilitLiter.FK().tableHabilitacoes().DESCHABILITACAO(), this.filterTextHabilitacao).like(HabilitLiter.FK().tableNaciona().DESCNACIONA(), this.filterTextHabilitacao).like(HabilitLiter.FK().tableInstProv().DESCINSTITUICAO(), this.filterTextHabilitacao).like(HabilitLiter.FK().tableCursosProv().DESCCURSO(), this.filterTextHabilitacao).like(HabilitLiter.FK().tableEspcAcad().DESCESPCACAD(), this.filterTextHabilitacao).like(HabilitLiter.FK().tableAreaEstudo().DESCAREAESTUDO(), this.filterTextHabilitacao).like(HabilitLiter.FK().tableClassQual().DESCCLASSQUAL(), this.filterTextHabilitacao);
        }
        LinkedHashMap<String, String> tiposProducao = new LinkedHashMap<String, String>();
        tiposProducao.put("N", this.messages.get("nacional"));
        tiposProducao.put("E", this.messages.get("estrangeira"));
        tiposProducao.put("R", this.messages.get("reconhecida"));
        response.addCalculatedField("descTipoCalc", (ICalcField)new Decode("codeTipo", tiposProducao));
        response.addCalculatedField("atual", (ICalcField)new Checked2("codeActual", "S", this.messages.get("sim"), this.messages.get("nao")));
        response.addMandatorySort(new Sort(SortMode.DESCENDING, "dateObtencao"));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, HabilitLiter.FK().tableHabilitacoes().DESCHABILITACAO()));
        return response;
    }

    @OnAJAX(value="historicoDocente")
    public IJSONResponse getHistoricoDocente() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT CALC.LECT_FORMATADO(hd.cd_lectivo) lectivo, hd.dt_inicial, hd.dt_final,\n");
        sql.append("       hd.HORAS_CONTRATADAS HORAS_CONT_SEMANAL, hd.HORAS_CONT_PERIODO\n");
        sql.append(" FROM historico_docente hd\n");
        sql.append("WHERE hd.cd_docente = " + this.codeFuncionario + "\n");
        SIGESFactory.openTransaction(null);
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)new SQLDataSet(SIGESFactory.getSession(null).connection(), sql.toString(), SQLDialect.ORACLE));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "lectivo"));
        return response;
    }

    @OnAJAX(value="idiomasDocente")
    public IJSONResponse getIdiomasDocentes() {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        String[] fields = new String[]{IdiomasIndividuo.FK().idiomasDic().SIGLA(), IdiomasIndividuo.FK().idiomasDic().IDIOMA(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlCompOral().ID(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlCompOral().NIVEL(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlCompOral().CATEGORIA(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlEscrita().ID(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlEscrita().NIVEL(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlEscrita().CATEGORIA(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlIntOral().ID(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlIntOral().NIVEL(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlIntOral().CATEGORIA(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlLeitura().ID(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlLeitura().NIVEL(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlLeitura().CATEGORIA(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlProdOral().ID(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlProdOral().NIVEL(), IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlProdOral().CATEGORIA()};
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getSIGES().getIdiomasIndividuoDataSet(), fields);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlCompOral(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlEscrita(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlIntOral(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlLeitura(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlProdOral(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)IdiomasIndividuo.FK().individuo(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)IdiomasIndividuo.FK().idiomasDic(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)IdiomasIndividuo.FK().individuo().funcionarioses(), JoinType.LEFT_OUTER_JOIN);
        response.addCalculatedField("compreensaoOralCalc", (ICalcField)new ConcatenateFields(IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlCompOral().NIVEL() + "," + IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlCompOral().CATEGORIA(), " - "));
        response.addCalculatedField("nivelLeituraCalc", (ICalcField)new ConcatenateFields(IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlLeitura().NIVEL() + "," + IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlLeitura().CATEGORIA(), " - "));
        response.addCalculatedField("nivelIteracaoOralCalc", (ICalcField)new ConcatenateFields(IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlIntOral().NIVEL() + "," + IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlIntOral().CATEGORIA(), " - "));
        response.addCalculatedField("nivelProducaoOralCalc", (ICalcField)new ConcatenateFields(IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlProdOral().NIVEL() + "," + IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlProdOral().CATEGORIA(), " - "));
        response.addCalculatedField("nivelEscritaCalc", (ICalcField)new ConcatenateFields(IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlEscrita().NIVEL() + "," + IdiomasIndividuo.FK().tableNivelIdiomaByIdNvlEscrita().CATEGORIA(), " - "));
        response.addFilter(new Filter(IdiomasIndividuo.FK().individuo().funcionarioses().CODEFUNCIONARIO(), FilterType.EQUALS, this.codeFuncionario));
        return response;
    }

    @OnAJAX(value="inqueritoscurso")
    public IJSONResponse getInqueritosCurso() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeCurso)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.comquest.getSurveyDataSet(), new String[]{"id", "title", "startDate", "endDate", "isMandatory", "isActive", "isAnonymous"});
        Boolean existeMV = this.getExisteMV();
        StringBuffer filterSQL = new StringBuffer();
        if (!existeMV.booleanValue()) {
            response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Survey.FK().surveyInstances(), JoinType.NORMAL);
            response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Survey.FK().surveyInstances().answers(), JoinType.NORMAL);
            response.addFilter((Filter)new FilterExtendedSQL("(substr(REGEXP_substr({params}, 'cd_curso=[0-9A-Z]+'), 10) = " + this.codeCurso + " or substr(REGEXP_substr({bksi}, 'cd_cur_dis:[0-9A-Z]+'), 12) = " + this.codeCurso + " or substr(REGEXP_substr({bksi}, 'cd_curso:[0-9A-Z]+'), 10) = " + this.codeCurso + " or substr(REGEXP_substr({bka}, 'cd_curso:[0-9A-Z]+'), 10) = " + this.codeCurso + " or substr(REGEXP_substr({bda}, 'cd_cur_dis=[0-9A-Z]+'), 12) = " + this.codeCurso + ")", new String[]{"params", Survey.FK().surveyInstances().profileInstance().PARAMETERLIST(), "bksi", Survey.FK().surveyInstances().BUSINESSKEY(), "bka", Survey.FK().surveyInstances().answers().BUSINESSKEY(), "bda", Survey.FK().surveyInstances().answers().BUSINESSDATA()}));
            response.addFilter((Filter)new FilterExtendedSQL("(substr(REGEXP_substr({bksi}, 'cd_lectivo:[0-9A-Z]+'), 12) = '" + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "'" + "or substr(REGEXP_substr({bka}, 'cd_lectivo:[0-9A-Z]+'), 12) = '" + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "')", new String[]{"bksi", Survey.FK().surveyInstances().BUSINESSKEY(), "bka", Survey.FK().surveyInstances().answers().BUSINESSKEY()}));
        } else {
            filterSQL.append("(");
            filterSQL.append(" {surveyid} in (select survey_id ");
            filterSQL.append("                from   inquiridos_query");
            filterSQL.append("                where " + this.codeCurso + " in (cd_curso_dst, cd_curso)");
            filterSQL.append("                and    cd_lectivo = '" + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "')");
            filterSQL.append(")");
            response.addFilter((Filter)new FilterExtendedSQL(filterSQL.toString(), new String[]{"surveyid", "id"}));
        }
        response.addCalculatedField("actions", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return null;
            }

            public String getValue(Object record, String calcFieldID) {
                Survey survey = (Survey)record;
                StringBuffer buffer = new StringBuffer();
                buffer.append("<a href='javascript:showInqueritosRespondentes(" + survey.getId() + ");'>" + (String)NetQADataProviderStage.this.stageMessages.get("seeAnswers") + "</a> | ");
                buffer.append("<a href='javascript:showInqueritosReports(" + survey.getId() + ");'>" + (String)NetQADataProviderStage.this.stageMessages.get("seeReports") + "</a>");
                return buffer.toString();
            }
        });
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "id"));
        return response;
    }

    @OnAJAX(value="inqueritosdocente")
    public IJSONResponse getInqueritosDocente() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.comquest.getSurveyDataSet(), new String[]{"id", "title", "startDate", "endDate", "isMandatory", "isActive", "isAnonymous"});
        Boolean existeMV = this.getExisteMV();
        StringBuffer filterSQL = new StringBuffer();
        if (!existeMV.booleanValue()) {
            response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Survey.FK().surveyInstances(), JoinType.LEFT_OUTER_JOIN);
            response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Survey.FK().surveyInstances().answers(), JoinType.LEFT_OUTER_JOIN);
            response.setDistinct(Boolean.valueOf(true));
            filterSQL.append("(");
            filterSQL.append(" (substr(REGEXP_substr({bksi}, 'cd_docente:[0-9A-Z]+'), 12) = " + this.codeFuncionario + " and ");
            filterSQL.append(" substr(REGEXP_substr({bksi}, 'cd_lectivo:[0-9A-Z]+'), 12) = '" + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "')");
            filterSQL.append(" or ");
            filterSQL.append(" (substr(REGEXP_substr({bka}, 'cd_docente:[0-9A-Z]+'), 12) = " + this.codeFuncionario + " and ");
            filterSQL.append(" substr(REGEXP_substr({bka}, 'cd_lectivo:[0-9A-Z]+'), 12) = '" + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "')");
            filterSQL.append(")");
            response.addFilter((Filter)new FilterExtendedSQL(filterSQL.toString(), new String[]{"bksi", Survey.FK().surveyInstances().BUSINESSKEY(), "bka", Survey.FK().surveyInstances().answers().BUSINESSKEY()}));
        } else {
            filterSQL.append("(");
            filterSQL.append(" {surveyid} in (select survey_id ");
            filterSQL.append("                from   inquiridos_query");
            filterSQL.append("                where " + this.codeFuncionario + " in (cd_docente_dst, cd_docente)");
            filterSQL.append("                and    cd_lectivo = '" + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "')");
            filterSQL.append(")");
            response.addFilter((Filter)new FilterExtendedSQL(filterSQL.toString(), new String[]{"surveyid", "id"}));
        }
        response.addCalculatedField("actions", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return null;
            }

            public String getValue(Object record, String calcFieldID) {
                Survey survey = (Survey)record;
                StringBuffer buffer = new StringBuffer();
                buffer.append("<a href='javascript:showInqueritosRespondentes(" + survey.getId() + ");'>" + (String)NetQADataProviderStage.this.stageMessages.get("seeAnswers") + "</a> | ");
                buffer.append("<a href='javascript:showInqueritosReports(" + survey.getId() + ");'>" + (String)NetQADataProviderStage.this.stageMessages.get("seeReports") + "</a>");
                return buffer.toString();
            }
        });
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "id"));
        return response;
    }

    @OnAJAX(value="inqueritosrespostas")
    public IJSONResponse getInqueritosInstances() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.surveyId)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.comquest.getSurveyInstanceDataSet(), new String[]{SurveyInstance.FK().profileInstance().BUSINESSNAME(), "title", "fillDate", SurveyInstance.FK().surveyState().ID()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)SurveyInstance.FK().profileInstance(), JoinType.NORMAL);
        response.addFilter(new Filter(SurveyInstance.FK().survey().ID(), FilterType.EQUALS, this.surveyId));
        response.addCalculatedField("state", (ICalcField)new SurveyStateDescription(this.context.getLanguage(), SurveyInstance.FK().surveyState().ID()));
        if (StringUtils.isNotBlank((String)this.codeCurso)) {
            response.addFilter((Filter)new FilterExtendedSQL("(substr(REGEXP_substr({bk}, 'cd_curso:[0-9A-Z]+'), 10) = " + this.codeCurso + " or substr(REGEXP_substr({bk}, 'cd_cur_dis:[0-9A-Z]+'), 12) = " + this.codeCurso + " or substr(REGEXP_substr({params}, 'cd_curso=[0-9A-Z]+'), 10) = " + this.codeCurso + ")", new String[]{"bk", SurveyInstance.FK().BUSINESSKEY(), "params", SurveyInstance.FK().profileInstance().PARAMETERLIST()}));
        } else if (StringUtils.isNotBlank((String)this.codeDiscip)) {
            response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)SurveyInstance.FK().answers(), JoinType.NORMAL);
            response.setDistinct(Boolean.valueOf(true));
            StringBuffer filterSQL = new StringBuffer();
            filterSQL.append("(substr(REGEXP_substr({bksi}, 'cd_discip:[0-9A-Z]+'), 11) = " + this.codeDiscip);
            filterSQL.append(" or ");
            filterSQL.append("substr(REGEXP_substr({bka}, 'cd_discip:[0-9A-Z]+'), 11) = " + this.codeDiscip + ")");
            response.addFilter((Filter)new FilterExtendedSQL(filterSQL.toString(), new String[]{"bksi", "businessKey", "bka", SurveyInstance.FK().answers().BUSINESSKEY()}));
        } else if (StringUtils.isNotBlank((String)this.codeFuncionario)) {
            response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)SurveyInstance.FK().answers(), JoinType.NORMAL);
            response.setDistinct(Boolean.valueOf(true));
            StringBuffer filterSQL = new StringBuffer();
            filterSQL.append("(substr(REGEXP_substr({bksi}, 'cd_docente:[0-9A-Z]+'), 12) = " + this.codeFuncionario);
            filterSQL.append(" or ");
            filterSQL.append("substr(REGEXP_substr({bka}, 'cd_docente:[0-9A-Z]+'), 12) = " + this.codeFuncionario);
            filterSQL.append(" or ");
            filterSQL.append("substr(REGEXP_substr({params}, 'cd_funcionario:[0-9A-Z]+'), 16) = " + this.codeFuncionario + ")");
            response.addFilter((Filter)new FilterExtendedSQL(filterSQL.toString(), new String[]{"bksi", "businessKey", "bka", SurveyInstance.FK().answers().BUSINESSKEY(), "params", SurveyInstance.FK().profileInstance().PARAMETERLIST()}));
        }
        response.addDefaultSort(new Sort(SortMode.ASCENDING, SurveyInstance.FK().profileInstance().BUSINESSNAME()));
        return response;
    }

    @OnAJAX(value="inqueritosreports")
    public IJSONResponse getInqueritosReports() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.surveyId)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.comquest.getSurveyReportInstanceDataSet(), new String[]{SurveyReportInstance.FK().surveyReport().TITLE(), "title", "outputFormat", "creationDate", "documentId"});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)SurveyReportInstance.FK().surveyReport(), JoinType.NORMAL);
        response.addFilter(new Filter(SurveyReportInstance.FK().surveyReport().survey().ID(), FilterType.EQUALS, this.surveyId));
        if (StringUtils.isNotBlank((String)this.codeCurso)) {
            response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)SurveyInstance.FK().profileInstance(), JoinType.LEFT_OUTER_JOIN);
            response.addFilter((Filter)new FilterExtendedSQL("(profile_instance_id is null or substr(REGEXP_substr({params}, 'cd_curso=[0-9A-Z]+'), 10) = " + this.codeCurso + ")", new String[]{"params", SurveyReportInstance.FK().profileInstance().PARAMETERLIST()}));
        } else if (StringUtils.isNotBlank((String)this.codeFuncionario)) {
            response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)SurveyInstance.FK().profileInstance(), JoinType.LEFT_OUTER_JOIN);
            response.addFilter((Filter)new FilterExtendedSQL("(profile_instance_id is null or substr(REGEXP_substr({params}, 'cd_funcionario:[0-9A-Z]+'), 16) = " + this.codeFuncionario + ")", new String[]{"params", SurveyReportInstance.FK().profileInstance().PARAMETERLIST()}));
        } else if (StringUtils.isNotBlank((String)this.codeDiscip)) {
            // empty if block
        }
        response.addCalculatedField("format", (ICalcField)new SurveyReportFormatCalc("outputFormat"));
        AbstractCalcField calcField = new AbstractCalcField(){

            public String getOrderByField() {
                return null;
            }

            public String getValue(Object record, String calcFieldID) {
                SurveyReportInstance surveyReportInstance = (SurveyReportInstance)record;
                if ("title".equals(calcFieldID)) {
                    return surveyReportInstance.getSurveyReport().getTitle() + (StringUtils.isNotBlank((String)surveyReportInstance.getTitle()) ? " - " + surveyReportInstance.getTitle() : "");
                }
                if ("downloadLink".equals(calcFieldID)) {
                    if (surveyReportInstance.getDocumentId() != null) {
                        NetQADataProviderStage.this.documentRepositoryManager.authorizeDocumentForCurrentSession(NetQADataProviderStage.this.context.getSession(), surveyReportInstance.getDocumentId());
                    }
                    String url = "";
                    url = StringUtils.isNotEmpty((String)surveyReportInstance.getOutputFormat()) && surveyReportInstance.getOutputFormat().toUpperCase().contains("PDF") ? "javascript:openreportPreview(" + surveyReportInstance.getDocumentId() + ");" : AbstractDIFTag.getHttpControllerConfig().getListenerDocName() + "?" + "docID" + "=" + surveyReportInstance.getDocumentId();
                    return "<a href='" + url + "'>" + (String)NetQAUtils.getApplicationMessages((String)NetQADataProviderStage.this.context.getLanguage()).get("download") + "</a>";
                }
                return null;
            }
        };
        response.addCalculatedField("title", (ICalcField)calcField);
        response.addCalculatedField("downloadLink", (ICalcField)calcField);
        response.addDefaultSort(new Sort(SortMode.ASCENDING, SurveyReportInstance.FK().surveyReport().TITLE()));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, "title"));
        return response;
    }

    @OnAJAX(value="inqueritosdisciplina")
    public IJSONResponse getInqueritosUC() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeDiscip)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.comquest.getSurveyDataSet(), new String[]{"id", "title", "startDate", "endDate", "isMandatory", "isActive", "isAnonymous"});
        Boolean existeMV = this.getExisteMV();
        StringBuffer filterSQL = new StringBuffer();
        if (!existeMV.booleanValue()) {
            response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Survey.FK().surveyInstances(), JoinType.LEFT_OUTER_JOIN);
            response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Survey.FK().surveyInstances().answers(), JoinType.LEFT_OUTER_JOIN);
            response.setDistinct(Boolean.valueOf(true));
            filterSQL.append("(");
            filterSQL.append(" (substr(REGEXP_substr({bksi}, 'cd_discip:[0-9A-Z]+'), 11) = " + this.codeDiscip + " and ");
            filterSQL.append(" substr(REGEXP_substr({bksi}, 'cd_lectivo:[0-9A-Z]+'), 12) = '" + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "')");
            filterSQL.append(" or ");
            filterSQL.append(" (substr(REGEXP_substr({bka}, 'cd_discip:[0-9A-Z]+'), 11) = " + this.codeDiscip + " and ");
            filterSQL.append(" substr(REGEXP_substr({bka}, 'cd_lectivo:[0-9A-Z]+'), 12) = '" + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "')");
            filterSQL.append(")");
            response.addFilter((Filter)new FilterExtendedSQL(filterSQL.toString(), new String[]{"bksi", Survey.FK().surveyInstances().BUSINESSKEY(), "bka", Survey.FK().surveyInstances().answers().BUSINESSKEY()}));
        } else {
            filterSQL.append("(");
            filterSQL.append(" {surveyid} in (select survey_id ");
            filterSQL.append("                from   inquiridos_query");
            filterSQL.append("                where  cd_discip = " + this.codeDiscip);
            filterSQL.append("                and    cd_lectivo = '" + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "')");
            filterSQL.append(")");
            response.addFilter((Filter)new FilterExtendedSQL(filterSQL.toString(), new String[]{"surveyid", "id"}));
        }
        response.addCalculatedField("actions", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return null;
            }

            public String getValue(Object record, String calcFieldID) {
                Survey survey = (Survey)record;
                StringBuffer buffer = new StringBuffer();
                buffer.append("<a href='javascript:showInqueritosRespondentes(" + survey.getId() + ");'>" + (String)NetQADataProviderStage.this.stageMessages.get("seeAnswers") + "</a> | ");
                buffer.append("<a href='javascript:showInqueritosReports(" + survey.getId() + ");'>" + (String)NetQADataProviderStage.this.stageMessages.get("seeReports") + "</a>");
                return buffer.toString();
            }
        });
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "id"));
        return response;
    }

    @OnAJAX(value="orientacaoTeses")
    public IJSONResponse getOrientacaoTestes() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        StringBuffer query = new StringBuffer();
        query.append(" SELECT * FROM ( ");
        query.append("SELECT OT.ID, OT.CD_DOCENTE, OT.CD_CURSO, OT.CD_ALUNO, OT.CD_TIPO,\n");
        query.append("       MANU_CSD.TIPO_ORIENTACAO(OT.CD_TIPO) DS_TIPO,\n");
        query.append("       DECODE(OT.CD_CURSO,NULL,'',' (' || OT.CD_CURSO || ') ') || DECODE(CD_TIPO,'I',\n");
        query.append("                 MANU_CSE.DEVOLVE_NM_CURSO(OT.CD_CURSO),\n");
        query.append("                 CURSO_EXTERNO) NM_CURSO,\n");
        query.append("       DECODE(OT.CD_CURSO,NULL,'',' (' || OT.CD_ALUNO || ')' ) || DECODE(CD_TIPO,'I',\n");
        query.append("                 MANU_CSE.DEVOLVE_NM_ALUNO(OT.CD_CURSO, OT.CD_ALUNO),\n");
        query.append("                 ALUNO_EXTERNO) NM_ALUNO,\n");
        query.append("       OT.DT_INICIO, OT.DT_FIM, OT.DS_TESE,\n");
        query.append("       OT.CD_LOCAL, MANU_CSP.DEVOLVE_DS_TBLOCAL_TRAB(CD_LOCAL) DS_LOCAL,\n");
        query.append("       OT.CD_ORIENTACAO,MANU_CSD.DEVOLVE_DS_ORIENTACAO(OT.CD_ORIENTACAO) DS_ORIENTACAO,\n");
        query.append("       OT.CD_PROVA, MANU_CSD.DEVOLVE_DS_PROVA(OT.CD_PROVA) DS_PROVA,\n");
        query.append("       OT.CD_CLASS_ACT, MANU_CSD.DEVOLVE_DS_CLASS_ACT(OT.CD_CLASS_ACT) DS_CLASS_ACT,\n");
        query.append("       OT.LINK_INFO, OT.ID_CATEGORIA\n");
        query.append("FROM   ORIENTA_TESE OT\n");
        query.append("WHERE\n");
        query.append("    CD_DOCENTE       = " + this.codeFuncionario);
        query.append(" ) WHERE 1 = 1 ");
        if (StringUtils.isNotBlank((String)this.filterTextorientacaoTeses)) {
            this.filterTextorientacaoTeses = this.filterTextorientacaoTeses.toLowerCase();
            query.append("   and (\n");
            query.append("lower(NM_CURSO) like '%" + this.filterTextorientacaoTeses + "%'");
            query.append("\n or \n");
            query.append("lower(NM_ALUNO) like '%" + this.filterTextorientacaoTeses + "%'");
            query.append("\n or \n");
            query.append("lower(DS_TESE) like '%" + this.filterTextorientacaoTeses + "%'");
            query.append("\n or \n");
            query.append("lower(DS_LOCAL) like '%" + this.filterTextorientacaoTeses + "%'");
            query.append("\n or \n");
            query.append("lower(DS_ORIENTACAO) like '%" + this.filterTextorientacaoTeses + "%'");
            query.append("\n or \n");
            query.append("lower(DS_PROVA) like '%" + this.filterTextorientacaoTeses + "%'");
            query.append("\n or \n");
            query.append("lower(DS_CLASS_ACT) like '%" + this.filterTextorientacaoTeses + "%'");
            query.append(")");
        }
        SIGESFactory.openTransaction(null);
        SQLDataSet ds = new SQLDataSet(this.siges.getSession(), query.toString(), SQLDialect.ORACLE);
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)ds);
        response.addMandatorySort(new Sort(SortMode.DESCENDING, "DS_ORIENTACAO"));
        response.addMandatorySort(new Sort(SortMode.DESCENDING, "DT_INICIO"));
        return response;
    }

    @OnAJAX(value="outrasActividadesDocente")
    public IJSONResponse getOutrasActividadesDocentes() throws UnsupportedDataSetFeature, DataSetException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        String[] fields = new String[]{OutrasActiv.FK().tableTipoActiv().CODETIPOACTIV(), OutrasActiv.FK().tableTipoActiv().DESCTIPOACTIV(), OutrasActiv.FK().tableLocalTrab().CODELOCALTRAB(), OutrasActiv.FK().tableLocalTrab().DESCLOCALTRAB(), "dateInicio", "dateFim", "descricao", "detalhes", "ligacoes"};
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSD().getOutrasActivDataSet(), fields);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)OutrasActiv.FK().tableTipoActiv(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)OutrasActiv.FK().tableLocalTrab(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter("actividadeLectiva", FilterType.EQUALS, "N"));
        response.addFilter(new Filter(OutrasActiv.FK().funcionarios().CODEFUNCIONARIO(), FilterType.EQUALS, this.codeFuncionario));
        if (StringUtils.isNotBlank((String)this.filterTextOutrasActividades)) {
            response.addFilterSet(ConditionOperator.OR).like("descricao", this.filterTextOutrasActividades).like("detalhes", this.filterTextOutrasActividades).like("ligacoes", this.filterTextOutrasActividades).like("idCategoria", this.filterTextOutrasActividades).like(OutrasActiv.FK().tableTipoActiv().DESCTIPOACTIV(), this.filterTextOutrasActividades);
        }
        response.addCalculatedField("ano", (ICalcField)new YearCalc("dateInicio"));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, OutrasActiv.FK().tableTipoActiv().DESCTIPOACTIV()));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "dateInicio"));
        return response;
    }

    @OnAJAX(value="participacaoJuriTeses")
    public IJSONResponse getParticipacaoJuris() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        String[] fields = new String[]{"id", JuriTese.FK().funcionariosByCdDocente().CODEFUNCIONARIO(), JuriTese.FK().funcionariosByCdDocente().individuo().NAMECOMPLETO(), "codeTipo", JuriTese.FK().alunos().id().CODECURSO(), JuriTese.FK().alunos().id().CODEALUNO(), "cursoExterno", "alunoExterno", JuriTese.FK().funcionariosByCdDocenteAval().CODEFUNCIONARIO(), "docenteExterno", "dateInicio", "dateFim", "descTese", JuriTese.FK().tableLocalTrab().CODELOCALTRAB(), JuriTese.FK().tableLocalTrab().DESCLOCALTRAB(), JuriTese.FK().tableFuncJuri().CODEFUNCJURI(), JuriTese.FK().tableFuncJuri().DESCFUNCJURI(), JuriTese.FK().tableProva().CODEPROVA(), JuriTese.FK().tableProva().DESCPROVA(), JuriTese.FK().tableClassAct().CODECLASSACT(), JuriTese.FK().tableClassAct().DESCCLASSACT(), "linkInfo"};
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSD().getJuriTeseDataSet(), fields);
        response.setHandleRESTActions(true, true, true, true, null);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)JuriTese.FK().funcionariosByCdDocente(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)JuriTese.FK().funcionariosByCdDocente().individuo(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)JuriTese.FK().alunos(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)JuriTese.FK().alunos().id(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)JuriTese.FK().funcionariosByCdDocenteAval(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)JuriTese.FK().tableLocalTrab(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)JuriTese.FK().tableFuncJuri(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)JuriTese.FK().tableProva(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)JuriTese.FK().tableClassAct(), JoinType.LEFT_OUTER_JOIN);
        AlunoParticipacaoJuriTeseCalcField alunoParticipacaoJuriTeseCalcField = new AlunoParticipacaoJuriTeseCalcField(this.siges);
        response.addCalculatedField("avaliado", (ICalcField)alunoParticipacaoJuriTeseCalcField);
        response.addCalculatedField("tipoCalc", (ICalcField)alunoParticipacaoJuriTeseCalcField);
        response.addFilter(new Filter(JuriTese.FK().funcionariosByCdDocente().CODEFUNCIONARIO(), FilterType.EQUALS, this.codeFuncionario));
        if (this.filterTextParticipacaoJuris != null) {
            response.addFilter(new Filter("descTese", FilterType.LIKE, this.filterTextParticipacaoJuris));
        }
        response.addMandatorySort(new Sort(SortMode.ASCENDING, JuriTese.FK().tableFuncJuri().DESCFUNCJURI()));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "dateInicio"));
        return response;
    }

    @OnAJAX(value="pautascurso")
    public IJSONResponse getPautasCurso() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeCurso)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getLND().getPautasDataSet(), new String[]{"codePauta", Pautas.FK().tablePeriodos().CODEPERIODO(), Pautas.FK().tableDiscip().CODEDISCIP(), Pautas.FK().tableDiscip().DESCDISCIP(), "codeTurma", Pautas.FK().tableEpoava().id().CODEGRUAVA(), Pautas.FK().tableEpoava().id().CODEAVALIA(), Pautas.FK().tableEpoava().DESCAVALIA(), "dateLancada"});
        response.addCalculatedField("duracao", (ICalcField)new PeriodoLectivoCalcField(Pautas.FK().tablePeriodos().CODEPERIODO()));
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Pautas.FK().tableEpoava(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Pautas.FK().tableDiscip(), JoinType.NORMAL);
        response.addFilter(new Filter(Pautas.FK().tableLectivo().CODELECTIVO(), FilterType.EQUALS, this.getNetQAUser().getAnoLectivo().getCodeLectivo()));
        response.addFilter((Filter)new FilterExtendedSQL("{discip} in (select distinct cd_discip from plandisc where cd_curso = " + this.codeCurso + " union select distinct do.cd_discip from disopcao do join plandisc pd on pd.cd_grupo = do.cd_grupo where cd_curso = " + this.codeCurso + ")", new String[]{"discip", Pautas.FK().tableDiscip().CODEDISCIP()}));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "duracao"));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, Pautas.FK().tablePeriodos().CODEPERIODO()));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "codePauta"));
        return response;
    }

    @OnAJAX(value="pautasdocente")
    public IJSONResponse getPautasDocente() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        String anoLetivo = this.getNetQAUser().getAnoLectivo().getCodeLectivo();
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getLND().getPautasDataSet(), new String[]{"codePauta", Pautas.FK().tablePeriodos().CODEPERIODO(), Pautas.FK().tableDiscip().CODEDISCIP(), Pautas.FK().tableDiscip().DESCDISCIP(), Pautas.FK().tableEpoava().id().CODEGRUAVA(), Pautas.FK().tableEpoava().id().CODEAVALIA(), Pautas.FK().tableEpoava().DESCAVALIA(), "dateLancada"});
        response.addCalculatedField("duracao", (ICalcField)new PeriodoLectivoCalcField(Pautas.FK().tablePeriodos().CODEPERIODO()));
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Pautas.FK().tableEpoava(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Pautas.FK().tableDiscip(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Pautas.FK().tablePeriodos(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Pautas.FK().funcionariosByCdDocente(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter(Pautas.FK().tableLectivo().CODELECTIVO(), FilterType.EQUALS, anoLetivo));
        response.addFilter((Filter)new FilterExtendedSQL("({docente} = " + this.codeFuncionario + " or ({duracao},{discip}) in (select cd_duracao,cd_discip from doc_turma where cd_lectivo = " + anoLetivo + " and cd_docente = " + this.codeFuncionario + "))", new String[]{"docente", Pautas.FK().funcionariosByCdDocente().CODEFUNCIONARIO(), "discip", Pautas.FK().tableDiscip().CODEDISCIP(), "duracao", Pautas.FK().tablePeriodos().CODEPERIODO()}));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "duracao"));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, Pautas.FK().tablePeriodos().CODEPERIODO()));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "codePauta"));
        return response;
    }

    @OnAJAX(value="pautasdisciplina")
    public IJSONResponse getPautasUC() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeDiscip)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getLND().getPautasDataSet(), new String[]{"codePauta", Pautas.FK().tablePeriodos().CODEPERIODO(), Pautas.FK().tableEpoava().id().CODEGRUAVA(), Pautas.FK().tableEpoava().id().CODEAVALIA(), "codeTurma", Pautas.FK().tableEpoava().DESCAVALIA(), "dateLancada"});
        response.addCalculatedField("duracao", (ICalcField)new PeriodoLectivoCalcField(Pautas.FK().tablePeriodos().CODEPERIODO()));
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Pautas.FK().tableEpoava(), JoinType.NORMAL);
        response.addFilter(new Filter(Pautas.FK().tableLectivo().CODELECTIVO(), FilterType.EQUALS, this.getNetQAUser().getAnoLectivo().getCodeLectivo()));
        response.addFilter(new Filter(Pautas.FK().tableDiscip().CODEDISCIP(), FilterType.EQUALS, this.codeDiscip));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "duracao"));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, Pautas.FK().tablePeriodos().CODEPERIODO()));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "codePauta"));
        return response;
    }

    @OnAJAX(value="premiosLouvores")
    public IJSONResponse getPremiosLouvores() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        String[] fields = new String[]{"descricao", "reconhecidoMerito", "codeTipo", "dataEntrega", "ambito", "observacoes", "idCategoria", "linkInfo"};
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSD().getPremiosDocDataSet(), fields);
        response.addFilter(new Filter(PremiosDoc.FK().funcionarios().CODEFUNCIONARIO(), FilterType.EQUALS, this.codeFuncionario));
        if (StringUtils.isNotBlank((String)this.filterTextPremiosLouvores)) {
            response.addFilterSet(ConditionOperator.OR).like("descricao", this.filterTextPremiosLouvores).like("observacoes", this.filterTextPremiosLouvores);
        }
        LinkedHashMap<String, String> tipos = new LinkedHashMap<String, String>();
        tipos.put("P", this.messages.get("premio"));
        tipos.put("M", this.messages.get("mencao"));
        tipos.put("L", this.messages.get("louvor"));
        response.addCalculatedField("descTipoCalc", (ICalcField)new Decode("codeTipo", tipos));
        LinkedHashMap<String, String> ambito = new LinkedHashMap<String, String>();
        ambito.put("N", this.messages.get("nacional"));
        ambito.put("I", this.messages.get("internacional"));
        response.addCalculatedField("descAmbitoCalc", (ICalcField)new Decode("ambito", ambito));
        LinkedHashMap<String, String> reconhecimento = new LinkedHashMap<String, String>();
        reconhecimento.put("S", this.messages.get("sim"));
        reconhecimento.put("N", this.messages.get("nao"));
        response.addCalculatedField("reconhecimentoCalc", (ICalcField)new Decode("reconhecidoMerito", reconhecimento));
        response.addCalculatedField("ano", (ICalcField)new YearCalc("dataEntrega"));
        response.addMandatorySort(new Sort(SortMode.DESCENDING, "dataEntrega"));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "descricao"));
        return response;
    }

    @OnAJAX(value="projetoscurso")
    public IJSONResponse getProjetosCurso() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeCurso)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getWEB_PROJETO().getProjetoDataSet(), new String[]{"id", "titulo", "dateInicio", "referencia", "dateFim", Projeto.FK().tableProjSituacao().DESCRICAO()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Projeto.FK().tableProjSituacao(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Projeto.FK().projParticipantes(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Projeto.FK().projParticipantes().funcionariosByCdDocente(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter(Projeto.FK().projParticipantes().alunos().id().CODECURSO(), FilterType.EQUALS, this.codeCurso));
        if (StringUtils.isNotBlank((String)this.filterTextProjetos)) {
            response.addFilterSet(ConditionOperator.OR).like("id", this.filterTextProjetos).like("titulo", this.filterTextProjetos).like("referencia", this.filterTextProjetos).like(Projeto.FK().tableProjSituacao().DESCRICAO(), this.filterTextProjetos);
        }
        response.addCalculatedField("ano", (ICalcField)new YearCalc("dateInicio"));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "ano"));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "dateInicio"));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "dateFim"));
        return response;
    }

    @OnAJAX(value="projetosdocente")
    public IJSONResponse getProjetosDocente() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getWEB_PROJETO().getProjetoDataSet(), new String[]{"id", "titulo", "dateInicio", "referencia", "dateFim", Projeto.FK().tableProjSituacao().DESCRICAO()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Projeto.FK().tableProjSituacao(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Projeto.FK().projParticipantes(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Projeto.FK().projParticipantes().funcionariosByCdDocente(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter(Projeto.FK().projParticipantes().funcionariosByCdDocente().CODEFUNCIONARIO(), FilterType.EQUALS, this.codeFuncionario));
        if (StringUtils.isNotBlank((String)this.filterTextProjetos)) {
            response.addFilterSet(ConditionOperator.OR).like("id", this.filterTextProjetos).like("titulo", this.filterTextProjetos).like("referencia", this.filterTextProjetos).like(Projeto.FK().tableProjSituacao().DESCRICAO(), this.filterTextProjetos);
        }
        response.addCalculatedField("ano", (ICalcField)new YearCalc("dateInicio"));
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "ano"));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "dateInicio"));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "dateFim"));
        return response;
    }

    @OnAJAX(value="regenciacurso")
    public IJSONResponse getRegenciaCurso() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeCurso)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSD().getRegDocenteDataSet(), new String[]{RegDocente.FK().funcionarios().CODEFUNCIONARIO(), RegDocente.FK().tableLectivo().CODELECTIVO(), RegDocente.FK().funcionarios().individuo().NAMECOMPLETO(), RegDocente.FK().cursosByCdCurso().NAMECURSO(), RegDocente.FK().tableTipoRegencia().DESCRICAO()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)RegDocente.FK().funcionarios().individuo(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)RegDocente.FK().tableTipoRegencia(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)RegDocente.FK().cursosByCdCurso(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)RegDocente.FK().tableDepart(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)RegDocente.FK().tableAreas(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter(RegDocente.FK().cursosByCdCurso().CODECURSO(), FilterType.EQUALS, this.codeCurso));
        response.addCalculatedField("letivo", (ICalcField)new AnoLectivoCalcField(RegDocente.FK().tableLectivo().CODELECTIVO()));
        response.addCalculatedField("descricaoCalc", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return null;
            }

            public String getValue(Object record, String calcFieldID) {
                RegDocente regDocente = (RegDocente)record;
                StringBuffer buffer = new StringBuffer();
                buffer.append(regDocente.getTableTipoRegencia().getDescricao());
                if (regDocente.getTableDiscip() != null) {
                    buffer.append(": [" + regDocente.getTableDiscip().getCodeDiscip() + "] " + regDocente.getTableDiscip().getDescDiscip());
                } else if (regDocente.getCursosByCdCurso() != null) {
                    buffer.append(": [" + regDocente.getCursosByCdCurso().getCodeCurso() + "] " + regDocente.getCursosByCdCurso().getNameCurso());
                } else if (regDocente.getTableDepart() != null) {
                    buffer.append(": [" + regDocente.getTableDepart().getCodeDepart() + "] " + regDocente.getTableDepart().getDescDepart());
                } else if (regDocente.getTableAreas() != null) {
                    buffer.append(": [" + regDocente.getTableAreas().getCodeArea() + "] " + regDocente.getTableAreas().getDescArea());
                }
                return buffer.toString();
            }
        });
        response.addMandatorySort(new Sort(SortMode.DESCENDING, RegDocente.FK().tableLectivo().CODELECTIVO()));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, RegDocente.FK().tableTipoRegencia().DESCRICAO()));
        return response;
    }

    @OnAJAX(value="regenciadocente")
    public IJSONResponse getRegenciaDocente() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSD().getRegDocenteDataSet(), new String[]{RegDocente.FK().funcionarios().CODEFUNCIONARIO(), RegDocente.FK().tableLectivo().CODELECTIVO(), RegDocente.FK().tableDiscip().DESCDISCIP(), RegDocente.FK().cursosByCdCurso().NAMECURSO(), RegDocente.FK().tableTipoRegencia().DESCRICAO()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)RegDocente.FK().tableTipoRegencia(), JoinType.NORMAL);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)RegDocente.FK().tableDiscip(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)RegDocente.FK().cursosByCdCurso(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)RegDocente.FK().tableAreas(), JoinType.LEFT_OUTER_JOIN);
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)RegDocente.FK().tableDepart(), JoinType.LEFT_OUTER_JOIN);
        response.addFilter(new Filter(RegDocente.FK().funcionarios().CODEFUNCIONARIO(), FilterType.EQUALS, this.codeFuncionario));
        response.addCalculatedField("letivo", (ICalcField)new AnoLectivoCalcField(RegDocente.FK().tableLectivo().CODELECTIVO()));
        response.addCalculatedField("descricaoCalc", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return null;
            }

            public String getValue(Object record, String calcFieldID) {
                RegDocente regDocente = (RegDocente)record;
                StringBuffer buffer = new StringBuffer();
                buffer.append(regDocente.getTableTipoRegencia().getDescricao());
                if (regDocente.getTableDiscip() != null) {
                    buffer.append(": [" + regDocente.getTableDiscip().getCodeDiscip() + "] " + regDocente.getTableDiscip().getDescDiscip());
                } else if (regDocente.getCursosByCdCurso() != null) {
                    buffer.append(": [" + regDocente.getCursosByCdCurso().getCodeCurso() + "] " + regDocente.getCursosByCdCurso().getNameCurso());
                } else if (regDocente.getTableDepart() != null) {
                    buffer.append(": [" + regDocente.getTableDepart().getCodeDepart() + "] " + regDocente.getTableDepart().getDescDepart());
                } else if (regDocente.getTableAreas() != null) {
                    buffer.append(": [" + regDocente.getTableAreas().getCodeArea() + "] " + regDocente.getTableAreas().getDescArea());
                }
                return buffer.toString();
            }
        });
        response.addMandatorySort(new Sort(SortMode.DESCENDING, RegDocente.FK().tableLectivo().CODELECTIVO()));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, RegDocente.FK().tableTipoRegencia().DESCRICAO()));
        return response;
    }

    @OnAJAX(value="regenciadisciplina")
    public IJSONResponse getRegenciaUC() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeDiscip)) {
            return null;
        }
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSD().getRegDocenteDataSet(), new String[]{RegDocente.FK().funcionarios().CODEFUNCIONARIO(), RegDocente.FK().tableLectivo().CODELECTIVO(), RegDocente.FK().funcionarios().individuo().NAMECOMPLETO(), RegDocente.FK().tableTipoRegencia().DESCRICAO()});
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)RegDocente.FK().funcionarios().individuo(), JoinType.NORMAL);
        response.addFilter(new Filter(RegDocente.FK().tableDiscip().CODEDISCIP(), FilterType.EQUALS, this.codeDiscip));
        response.addCalculatedField("letivo", (ICalcField)new AnoLectivoCalcField(RegDocente.FK().tableLectivo().CODELECTIVO()));
        response.addMandatorySort(new Sort(SortMode.DESCENDING, RegDocente.FK().tableLectivo().CODELECTIVO()));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, RegDocente.FK().tableDiscip().DESCDISCIP()));
        return response;
    }

    @OnAJAX(value="sumarioscurso")
    public IJSONResponse getSumariosCurso() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeCurso)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select calc.devolve_ds_periodo(d.cd_periodo) periodo,\n");
        sql.append("       s.cd_sumario id,\n");
        sql.append("       d.dt_ocupacao,\n");
        sql.append("       manu_csh.MIN_TO_HORA(s.hora_inicial) as hora_inicial,\n");
        sql.append("       d.duracao_real,\n");
        sql.append("       d.cd_turma,\n");
        sql.append("       s.titulo,\n");
        sql.append("       s.descricao,\n");
        sql.append("       s.nr_presencas,\n");
        sql.append("       d.cd_discip,\n");
        sql.append("       tbd.ds_discip,\n");
        sql.append("       d.cd_docente,\n");
        sql.append("       i.nm_completo docente,\n");
        sql.append("       st.ds_sta_sum,\n");
        sql.append("       s.bibliografia,\n");
        sql.append("       s.link_Aula\n");
        sql.append("  from sumarios_aulas s\n");
        sql.append("  join tbstasumarios st\n");
        sql.append("    on st.cd_sta_sum = s.cd_estado\n");
        sql.append("  join detalhe_aula d\n");
        sql.append("    on s.cd_sumario = d.cd_sumario\n");
        sql.append("  left outer join funcionarios f\n");
        sql.append("    on d.cd_docente = f.cd_funcionario\n");
        sql.append("  left outer join individuo i\n");
        sql.append("    on i.id_individuo = f.id_individuo\n");
        sql.append("  join tbdiscip tbd\n");
        sql.append("    on tbd.cd_discip = d.cd_discip\n");
        sql.append(" where d.cd_lectivo = '" + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "'\n");
        sql.append("   and MANU_CSD.DEVOLVE_CURSO_TURMA(d.cd_lectivo, d.cd_periodo, d.cd_discip, d.cd_turma)= " + this.codeCurso + "\n");
        if (StringUtils.isNotBlank((String)this.filterTextSumarios)) {
            this.filterTextSumarios = this.filterTextSumarios.toLowerCase();
            sql.append("   and (\n");
            sql.append("lower(tbd.ds_discip) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(d.cd_discip) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(i.nm_completo) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(d.cd_docente) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(d.cd_turma) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(s.titulo) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(s.descricao) like '%" + this.filterTextSumarios + "%'");
            sql.append(")");
        }
        SIGESFactory.openTransaction(null);
        SQLDataSet ds = new SQLDataSet(this.siges.getSession(), sql.toString(), SQLDialect.ORACLE);
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)ds);
        String[] fields = new String[]{"ID", "PERIODO", "DT_OCUPACAO", "HORA_INICIAL", "DURACAO_REAL", "CD_DISCIP", "DS_DISCIP", "CD_TURMA", "TITULO", "NR_PRESENCAS", "DS_STA_SUM", "CD_SUMARIO", "DESCRICAO", "BIBLIOGRAFIA", "LINK_AULA", "CD_DOCENTE", "DOCENTE"};
        response.setFields(fields);
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "PERIODO"));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, "cd_periodo"));
        response.addDefaultSort(new Sort(SortMode.DESCENDING, "hora_inicial"));
        return response;
    }

    @OnAJAX(value="sumariosdocente")
    public IJSONResponse getSumariosDocente() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeFuncionario)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select calc.devolve_ds_periodo(d.cd_periodo) AS PERIODO,\n");
        sql.append("       s.cd_sumario  AS ID,\n");
        sql.append("       d.dt_ocupacao AS DT_OCUPACAO,\n");
        sql.append("       manu_csh.MIN_TO_HORA(s.hora_inicial) as HORA_INICIAL,\n");
        sql.append("       d.duracao_real AS DURACAO_REAL,\n");
        sql.append("       d.cd_turma AS CD_TURMA,\n");
        sql.append("       s.titulo AS TITULO,\n");
        sql.append("       s.descricao AS DESCRICAO,\n");
        sql.append("       s.nr_presencas AS NR_PRESENCAS,\n");
        sql.append("       '['||d.cd_discip||'] '||tbd.ds_discip AS DISCIP,\n");
        sql.append("       d.cd_discip,\n");
        sql.append("       tbd.ds_discip,\n");
        sql.append("       d.cd_docente,\n");
        sql.append("       i.nm_completo docente,\n");
        sql.append("       st.ds_sta_sum AS DS_STA_SUM,\n");
        sql.append("       s.bibliografia,\n");
        sql.append("       s.link_Aula\n");
        sql.append("  from sumarios_aulas s\n");
        sql.append("  join tbstasumarios st\n");
        sql.append("    on st.cd_sta_sum = s.cd_estado\n");
        sql.append("  join detalhe_aula d\n");
        sql.append("    on s.cd_sumario = d.cd_sumario\n");
        sql.append("  join funcionarios f\n");
        sql.append("    on d.cd_docente = f.cd_funcionario\n");
        sql.append("  join individuo i\n");
        sql.append("    on i.id_individuo = f.id_individuo\n");
        sql.append("  join tbdiscip tbd\n");
        sql.append("    on tbd.cd_discip = d.cd_discip\n");
        sql.append(" where d.cd_lectivo = " + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "\n");
        sql.append("   and d.cd_docente = " + this.codeFuncionario + "\n");
        if (StringUtils.isNotBlank((String)this.filterTextSumarios)) {
            this.filterTextSumarios = this.filterTextSumarios.toLowerCase();
            sql.append("   and (\n");
            sql.append("lower(tbd.ds_discip) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(d.cd_discip) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(d.cd_turma) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(s.titulo) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(s.descricao) like '%" + this.filterTextSumarios + "%'");
            sql.append(")");
        }
        sql.append(" order by d.dt_ocupacao, s.hora_inicial\n");
        SIGESFactory.openTransaction(null);
        SQLDataSet ds = new SQLDataSet(this.siges.getSession(), sql.toString(), SQLDialect.ORACLE);
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)ds);
        String[] fields = new String[]{"ID", "PERIODO", "CD_TURMA", "DT_OCUPACAO", "HORA_INICIAL", "CD_DISCIP", "DS_DISCIP", "CD_TURMA", "TITULO", "DURACAO_REAL", "DESCRICAO", "BIBLIOGRAFIA", "LINK_AULA", "NR_PRESENCAS", "DISCIP", "CD_DOCENTE", "DOCENTE", "DS_STA_SUM"};
        response.setFields(fields);
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "PERIODO"));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, "id"));
        return response;
    }

    @OnAJAX(value="sumariosdisciplina")
    public IJSONResponse getSumariosUC() throws MissingContextException, DataSetException, RuleGroupException, SIGESException {
        if (StringUtils.isBlank((String)this.codeDiscip)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select calc.devolve_ds_periodo(d.cd_periodo) periodo,\n");
        sql.append("       s.cd_sumario id,\n");
        sql.append("       d.dt_ocupacao,\n");
        sql.append("       manu_csh.MIN_TO_HORA(s.hora_inicial) as hora_inicial,\n");
        sql.append("       d.duracao_real,\n");
        sql.append("       d.cd_turma,\n");
        sql.append("       s.titulo,\n");
        sql.append("       s.descricao,\n");
        sql.append("       s.nr_presencas,\n");
        sql.append("       d.cd_discip,\n");
        sql.append("       tbd.ds_discip,\n");
        sql.append("       d.cd_docente,\n");
        sql.append("       i.nm_completo docente,\n");
        sql.append("       st.ds_sta_sum,\n");
        sql.append("       s.bibliografia,\n");
        sql.append("       s.link_Aula\n");
        sql.append("  from sumarios_aulas s\n");
        sql.append("  join tbstasumarios st\n");
        sql.append("    on st.cd_sta_sum = s.cd_estado\n");
        sql.append("  join detalhe_aula d\n");
        sql.append("    on s.cd_sumario = d.cd_sumario\n");
        sql.append("  join funcionarios f\n");
        sql.append("    on d.cd_docente = f.cd_funcionario\n");
        sql.append("  join individuo i\n");
        sql.append("    on i.id_individuo = f.id_individuo\n");
        sql.append("  join tbdiscip tbd\n");
        sql.append("    on tbd.cd_discip = d.cd_discip\n");
        sql.append(" where d.cd_lectivo = " + this.getNetQAUser().getAnoLectivo().getCodeLectivo() + "\n");
        sql.append("   and d.cd_discip = " + this.codeDiscip + "\n");
        if (StringUtils.isNotBlank((String)this.filterTextSumarios)) {
            this.filterTextSumarios = this.filterTextSumarios.toLowerCase();
            sql.append("   and (\n");
            sql.append("lower(i.nm_completo) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(d.cd_docente) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(d.cd_turma) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(s.titulo) like '%" + this.filterTextSumarios + "%'");
            sql.append("\n or \n");
            sql.append("lower(s.descricao) like '%" + this.filterTextSumarios + "%'");
            sql.append(")");
        }
        sql.append(" order by d.dt_ocupacao, s.hora_inicial\n");
        SIGESFactory.openTransaction(null);
        SQLDataSet ds = new SQLDataSet(this.siges.getSession(), sql.toString(), SQLDialect.ORACLE);
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)ds);
        String[] fields = new String[]{"ID", "PERIODO", "DT_OCUPACAO", "HORA_INICIAL", "DURACAO_REAL", "CD_DISCIP", "DS_DISCIP", "CD_TURMA", "TITULO", "NR_PRESENCAS", "DS_STA_SUM", "CD_SUMARIO", "DESCRICAO", "BIBLIOGRAFIA", "LINK_AULA", "CD_DOCENTE", "DOCENTE"};
        response.setFields(fields);
        response.addMandatorySort(new Sort(SortMode.ASCENDING, "PERIODO"));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, "id"));
        return response;
    }
}

