/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice;

import com.google.inject.Inject;
import java.sql.SQLException;
import java.util.List;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.utils.extensions.cms.ContentItem;
import pt.digitalis.dif.utils.extensions.cms.exception.ContentManagerException;
import pt.digitalis.dif.utils.extensions.cms.exception.NoAccessException;
import pt.digitalis.dif.utils.extensions.document.IDocumentRepositoryManager;
import pt.digitalis.netqa.entities.frontoffice.InstituicaoStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractFrontOfficeStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.NetQAPagesContentHelper;
import pt.digitalis.netqa.model.InetQAService;
import pt.digitalis.netqa.model.data.UONode;
import pt.digitalis.netqa.netQAConfigurations;
import pt.digitalis.utils.config.ConfigurationException;

@StageDefinition(name="Unidades Org\u00e2nicas", service="FrontofficeService")
@View(target="netqa/frontoffice/uolist.jsp")
@Callback
public class UOListStage
extends AbstractFrontOfficeStage {
    @Inject
    protected IDocumentRepositoryManager documentRepositoryManager;
    @Inject
    protected InetQAService netQADatabaseService;

    @Execute
    public void execute() throws NoAccessException, ContentManagerException, IdentityManagerException, BusinessException, SQLException, ConfigurationException {
        if (!netQAConfigurations.getInstance().isModeNetQAPlusServer()) {
            this.context.redirectTo(InstituicaoStage.class.getSimpleName());
        } else {
            ContentItem contentItem = NetQAPagesContentHelper.getContentForInstituicao("UOList", (IDIFUser)this.context.getSession().getUser());
            this.context.addStageResult("content", (Object)contentItem);
            if (this.context.getSession().isLogged()) {
                this.context.addStageResult("contentEditable", (Object)(this.netQAUser.isAdministrator() || this.netQAUser.isBOUser() ? 1 : 0));
                this.context.addStageResult("isLogged", (Object)true);
            }
        }
    }

    public List<UONode> getUOList() throws DataSetException {
        List list = this.netQADatabaseService.getUONodeDataSet().query().equals("visible", "true").sortBy("position").sortBy("name").asList();
        for (UONode node : list) {
            if (node.getLogoDocumentId() == null) continue;
            this.documentRepositoryManager.authorizeDocumentForCurrentSession(this.context.getSession(), node.getLogoDocumentId());
        }
        return list;
    }
}

