/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.annotations.presentation.OnAJAX;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.dataset.Sort;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.model.sql.SQLDataSet;
import pt.digitalis.dif.model.sql.SQLDialect;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.presentation.ajax.IJSONResponse;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetCalendar;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetGrid;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.ICalcField;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.RuleGroupException;
import pt.digitalis.dif.utils.extensions.cms.ContentItem;
import pt.digitalis.dif.utils.extensions.cms.IContentManager;
import pt.digitalis.dif.utils.extensions.cms.exception.ContentManagerException;
import pt.digitalis.dif.utils.extensions.cms.exception.NoAccessException;
import pt.digitalis.dif.utils.extensions.document.IDocumentRepositoryManager;
import pt.digitalis.netqa.entities.frontoffice.NetQADataProviderStage;
import pt.digitalis.netqa.entities.frontoffice.UnidadesCurricularesStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractEntityPageStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.CaracteristicasUCCalc;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.HorarioAulaDesc;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.NetQAPagesContentHelper;
import pt.digitalis.netqa.rules.exceptions.NetQAException;
import pt.digitalis.siges.SIGESException;
import pt.digitalis.siges.model.data.cse.TableDiscip;
import pt.digitalis.siges.model.data.fuc.Fuc;
import pt.digitalis.siges.model.data.ruc.Ruc;
import pt.digitalis.siges.presentation.utils.SideMenuOption;
import pt.digitalis.siges.users.preferences.NetpaUserPreferencesException;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;

@StageDefinition(name="Unidade Curricular", service="FrontofficePrivateService")
@View(target="netqa/frontoffice/unidadeCurricular.jsp")
@Callback
public class UnidadeCurricularStage
extends AbstractEntityPageStage {
    @Parameter
    protected String codeDiscip;
    @Parameter
    protected String content;
    @Inject
    protected IContentManager contentManager;
    protected TableDiscip discip = null;
    @Inject
    protected IDocumentRepositoryManager documentRepositoryManager;

    @Execute
    public void execute() throws MissingContextException, DataSetException, RuleGroupException, SIGESException, NoAccessException, ContentManagerException, IdentityManagerException, NetpaUserPreferencesException, HibernateException, InternalFrameworkException, NetQAException, ConfigurationException {
        if (this.getDiscip() == null) {
            this.context.addResultMessage("warn", (String)this.stageMessages.get("acessoIndevido"), (String)this.stageMessages.get("acessoIndevidoDesc"), true, true);
            this.context.redirectTo(UnidadesCurricularesStage.class.getSimpleName());
        } else {
            Query queryFUC = this.siges.getFUC().getFucDataSet().query().equals(Fuc.FK().tableDiscip().CODEDISCIP(), this.codeDiscip).equals(Fuc.FK().tableLectivo().CODELECTIVO(), this.netQAUser.getAnoLectivo().getCodeLectivo()).equals("estado", "P").isNotNull("idDocumento").addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Fuc.FK().cursos(), JoinType.LEFT_OUTER_JOIN).sortBy(Fuc.FK().cursos().NAMECURSO());
            List fucs = queryFUC.asList();
            for (Fuc fuc : fucs) {
                this.documentRepositoryManager.authorizeDocumentForCurrentSession(this.context.getSession(), fuc.getIdDocumento());
            }
            if (fucs.size() == 1) {
                this.context.addStageResult("singleFUC", fucs.get(0));
            } else if (!fucs.isEmpty()) {
                this.context.addStageResult("listFUCs", (Object)fucs);
            }
            Query queryRUC = this.siges.getRUC().getRucDataSet().query().equals(Ruc.FK().tableDiscip().CODEDISCIP(), this.codeDiscip).equals(Ruc.FK().tableLectivo().CODELECTIVO(), this.netQAUser.getAnoLectivo().getCodeLectivo()).equals("estado", "P").isNotNull("idDocumento").addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Ruc.FK().cursos(), JoinType.LEFT_OUTER_JOIN).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Ruc.FK().tablePeriodos(), JoinType.LEFT_OUTER_JOIN).sortBy(Ruc.FK().tablePeriodos().CODEPERIODO()).sortBy(Ruc.FK().cursos().CODECURSO());
            List rucs = queryRUC.asList();
            for (Ruc ruc : rucs) {
                this.documentRepositoryManager.authorizeDocumentForCurrentSession(this.context.getSession(), ruc.getIdDocumento());
            }
            if (rucs.size() == 1) {
                this.context.addStageResult("singleRUC", rucs.get(0));
            } else if (!rucs.isEmpty()) {
                this.context.addStageResult("listRUCs", (Object)rucs);
            }
            ContentItem contentItem = NetQAPagesContentHelper.getContentForUC(this.codeDiscip, (IDIFUser)this.context.getSession().getUser());
            this.context.addStageResult("content", (Object)contentItem);
            if (this.context.getSession().isLogged()) {
                this.context.addStageResult("contentEditable", (Object)this.getNetQAUser().getUCViewingRights().isContentUnidadeCurricularEditable());
            }
        }
    }

    public SQLDataSet getAulasDataSet() throws HibernateException, IdentityManagerException, NetpaUserPreferencesException, InternalFrameworkException, SIGESException, MissingContextException, DataSetException, RuleGroupException {
        String anoLetivo = this.netQAUser.getAnoLectivo().getCodeLectivo();
        StringBuffer buf = new StringBuffer();
        buf.append("select campo_referencia||'|'||nr_aula id,\n");
        buf.append("       DATA_INICIO startDt,\n");
        buf.append("       to_char(DATA_INICIO,'YYYY-MM-DD HH24:MI:SS') startDtStr,\n");
        buf.append("       DATA_FINAL endDt,\n");
        buf.append("       to_char(DATA_FINAL,'YYYY-MM-DD HH24:MI:SS') endDtStr,\n");
        buf.append("       ' ['||CALC.DEVOLVE_DS_PERIODO(CD_PERIODO)||']<br/>'||nvl(NM_DOCENTE,'" + (String)this.stageMessages.get("semDocente") + "')||' ('||CD_TURMA||')<br/>' /*||SALA*/ \"title\",\n");
        buf.append("       SALA \"location\",\n");
        buf.append("       '<span style=''display:none;''>'||to_char(DATA_INICIO,'YYYYMM')||'</span>'||\n");
        buf.append("           to_char(DATA_INICIO,'fmMonth YYYY') as anomes,\n");
        buf.append("       v.*\n");
        buf.append(" from (\n");
        buf.append("    SELECT TRUNC(sysdate,'IW') + DIA_SEMANA-2 + (C.HORA_INICIO/60/24) DATA_INICIO,\n");
        buf.append("           TRUNC(sysdate,'IW') + DIA_SEMANA-2 + ((C.HORA_INICIO+H.DURACAO_AULA)/60/24) DATA_FINAL,\n");
        buf.append("           MANU_CSD.DEVOLVE_NM_DOCENTE(A.CD_DOCENTE) NM_DOCENTE,\n");
        buf.append("           MANU_CSH.DEVOLVE_DS_TBSALA(A.CD_SALA) SALA,\n");
        buf.append("           A.CAMPO_REFERENCIA, A.NR_AULA, C.DIA_SEMANA, C.HORA_INICIO,\n");
        buf.append("           A.CD_PERIODO, A.CD_DISCIP, A.CD_TURMA, A.CD_DOCENTE, A.CD_SALA, H.DURACAO_AULA, A.CD_COR, \n");
        buf.append("           C.CD_INSTITUICAO||C.DIA_SEMANA||C.HORA_INICIO||A.NR_AULA ID_AULA\n");
        buf.append("    FROM   VWCONFIGURACAO_HORARIO C, VWHORARIO_REFERENCIA H, VWDETALHE_HORARIO_REF A\n");
        buf.append("    WHERE  C.CAMPO_REFERENCIA = H.CAMPO_REFERENCIA\n");
        buf.append("    AND    H.CAMPO_REFERENCIA = A.CAMPO_REFERENCIA\n");
        buf.append("    AND    H.NR_AULA          = A.NR_AULA\n");
        buf.append("    AND    C.CD_LECTIVO       = '" + anoLetivo + "'\n");
        buf.append(" AND A.CD_DISCIP = " + this.codeDiscip + "\n");
        buf.append("    ORDER BY C.DIA_SEMANA, C.HORA_INICIO, A.NR_AULA, A.NR_DETALHE\n");
        buf.append(") v\n");
        this.siges.getSession().beginTransaction();
        SQLDataSet ds = new SQLDataSet(this.siges.getSession().connection(), buf.toString(), SQLDialect.ORACLE);
        ds.setIdAttribute("id");
        return ds;
    }

    @OnAJAX(value="horarioUC")
    public IJSONResponse getCalendarData() throws HibernateException, IdentityManagerException, NetpaUserPreferencesException, InternalFrameworkException, SIGESException, MissingContextException, DataSetException, RuleGroupException {
        JSONResponseDataSetCalendar response = new JSONResponseDataSetCalendar((IDataSet)this.getAulasDataSet());
        response.addCalculatedField("notes", (ICalcField)new HorarioAulaDesc(this.stageMessages));
        response.setColumnMappingForEventId("id");
        response.setColumnMappingForTitle("title");
        response.setColumnMappingForStartDate("startDtStr");
        response.setColumnMappingForEndDate("endDtStr");
        response.setColumnMappingForIsAllDay("allDay");
        response.setColumnMappingForLocation("location");
        response.setColumnMappingForNotes("notes");
        response.addDefaultSort(new Sort(SortMode.ASCENDING, "id"));
        return response;
    }

    @OnAJAX(value="caracteristicasUC")
    public IJSONResponse getCaracteristicasPorCurso() {
        StringBuffer sql = new StringBuffer();
        sql.append("select v.*, '<span class=''font120''><span class=''hide''>'||nm_curso||'</span>['||v.cd_curso||'] '||nm_curso||'</span>' nm_curso\n");
        sql.append("  from (select pd.cd_curso, cd_plano, min(cd_ramo) cd_ramo\n");
        sql.append("          from plandisc pd\n");
        sql.append("         where (pd.cd_curso, cd_plano) in\n");
        sql.append("               (select cd_curso, max(cd_plano) cd_plano\n");
        sql.append("                  from plandisc\n");
        sql.append("                 where cd_discip = " + this.codeDiscip + "\n");
        sql.append("                 group by cd_curso)\n");
        sql.append("         group by pd.cd_curso, cd_plano) v\n");
        sql.append(" join cursos c on c.cd_curso = v.cd_curso\n");
        this.siges.getSession().beginTransaction();
        SQLDataSet sqlDS = new SQLDataSet(this.siges.getSession().connection(), sql.toString(), SQLDialect.ORACLE);
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)sqlDS);
        response.addDefaultSort(new Sort(SortMode.ASCENDING, "NM_CURSO"));
        response.addCalculatedField("content", (ICalcField)new CaracteristicasUCCalc(this.stageMessages, this.codeDiscip));
        return response;
    }

    public TableDiscip getDiscip() throws DataSetException, NetpaUserPreferencesException, IdentityManagerException, MissingContextException, HibernateException, InternalFrameworkException, RuleGroupException, SIGESException, ConfigurationException {
        if (this.discip == null && StringUtils.isNotBlank((String)this.codeDiscip)) {
            Query<TableDiscip> query = null;
            query = this.getIsDocente() != false && this.isAplicarFiltroRegenciaAsListas() ? NetQADataProviderStage.getQueryUCParaDocente(this.siges, this.docenteUser.getCodeFuncionario(), this.getNetQAUser()) : this.siges.getCSE().getTableDiscipDataSet().query();
            query.equals("codeDiscip", this.codeDiscip);
            this.discip = (TableDiscip)query.singleValue();
        }
        return this.discip;
    }

    @Override
    public List<SideMenuOption> getRightNavBarLinks() {
        ArrayList<SideMenuOption> titles = new ArrayList<SideMenuOption>();
        try {
            if (this.getNetQAUser().getUCViewingRights().canViewApresentacao().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("apresentacao"), "apresentacaoAnchor"));
            }
            if (this.getNetQAUser().getUCViewingRights().canViewCaracteristicas().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("caracteristicas"), "caracteristicasAnchor"));
            }
            if (this.getNetQAUser().getUCViewingRights().canViewFUC().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("fuc"), "fucAnchor"));
            }
            if (this.getNetQAUser().getUCViewingRights().canViewRegencia().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("regencia"), "regenciaAnchor"));
            }
            if (this.getNetQAUser().getUCViewingRights().canViewDSD().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("dsd"), "dsdAnchor"));
            }
            if (this.getNetQAUser().getUCViewingRights().canViewAlunos().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("alunos"), "alunosAnchor"));
            }
            if (this.getNetQAUser().getUCViewingRights().canViewPautas().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("pautas"), "pautasAnchor"));
            }
            if (this.getNetQAUser().getUCViewingRights().canViewHorario().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("horario"), "horarioAnchor"));
            }
            if (this.getNetQAUser().getUCViewingRights().canViewSumarios().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("sumarios"), "sumariosAnchor"));
            }
            if (this.getNetQAUser().getUCViewingRights().canViewInqueritos().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("inqueritos"), "inqueritosAnchor"));
            }
            if (this.getNetQAUser().getUCViewingRights().canViewRUC().booleanValue()) {
                titles.add(new SideMenuOption((String)this.stageMessages.get("ruc"), "rucAnchor"));
            }
        }
        catch (NetQAException e) {
            e.printStackTrace();
        }
        return titles;
    }
}

