/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice;

import org.hibernate.HibernateException;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.annotations.presentation.OnAJAX;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Sort;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.presentation.ajax.IJSONResponse;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.JSONResponseDataSetGrid;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.AbstractCalcField;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.ICalcField;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.RuleGroupException;
import pt.digitalis.netqa.entities.frontoffice.InstituicaoStage;
import pt.digitalis.netqa.entities.frontoffice.NetQADataProviderStage;
import pt.digitalis.netqa.entities.frontoffice.UnidadeCurricularStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractFrontOfficeStage;
import pt.digitalis.netqa.netQAConfigurations;
import pt.digitalis.siges.SIGESException;
import pt.digitalis.siges.model.data.cse.TableDiscip;
import pt.digitalis.siges.users.preferences.NetpaUserPreferencesException;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;

@StageDefinition(name="Unidades Curriculares", service="FrontofficePrivateService")
@View(target="netqa/frontoffice/unidadesCurriculares.jsp")
@Callback
public class UnidadesCurricularesStage
extends AbstractFrontOfficeStage {
    @Parameter
    protected String discipFilter;

    @Execute
    public void execute() throws ConfigurationException {
        if (netQAConfigurations.getInstance().isModeNetQAPlusServer()) {
            this.context.redirectTo(InstituicaoStage.class.getSimpleName());
        }
    }

    @OnAJAX(value="ucs")
    public IJSONResponse getDisciplinas() throws MissingContextException, DataSetException, RuleGroupException, SIGESException, NetpaUserPreferencesException, IdentityManagerException, HibernateException, InternalFrameworkException, ConfigurationException {
        String anoLectivo = this.getNetQAUser().getAnoLectivo().getCodeLectivo();
        JSONResponseDataSetGrid response = new JSONResponseDataSetGrid((IDataSet)this.siges.getCSE().getTableDiscipDataSet());
        response.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TableDiscip.FK().turmas(), JoinType.NORMAL);
        response.addFilter(new Filter(TableDiscip.FK().turmas().id().CODELECTIVO(), FilterType.EQUALS, anoLectivo));
        response.addFilter(new Filter("activa", FilterType.EQUALS, "S"));
        response.addFilter(new Filter("codePublico", FilterType.EQUALS, "S"));
        if (this.getIsDocente().booleanValue() && this.isAplicarFiltroRegenciaAsListas()) {
            response.setQuery(NetQADataProviderStage.getQueryUCParaDocente(this.siges, this.docenteUser.getCodeFuncionario(), this.getNetQAUser()));
        }
        response.setDistinctEntities(Boolean.valueOf(true), Boolean.valueOf(false));
        response.addDefaultSort(new Sort(SortMode.ASCENDING, "descDiscip"));
        if (StringUtils.isNotBlank((String)this.discipFilter)) {
            if (StringUtils.isNumeric((String)this.discipFilter)) {
                response.addFilter(new Filter("codeDiscip", FilterType.LIKE, this.discipFilter));
            } else {
                response.addFilter(new Filter("descDiscip", FilterType.LIKE, this.discipFilter));
            }
        }
        response.addCalculatedField("content", (ICalcField)new AbstractCalcField(){

            public String getOrderByField() {
                return "descDiscip";
            }

            public String getValue(Object record, String calcFieldID) {
                TableDiscip discip = (TableDiscip)record;
                StringBuffer buffer = new StringBuffer();
                buffer.append("<div id='homelists'><dl>\n");
                buffer.append("<dt><a href='page?stage=" + UnidadeCurricularStage.class.getSimpleName() + "&codeDiscip=" + discip.getCodeDiscip() + "'>[" + discip.getCodeDiscip() + "] " + discip.getDescDiscip() + "</a></dt>\n");
                buffer.append("</dl>\n");
                return buffer.toString();
            }
        });
        return response;
    }
}

