/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice.helperclasses;

import java.util.List;
import java.util.Map;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.dem.annotations.netqa.InjectNetQAUser;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.annotations.siges.InjectDocente;
import pt.digitalis.dif.dem.annotations.siges.InjectSIGES;
import pt.digitalis.dif.dem.annotations.stage.Context;
import pt.digitalis.dif.dem.annotations.stage.Init;
import pt.digitalis.dif.dem.annotations.stage.InjectMessages;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.netqa.netQAConfigurations;
import pt.digitalis.netqa.rules.NetQAUser;
import pt.digitalis.siges.model.ISIGESInstance;
import pt.digitalis.siges.model.data.cse.TableLectivo;
import pt.digitalis.siges.users.DocenteUser;
import pt.digitalis.siges.users.preferences.NetpaUserPreferencesException;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;

public abstract class AbstractFrontOfficeStage {
    @Context
    protected IDIFContext context;
    @InjectDocente
    protected DocenteUser docenteUser;
    @InjectNetQAUser
    protected NetQAUser netQAUser;
    @Parameter
    protected String newAnoLetivo;
    @InjectSIGES
    protected ISIGESInstance siges;
    @InjectMessages
    protected Map<String, String> stageMessages;

    public Boolean getIsBackoffice() throws IdentityManagerException {
        return this.getNetQAUser().isBOUser();
    }

    public Boolean getIsDocente() throws NetpaUserPreferencesException, IdentityManagerException {
        return this.context.getSession().isLogged() && this.context.getSession().getUser().getGroupIDs().contains("docentes");
    }

    public Boolean getIsFuncionario() throws NetpaUserPreferencesException, IdentityManagerException {
        return this.context.getSession().isLogged() && this.context.getSession().getUser().getGroupIDs().contains("funcionariosAdministrativos");
    }

    public NetQAUser getNetQAUser() {
        return this.netQAUser;
    }

    public String getQueryUCDocenciaRegencia() throws Exception {
        List codes = this.docenteUser.getUCDocenciaRegencia(this.getNetQAUser().getAnoLectivo().getCodeLectivo(), null);
        if (codes.isEmpty()) {
            return "(-1)";
        }
        return "(" + CollectionUtils.listToCommaSeparatedString((List)codes) + ")";
    }

    @Init
    public void init() throws DataSetException, NetpaUserPreferencesException, BusinessException, ConfigurationException {
        TableLectivo letivo;
        if (StringUtils.isNotBlank((String)this.newAnoLetivo) && (letivo = (TableLectivo)this.siges.getCSE().getTableLectivoDataSet().get(this.newAnoLetivo)) != null) {
            this.netQAUser.setAnoLectivo(letivo);
        }
    }

    public boolean isAplicarFiltroRegenciaAsListas() throws ConfigurationException {
        return "2".equals(netQAConfigurations.getInstance().getFiltrarListasPorRegenciaModo());
    }
}

