/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice.helperclasses;

import java.util.ArrayList;
import java.util.Map;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.sql.GenericBeanAttributes;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.presentation.views.jsp.taglibs.layout.panels.grid.AbstractCalcField;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.FieldsGenerator;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.FieldsGeneratorInnerTable;
import pt.digitalis.siges.model.data.cse.Disarea;
import pt.digitalis.siges.model.data.cse.Plandisc;
import pt.digitalis.siges.model.data.cse.PlandiscAtrib;
import pt.digitalis.siges.model.impl.SIGESDirectoryImpl;
import pt.digitalis.siges.model.storedprocs.SIGESStoredProcedures;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.StringUtils;

public class CaracteristicasUCCalc
extends AbstractCalcField {
    private String codeDiscip;
    private Map<String, String> messages;

    public CaracteristicasUCCalc(Map<String, String> messages, String codeDiscip) {
        this.messages = messages;
        this.codeDiscip = codeDiscip;
    }

    public String getHorasComTipoAndFaltas(String horas, Character unidade, String limiteFaltas) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(horas);
        if (new Character('S').equals(unidade)) {
            buffer.append(" " + this.messages.get("unidadeSemana"));
        } else if (new Character('A').equals(unidade)) {
            buffer.append(" " + this.messages.get("unidadePeriodo"));
        }
        if (StringUtils.isNotBlank((String)limiteFaltas)) {
            buffer.append(" (" + this.messages.get("maxFaltas") + ": " + limiteFaltas + ")");
        }
        return buffer.toString();
    }

    public String getOrderByField() {
        return null;
    }

    public String getValue(Object record, String calcFieldID) {
        GenericBeanAttributes bean = (GenericBeanAttributes)record;
        String curso = bean.getAttributeAsString("cd_curso");
        String plano = bean.getAttributeAsString("cd_plano");
        String ramo = bean.getAttributeAsString("cd_ramo");
        try {
            SIGESDirectoryImpl siges = new SIGESDirectoryImpl(null);
            Query query = siges.getCSE().getPlandiscDataSet().query();
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Plandisc.FK().plandiscAtribs(), JoinType.NORMAL);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Plandisc.FK().ramos(), JoinType.NORMAL);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Plandisc.FK().ramos().planos(), JoinType.NORMAL);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Plandisc.FK().tableTipdis(), JoinType.NORMAL);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Plandisc.FK().tableEstruturaDiscip(), JoinType.NORMAL);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Plandisc.FK().tableDiscip(), JoinType.NORMAL);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Plandisc.FK().tableDiscip().tableDepart(), JoinType.LEFT_OUTER_JOIN);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Plandisc.FK().tableDiscip().tableInstituic(), JoinType.LEFT_OUTER_JOIN);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Plandisc.FK().disareas(), JoinType.LEFT_OUTER_JOIN);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Plandisc.FK().idiomasDic(), JoinType.LEFT_OUTER_JOIN);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Plandisc.FK().disareas().tableAreas(), JoinType.LEFT_OUTER_JOIN);
            query.equals(Plandisc.FK().id().CODECURSO(), curso);
            query.equals(Plandisc.FK().id().CODEPLANO(), plano);
            query.equals(Plandisc.FK().id().CODERAMO(), ramo);
            query.equals(Plandisc.FK().id().CODEDISCIP(), this.codeDiscip);
            Plandisc plandisc = (Plandisc)query.singleValue();
            if (plandisc == null) {
                return null;
            }
            PlandiscAtrib plandiscAtrib = (PlandiscAtrib)plandisc.getPlandiscAtribs().iterator().next();
            FieldsGenerator gen = new FieldsGenerator(this.messages.get("sim"), this.messages.get("nao"));
            gen.startLine();
            gen.addAreaTitleItem(this.messages.get("caracteristicas"), 4);
            gen.addItem(this.messages.get("plano"), "[" + plandisc.getId().getCodePlano().toString() + "] " + plandisc.getRamos().getPlanos().getNamePlano(), null, 2);
            gen.addItem(this.messages.get("ramo"), "[" + plandisc.getId().getCodeRamo().toString() + "] " + plandisc.getRamos().getNameRamo(), null, 3);
            gen.endLine();
            gen.startLine();
            gen.addItem(this.messages.get("estrutura"), plandisc.getTableEstruturaDiscip().getDescricao(), null);
            gen.addItem(this.messages.get("ciclo"), plandisc.getCiclo(), null);
            gen.addItem(this.messages.get("anoSemestre"), plandiscAtrib.getCodeASCur(), null);
            gen.addItem(this.messages.get("periodo"), SIGESStoredProcedures.getDescricaoPeriodo((String)plandisc.getCodeDurInscricao()), null);
            gen.addItem(this.messages.get("tipoDisciplina"), plandisc.getTableTipdis().getDescTipdis(), null);
            gen.endLine();
            gen.startLine();
            gen.addItem(this.messages.get("ponderacao"), plandisc.getNumberCoefici(), null);
            gen.addItem(this.messages.get("creditos"), plandisc.getNumberCredito(), null);
            gen.addItem(this.messages.get("ects"), plandisc.getNumberCreEur(), null);
            if (plandisc.getIdiomasDic() != null) {
                gen.addItem(this.messages.get("idioma"), plandisc.getIdiomasDic().getIdioma(), null);
            }
            gen.endLine();
            gen.startLine();
            if (plandisc.getTableDiscip().getTableDepart() != null) {
                gen.addItem(this.messages.get("departamento"), plandisc.getTableDiscip().getTableDepart().getDescDepart(), null);
            }
            if (plandisc.getTableDiscip().getTableInstituic() != null) {
                gen.addItem(this.messages.get("instituicao"), plandisc.getTableDiscip().getTableInstituic().getDescInstituic(), null);
            }
            if (plandisc.getNumberMaxIns() != null) {
                gen.addItem(this.messages.get("limiteInscricao"), plandisc.getNumberMaxIns(), null);
            }
            if (!plandisc.getDisareas().isEmpty()) {
                ArrayList<String> areas = new ArrayList<String>();
                for (Disarea area : plandisc.getDisareas()) {
                    areas.add(area.getTableAreas().getDescArea());
                }
                gen.addItem(this.messages.get("areas"), CollectionUtils.listToSeparatedString(areas, (String)"<br/>"), null);
            }
            if (StringUtils.isNotBlank((String)plandisc.getHomePage())) {
                String link = plandisc.getHomePage();
                if (!(link.startsWith("http://") || link.startsWith("https://") || link.startsWith("/"))) {
                    link = "http://" + link;
                }
                gen.addItem(this.messages.get("paginaDisciplina"), "<a href=\"" + link + "\">" + this.messages.get("linkDisciplina") + "</a>", null);
            }
            gen.endLine();
            gen.startLine();
            gen.addFlagField(this.messages.get("ativa"), plandisc.getCodeActiva());
            gen.addFlagField(this.messages.get("obrigatoria"), plandisc.getCodeObrigat());
            gen.addFlagField(this.messages.get("adiantada"), plandisc.getCodeAdianta());
            gen.addFlagField(this.messages.get("publico"), plandisc.getPublico());
            gen.endLine();
            gen.startLine();
            gen.addFlagField(this.messages.get("nuclear"), plandisc.getCodeNuclear());
            gen.addFlagField(this.messages.get("estagio"), plandisc.getCodeEstagio());
            gen.addFlagField(this.messages.get("projeto"), plandisc.getCodeProjecto());
            gen.addFlagField(this.messages.get("teseDissertacao"), plandisc.getTeseDissertacao());
            gen.endLine();
            gen.addAreaTitleItem(this.messages.get("cargaHoraria"), 4);
            FieldsGeneratorInnerTable horasTable = new FieldsGeneratorInnerTable(3);
            horasTable.addSeparatorTitle(this.messages.get("horasContacto"));
            horasTable.addLine(this.messages.get("cargaTeorica"), this.getHorasComTipoAndFaltas(plandisc.getHourTeorica(), plandisc.getCodeTeorica(), null), plandisc.getMaxFaltaTeorica());
            horasTable.addLine(this.messages.get("cargaTeoricaPratica"), this.getHorasComTipoAndFaltas(plandisc.getHourTeoPra(), plandisc.getCodeTeoPra(), null), plandisc.getMaxFaltaTeoPra());
            horasTable.addLine(this.messages.get("cargaPraticaLaboratorial"), this.getHorasComTipoAndFaltas(plandisc.getHourPratica(), plandisc.getCodePratica(), null), plandisc.getMaxFaltaPratica());
            horasTable.addLine(this.messages.get("cargaTrabalhoCampo"), this.getHorasComTipoAndFaltas(plandisc.getHourCampo(), plandisc.getCodeCampo(), null), plandisc.getMaxFaltaCampo());
            horasTable.addLine(this.messages.get("cargaSeminario"), this.getHorasComTipoAndFaltas(plandisc.getHourSeminar(), plandisc.getCodeSeminar(), null), plandisc.getMaxFaltaSeminario());
            horasTable.addLine(this.messages.get("cargaEstagio"), this.getHorasComTipoAndFaltas(plandisc.getHourEstagio(), plandisc.getCodeEstagio(), null), plandisc.getMaxFaltaEstagio());
            horasTable.addLine(this.messages.get("cargaOrientacaoTutoria"), this.getHorasComTipoAndFaltas(plandisc.getHourOrientacao(), plandisc.getCodeOrientacao(), null), plandisc.getMaxFaltaOrientacao());
            horasTable.addLine(this.messages.get("cargaOutra"), this.getHorasComTipoAndFaltas(plandisc.getHourOutra(), plandisc.getCodeOutra(), null), null);
            horasTable.addLine(this.messages.get("cargaLaboratorial"), this.getHorasComTipoAndFaltas(plandisc.getHourLaborat(), plandisc.getCodeLaborat(), null), plandisc.getMaxFaltaLaborat());
            horasTable.addSeparatorTitle(this.messages.get("totais"));
            horasTable.addLine(this.messages.get("horasContacto") + "<sup>1</sup>", this.getHorasComTipoAndFaltas(plandisc.getHourTotalContacto(), null, null), null);
            horasTable.addLine(this.messages.get("horasDedicadas"), this.getHorasComTipoAndFaltas(plandisc.getHourTotalDedicadas(), null, null), null);
            horasTable.addLine(this.messages.get("horasTrabalho") + "<sup>2</sup>", this.getHorasComTipoAndFaltas(plandisc.getHourTotalTrabalho(), null, null), null);
            horasTable.addLine(this.messages.get("maxFaltas"), this.getHorasComTipoAndFaltas(plandisc.getHourMaxFal(), null, null), null);
            gen.addTable(horasTable, 3);
            gen.addFootnote("1", this.messages.get("horasContactoFootnote"));
            gen.addFootnote("2", this.messages.get("horasTrabalhoFootnote"));
            return gen.getGeneratedContent();
        }
        catch (DataSetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

