/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice.helperclasses;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import pt.digitalis.dif.dataminer.definition.Area;
import pt.digitalis.dif.dataminer.definition.ChartType;
import pt.digitalis.dif.dataminer.definition.DashBoard;
import pt.digitalis.dif.dataminer.definition.DashboardManager;
import pt.digitalis.dif.dataminer.definition.Filter;
import pt.digitalis.dif.dataminer.definition.IDashboardPersistence;
import pt.digitalis.dif.dataminer.definition.IIndicator;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.presentation.views.jsp.taglibs.objects.beans.stats.IndicatorSQL;
import pt.digitalis.netqa.model.netQAFactory;
import pt.digitalis.siges.cmenet.business.session.CMEUserProfileRegenciasDeCurso;
import pt.digitalis.siges.cmenet.config.CMEnetConfiguration;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;

public class CatalogIndicadoresCurso {
    public static final String CATALOG_ID = "netQACatalogInstanceCursos";
    private static String descAnoLetivo;
    private static String filtroAluAtvCSE;
    private static String filtroAluAtvCXA;
    private static Filter filtroCurso;
    private static Filter filtroLetivo;

    private static void addIndicadores() throws SQLException, ConfigurationException {
        CMEnetConfiguration config = CMEnetConfiguration.getInstance();
        Area alunos = new Area("alunos", "Alunos");
        alunos.setDefaultGroupsToRestrict(Arrays.asList("Estatisticas,EstatisticasAdmin".split(",")));
        boolean wasActive = netQAFactory.openTransaction();
        Connection conn = netQAFactory.getSession().connection();
        conn.getMetaData().getURL();
        alunos.setDatabaseURL(config.getSiGESURL());
        alunos.setDatabaseUsername("DIF");
        alunos.setDatabasePassword("sl4743qfd6klg");
        if (!wasActive) {
            netQAFactory.getSession().getTransaction().commit();
        }
        DashboardManager.getInstance((String)CATALOG_ID).addArea(alunos);
        StringBuffer indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_naciona \"key\",\n");
        indicatorSQLBuffer.append("       ds_naciona ||' ('|| cd_naciona ||')' \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_01_01\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by cd_naciona, ds_naciona\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        String indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        IndicatorSQL indicador = new IndicatorSQL("ALU.01.01.01", "Por nacionalidade" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_01");
        indicador.setDescription("Contagem por nacionalidade dos alunos com hist\u00f3rico no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.PIE, "Total de alunos", "Total de alunos");
        indicador.setLegend(true);
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Nacionalidade");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_natural \"key\",\n");
        indicatorSQLBuffer.append("       ds_cd_natural \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_01_02\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by cd_natural, ds_natural, ds_cd_natural\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.01.02", "Por naturalidade" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_02");
        indicador.setDescription("Contagem por naturalidade (distrito quando Portugal e o pa\u00eds quando estrangeiro) dos alunos com hist\u00f3rico no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.PIE, "Total de alunos", "Total de alunos");
        indicador.setLegend(true);
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Naturalidade");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select sexo \"key\",\n");
        indicatorSQLBuffer.append("       sexo \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_01_03\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by sexo\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.01.03", "Por g\u00e9nero" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_03");
        indicador.setDescription("Contagem por g\u00e9nero dos alunos com hist\u00f3rico no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.PIE, "Total de alunos", "Total de alunos");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("G\u00e9nero");
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_sit_alu \"key\",\n");
        indicatorSQLBuffer.append("       ds_sit_alu ||' ('|| cd_sit_alu ||')' \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from  (select cd_lectivo, cd_curso, cd_aluno,\n");
        indicatorSQLBuffer.append("              max(1) cd_sit_alu, manu_cse.devolve_ds_sitalu(max(1)) ds_sit_alu\n");
        indicatorSQLBuffer.append("       from   cmenet_alu_01_01_05 where 1=1\n");
        indicatorSQLBuffer.append("       :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append("        :curso\n");
        indicatorSQLBuffer.append("       group by cd_lectivo, cd_curso, cd_aluno\n");
        indicatorSQLBuffer.append("       having (sum(decode(cd_sit_alu, 1, 1, 0)) > 0)\n");
        indicatorSQLBuffer.append("       and    (sum(decode(cd_sit_alu, 1, 0, 1)) = 0)\n");
        indicatorSQLBuffer.append("       union\n");
        indicatorSQLBuffer.append("       select cd_lectivo, cd_curso, cd_aluno, cd_sit_alu, ds_sit_alu\n");
        indicatorSQLBuffer.append("       from   cmenet_alu_01_01_05 where 1=1\n");
        indicatorSQLBuffer.append("       :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append("        :curso\n");
        indicatorSQLBuffer.append("       and    cd_sit_alu <> 1)\n");
        indicatorSQLBuffer.append("group by cd_sit_alu, ds_sit_alu\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.01.05", "Por situa\u00e7\u00e3o" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_05");
        indicador.setDescription("Contagem por situa\u00e7\u00e3o de hist\u00f3rico dos alunos com hist\u00f3rico no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.PIE, "Total de alunos", "Total de alunos");
        indicador.setLegend(true);
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Situa\u00e7\u00e3o");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_regime \"key\",\n");
        indicatorSQLBuffer.append("       ds_regime \"desc\",\n");
        indicatorSQLBuffer.append("       sum(decode(tipo_reg_estudo, 'I', 1, 0)) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(tipo_reg_estudo, 'P', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(tipo_reg_estudo, 'I', 0, 'P', 0, 1)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_01_06\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by cd_regime, ds_regime\n");
        indicatorSQLBuffer.append("order by \"value\" desc, \"value1\" desc, \"value2\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.01.06", "Por regime de frequ\u00eancia" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_06");
        indicador.setDescription("Contagem por regime de frequ\u00eancia dos alunos com hist\u00f3rico no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total tempo integral", "Total de alunos em tempo integral", "value");
        indicador.addSeries(ChartType.COLUMN, "Total tempo parcial", "Total de alunos em tempo parcial", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total outros regimes", "Total de alunos noutros regimes", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Regime de frequ\u00eancia");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select idade \"key\",\n");
        indicatorSQLBuffer.append("       idade ||' anos' \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_01_07\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by idade\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.01.07", "Por idade" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_07");
        indicador.setDescription("Contagem por idade dos alunos com hist\u00f3rico no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.PIE, "Total alunos", "Total de alunos");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Idade");
        indicador.setLimitTopRecords(Integer.valueOf(5));
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select proveniencia \"key\",\n");
        indicatorSQLBuffer.append("       proveniencia \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_01_08\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by proveniencia\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.01.08", "Por regi\u00e3o proveni\u00eancia" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_08");
        indicador.setDescription("Contagem por regi\u00e3o proveni\u00eancia dos alunos com hist\u00f3rico no ano letivo de refer\u00eancia. Considera-se como regi\u00e3o de proveni\u00eancia a localidade (distrito) da morada principal do aluno. Se o aluno estiver deslocado \u00e9 considerado a localidade (distrito) da morada secund\u00e1ria");
        indicador.addSeries(ChartType.PIE, "Total alunos", "Total de alunos");
        indicador.setLegend(true);
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Regi\u00e3o proveni\u00eancia");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_habilitacao \"key\",\n");
        indicatorSQLBuffer.append("       ds_habilitacao \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_01_09\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by ds_habilitacao\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.01.09", "Por n\u00edvel de escolaridade dos pais" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_09");
        indicador.setDescription("Contagem por n\u00edvel de escolaridade dos pais dos alunos com hist\u00f3rico no ano letivo de refer\u00eancia. O aluno \u00e9 contabilizado pelo n\u00edvel de escolaridade da m\u00e3e e pelo n\u00edvel de escolaridade do pai");
        indicador.addSeries(ChartType.BAR, "Total alunos", "Total de alunos");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("N\u00edvel escolaridade");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_sit_prof \"key\",\n");
        indicatorSQLBuffer.append("       ds_sit_prof \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_01_10\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by ds_sit_prof\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.01.10", "Por situa\u00e7\u00e3o profissional dos pais" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_10");
        indicador.setDescription("Contagem por situa\u00e7\u00e3o profissional dos pais dos alunos com hist\u00f3rico no ano letivo de refer\u00eancia. O aluno \u00e9 contabilizado pela situa\u00e7\u00e3o profissional da m\u00e3e e pela situa\u00e7\u00e3o profissional do pai");
        indicador.addSeries(ChartType.BAR, "Total alunos", "Total de alunos");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Situa\u00e7\u00e3o profissional");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_profissao \"key\",\n");
        indicatorSQLBuffer.append("       ds_profissao \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_01_11\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by ds_profissao\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.01.11", "Por profiss\u00e3o dos pais" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_11");
        indicador.setDescription("Contagem pela profiss\u00e3o dos pais dos alunos com hist\u00f3rico no ano letivo de refer\u00eancia. O aluno \u00e9 contabilizado pela profiss\u00e3o da m\u00e3e e pela profiss\u00e3o do pai");
        indicador.addSeries(ChartType.BAR, "Total alunos", "Total de alunos");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Profiss\u00e3o");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select decode(grouping(ds_area_estudo), 1, 'Total de cursos', \n");
        indicatorSQLBuffer.append("                                           ds_area_estudo) \"key\",\n");
        indicatorSQLBuffer.append("       decode(grouping(ds_area_estudo), 1, 'Total de cursos',\n");
        indicatorSQLBuffer.append("                                           ds_area_estudo) \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_01_13\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" \n");
        indicatorSQLBuffer.append("group by cube (ds_area_estudo)\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.01.13", "Por \u00e1rea de forma\u00e7\u00e3o", "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_13");
        indicador.setDescription("Contagem por \u00e1rea de forma\u00e7\u00e3o (\u00e1rea de estudos) de todos os alunos");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("\u00c1rea de forma\u00e7\u00e3o");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select cd_curso \"key\",\n");
        indicatorSQLBuffer.append("       nm_curso ||' ('|| cd_curso ||')' \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_01_14\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by cd_curso, nm_curso, nm_cur_abr\n");
        indicatorSQLBuffer.append("order by \"value\" desc, \"value1\" desc, \"value2\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.01.14", "Por curso", "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_14");
        indicador.setDescription("Contagem por curso de todos os alunos");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Curso");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_profissao \"key\",\n");
        indicatorSQLBuffer.append("       ds_profissao \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_01_11\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by ds_profissao\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.01.11", "Por profiss\u00e3o dos pais" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_01_11");
        indicador.setDescription("Contagem pela profiss\u00e3o dos pais dos alunos com hist\u00f3rico no ano letivo de refer\u00eancia. O aluno \u00e9 contabilizado pela profiss\u00e3o da m\u00e3e e pela profiss\u00e3o do pai");
        indicador.addSeries(ChartType.BAR, "Total alunos", "Total de alunos");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Profiss\u00e3o");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Total de alunos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select cd_curso \"key\",\n");
        indicatorSQLBuffer.append("       nm_curso ||' ('|| cd_curso ||')' \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(tipo_reg_estudo, 'I', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(tipo_reg_estudo, 'P', 1, 0)) \"value2\",\n");
        indicatorSQLBuffer.append("       sum(decode(tipo_reg_estudo, 'I', 0, 'P', 0, 1)) \"value3\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_01_02_01\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by cd_curso, nm_curso\n");
        indicatorSQLBuffer.append("order by \"value\" desc, \"value1\" desc, \"value2\" desc, \"value3\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.01.02.01", "Por regime de estudo" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_01_02_01");
        indicador.setDescription("Contagem por regime de estudo dos alunos com hist\u00f3rico no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total", "Total", "value");
        indicador.addSeries(ChartType.COLUMN, "Total tempo integral", "Total de alunos em tempo integral", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total tempo parcial", "Total de alunos em tempo parcial", "value2");
        indicador.addSeries(ChartType.COLUMN, "Total outros regimes", "Total de alunos noutros regimes", "value3");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Regime estudo");
        indicador.setLegend(true);
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setGroupTitle("Caracteriza\u00e7\u00e3o|Cursos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select cd_curso \"key\",\n");
        indicatorSQLBuffer.append("       nm_curso ||' ('|| cd_curso ||')' \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_02_01_03\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by cd_curso, nm_curso, nm_cur_abr\n");
        indicatorSQLBuffer.append("order by \"value\" desc, \"value1\" desc, \"value2\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.02.01.03", "Por curso" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_02_01_03");
        indicador.setDescription("Contagem por curso de todos os alunos inscritos com hist\u00f3rico no ano lectivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Curso");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Inscritos|Total de inscritos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_ingresso \"key\",\n");
        indicatorSQLBuffer.append("       ds_ingresso \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_02_01_04\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by ds_ingresso\n");
        indicatorSQLBuffer.append("order by \"value\" desc, \"value1\" desc, \"value2\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.02.01.04", "Por regime de ingresso" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_02_01_04");
        indicador.setDescription("Contagem por regime de ingresso (forma de ingresso ativa da ficha do aluno) de todos os alunos inscritos com hist\u00f3rico no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Regime de ingresso");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Inscritos|Total de inscritos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select cd_discip \"key\",\n");
        indicatorSQLBuffer.append("       ds_discip ||' ('|| cd_discip ||')' \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_02_01_05\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :periodo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by cd_discip, ds_discip\n");
        indicatorSQLBuffer.append("order by \"value\" desc, \"value1\" desc, \"value2\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.02.01.05", "Por unidade curricular" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_02_01_05");
        indicador.setDescription("Contagem por unidade curricular dos alunos inscritos no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.LINE, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.LINE, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.LINE, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Unidade curricular");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Inscritos|Total de inscritos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select cd_a_s_cur \"key\",\n");
        indicatorSQLBuffer.append("       cd_a_s_cur \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_02_01_06\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by cd_a_s_cur\n");
        indicatorSQLBuffer.append("order by \"key\"\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.02.01.06", "Por ano curricular" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_02_01_06");
        indicador.setDescription("Contagem por ano curricular de todos os alunos inscritos com hist\u00f3rico no ano lectivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Ano curricular");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Inscritos|Total de inscritos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_area \"key\",\n");
        indicatorSQLBuffer.append("       ds_area \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_02_01_07\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :periodo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by ds_area\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.02.01.07", "Por \u00e1rea cient\u00edfica da unidade curricular" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_02_01_07");
        indicador.setDescription("Contagem por \u00e1rea cient\u00edfica da unidade curricular de todos os alunos inscritos com hist\u00f3rico no ano lectivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("\u00c1rea cient\u00edfica");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Inscritos|Total de inscritos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_instituic \"key\",\n");
        indicatorSQLBuffer.append("       ds_instituic \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_02_01_08\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by ds_instituic\n");
        indicatorSQLBuffer.append("order by \"key\"\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.02.01.08", "Por unidade org\u00e2nica" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_02_01_08");
        indicador.setDescription("Contagem por unidade org\u00e2nica de todos os alunos inscritos com hist\u00f3rico no ano lectivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Unidade org\u00e2nica");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Inscritos|Total de inscritos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_depart \"key\",\n");
        indicatorSQLBuffer.append("       ds_depart \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_02_01_09\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso :instituic\n");
        indicatorSQLBuffer.append("group by ds_depart\n");
        indicatorSQLBuffer.append("order by \"key\"\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.02.01.09", "Por departamento" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_02_01_09");
        indicador.setDescription("Contagem por departamento de curso de todos os alunos inscritos com hist\u00f3rico no ano lectivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Departamento");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Inscritos|Total de inscritos");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select decode(grouping(ds_area_estudo), 1, 'Total de cursos', \n");
        indicatorSQLBuffer.append("                                           ds_area_estudo) \"key\",\n");
        indicatorSQLBuffer.append("       decode(grouping(ds_area_estudo), 1, 'Total de cursos',\n");
        indicatorSQLBuffer.append("                                           ds_area_estudo) \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_02_02_02\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by cube (ds_area_estudo)\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.02.02.02", "Por \u00e1rea de forma\u00e7\u00e3o" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_02_02_02");
        indicador.setDescription("Contagem por \u00e1rea de forma\u00e7\u00e3o (\u00e1rea de estudos) de todos os alunos inscritos no curso no 1\u00ba ano 1\u00aa vez com hist\u00f3rico no ano lectivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("\u00c1rea de forma\u00e7\u00e3o");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Inscritos|Total de inscritos 1\u00ba ano 1\u00aa vez");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select nvl(nm_cur_abr, cd_curso) \"key\",\n");
        indicatorSQLBuffer.append("       nm_curso ||' ('|| cd_curso ||')' \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_02_02_03\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by cd_curso, nm_curso, nm_cur_abr\n");
        indicatorSQLBuffer.append("order by \"value\" desc, \"value1\" desc, \"value2\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.02.02.03", "Por curso" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_02_02_03");
        indicador.setDescription("Contagem por curso de todos os alunos inscritos no curso no 1\u00ba ano 1\u00aa vez com hist\u00f3rico no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Curso");
        indicador.setLimitTopRecords(Integer.valueOf(5));
        indicador.setLegend(true);
        indicador.setGroupTitle("Inscritos|Total de inscritos 1\u00ba ano 1\u00aa vez");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select cd_ingresso \"key\",\n");
        indicatorSQLBuffer.append("       ds_ingresso ||' ('|| cd_ingresso ||')' \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_02_02_04\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by cd_ingresso, ds_ingresso\n");
        indicatorSQLBuffer.append("order by \"value\" desc, \"value1\" desc, \"value2\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.02.02.04", "Por regime de ingresso" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_02_02_04");
        indicador.setDescription("Contagem por regime de ingresso (forma de ingresso ativa da ficha do aluno) de todos os alunos inscritos no curso no 1\u00ba ano 1\u00aa vez com hist\u00f3rico no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Regime de ingresso");
        indicador.setLimitTopRecords(Integer.valueOf(5));
        indicador.setLegend(true);
        indicador.setGroupTitle("Inscritos|Total de inscritos 1\u00ba ano 1\u00aa vez");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_instituic \"key\",\n");
        indicatorSQLBuffer.append("       ds_instituic \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_02_02_05\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by ds_instituic\n");
        indicatorSQLBuffer.append("order by \"key\"\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.02.02.05", "Por unidade org\u00e2nica" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_02_02_05");
        indicador.setDescription("Contagem por unidade org\u00e2nica de todos os alunos inscritos no curso no 1\u00ba ano 1\u00aa vez com hist\u00f3rico no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Unidade org\u00e2nica");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Inscritos|Total de inscritos 1\u00ba ano 1\u00aa vez");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_depart \"key\",\n");
        indicatorSQLBuffer.append("       ds_depart \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'M', 1, 0)) \"value1\",\n");
        indicatorSQLBuffer.append("       sum(decode(sexo, 'F', 1, 0)) \"value2\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_02_02_06\n");
        indicatorSQLBuffer.append("where 1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append(" :curso\n");
        indicatorSQLBuffer.append("group by ds_depart\n");
        indicatorSQLBuffer.append("order by \"key\"\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.02.02.06", "Por departamento" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_02_02_06");
        indicador.setDescription("Contagem por departamento de curso de todos os alunos inscritos no curso no 1\u00ba ano 1\u00aa vez com hist\u00f3rico no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.COLUMN, "Total de alunos", "Total de alunos", "value");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero masculino", "Total de alunos g\u00e9nero masculino", "value1");
        indicador.addSeries(ChartType.COLUMN, "Total g\u00e9nero feminino", "Total de alunos g\u00e9nero feminino", "value2");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Departamento");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Inscritos|Total de inscritos 1\u00ba ano 1\u00aa vez");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select deslocado \"key\",\n");
        indicatorSQLBuffer.append("       deslocado \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_03_04\n");
        indicatorSQLBuffer.append("where  1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append("        :curso\n");
        indicatorSQLBuffer.append("group by deslocado\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.03.04", "R\u00e1cio de alunos deslocados da resid\u00eancia permanente" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_03_04");
        indicador.setDescription("R\u00e1cio entre alunos deslocados da resid\u00eancia permanente e os alunos que n\u00e3o est\u00e3o deslocados da resid\u00eancia permanente. Considera alunos com hist\u00f3rico no ano letivo de refer\u00eancia. A valida\u00e7\u00e3o se o aluno est\u00e1 deslocado da sua resid\u00eancia permanente \u00e9 feita atrav\u00e9s do campo \"Deslocado da resid\u00eancia permanente\"");
        indicador.addSeries(ChartType.PIE, "Total alunos", "Total de alunos deslocados da resid\u00eancia permanente");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Deslocado");
        indicador.setGroupTitle("R\u00e1cios");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_residencia \"key\",\n");
        indicatorSQLBuffer.append("       ds_residencia \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from ( select decode(cd_pais_morada, 1,\n");
        indicatorSQLBuffer.append("                     'Em Portugal',\n");
        indicatorSQLBuffer.append("                     'No estrangeiro') ds_residencia\n");
        indicatorSQLBuffer.append("       from   cmenet_alu_03_05\n");
        indicatorSQLBuffer.append("       where  1=1 :letivo :alu_atv_cse :alu_atv_cxa\n");
        indicatorSQLBuffer.append("        :curso )\n");
        indicatorSQLBuffer.append("group by ds_residencia\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicatorSQL = indicatorSQL.replace(":alu_atv_cse", filtroAluAtvCSE);
        indicatorSQL = indicatorSQL.replace(":alu_atv_cxa", filtroAluAtvCXA);
        indicador = new IndicatorSQL("ALU.03.05", "R\u00e1cio de alunos cuja resid\u00eancia permanente \u00e9 no estrangeiro" + descAnoLetivo, "CSE", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_03_05");
        indicador.setDescription("R\u00e1cio entre alunos com resid\u00eancia no estrangeiro e os alunos que t\u00eam resid\u00eancia em Portugal. Considera alunos com hist\u00f3rico no ano letivo de refer\u00eancia. A valida\u00e7\u00e3o da resid\u00eancia \u00e9 feita atrav\u00e9s do pa\u00eds da morada principal");
        indicador.addSeries(ChartType.PIE, "Total de alunos", "Total de alunos");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Alunos");
        indicador.setDescriptionTitle("Resid\u00eancia");
        indicador.setGroupTitle("R\u00e1cios");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select replace(manu_sia_optico.devolve_estado_matricula(estado),\n");
        indicatorSQLBuffer.append("               ' ', '\n') \"key\",\n");
        indicatorSQLBuffer.append("       replace(manu_sia_optico.devolve_estado_matricula(estado),\n");
        indicatorSQLBuffer.append("               ' ', '\n') \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_05_01_01\n");
        indicatorSQLBuffer.append("where 1=1 :letivo  :curso\n");
        indicatorSQLBuffer.append("group by estado\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicador = new IndicatorSQL("ALU.05.01.01", "Por estado" + descAnoLetivo, "CSE,SIAnet", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_05_01_01");
        indicador.setDescription("Contagem por estado das inscri\u00e7\u00f5es on-line realizadas no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.PIE, "Total de inscri\u00e7\u00f5es", "Total de inscri\u00e7\u00f5es");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Inscri\u00e7\u00f5es");
        indicador.setDescriptionTitle("Estado");
        indicador.setGroupTitle("Monitoriza\u00e7\u00e3o|Inscri\u00e7\u00f5es on-line");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select to_char(dt_matricula, 'dd-mm-yyyy') \"key\",\n");
        indicatorSQLBuffer.append("       to_char(dt_matricula, 'dd-mm-yyyy') \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_05_01_02\n");
        indicatorSQLBuffer.append("where 1=1 :letivo  :curso\n");
        indicatorSQLBuffer.append("group by dt_matricula\n");
        indicatorSQLBuffer.append("order by dt_matricula asc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicador = new IndicatorSQL("ALU.05.01.02", "Por dia" + descAnoLetivo, "CSE,SIAnet", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_05_01_02");
        indicador.setDescription("Contagem por dia das inscri\u00e7\u00f5es on-line realizadas no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.LINE, "Total de inscri\u00e7\u00f5es", "Total de inscri\u00e7\u00f5es");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Inscri\u00e7\u00f5es");
        indicador.setDescriptionTitle("Dia");
        indicador.setLimitTopRecords(Integer.valueOf(365));
        indicador.setGroupTitle("Monitoriza\u00e7\u00e3o|Inscri\u00e7\u00f5es on-line");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select to_char(dt_estado, 'dd-mm-yyyy') ||'\n'||\n");
        indicatorSQLBuffer.append("       replace(manu_sia_optico.devolve_estado_matricula(estado),\n");
        indicatorSQLBuffer.append("               ' ', '\n') \"key\",\n");
        indicatorSQLBuffer.append("       to_char(dt_estado, 'dd-mm-yyyy') ||'\n'||\n");
        indicatorSQLBuffer.append("       replace(manu_sia_optico.devolve_estado_matricula(estado),\n");
        indicatorSQLBuffer.append("               ' ', '\n') \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_05_01_03\n");
        indicatorSQLBuffer.append("where 1=1 :letivo  :curso\n");
        indicatorSQLBuffer.append("group by dt_estado, estado\n");
        indicatorSQLBuffer.append("order by dt_estado asc, estado\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicador = new IndicatorSQL("ALU.05.01.03", "Por dia / estado" + descAnoLetivo, "CSE,SIAnet", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_05_01_03");
        indicador.setDescription("Contagem por dia / estado das inscri\u00e7\u00f5es on-line realizadas no ano letivo de refer\u00eancia");
        indicador.addSeries(ChartType.LINE, "Total de inscri\u00e7\u00f5es", "Total de inscri\u00e7\u00f5es");
        indicador.addFilter(filtroLetivo);
        indicador.addFilter(filtroCurso);
        indicador.setyAxisTitle("Inscri\u00e7\u00f5es");
        indicador.setDescriptionTitle("Dia / estado");
        indicador.setLimitTopRecords(Integer.valueOf(365));
        indicador.setGroupTitle("Monitoriza\u00e7\u00e3o|Inscri\u00e7\u00f5es on-line");
        alunos.addIndicator((IIndicator)indicador);
        indicatorSQLBuffer = new StringBuffer();
        indicatorSQLBuffer.append("select ds_estado \"key\",\n");
        indicatorSQLBuffer.append("       ds_estado ||' ('|| cd_estado ||')' \"desc\",\n");
        indicatorSQLBuffer.append("       count(*) \"value\"\n");
        indicatorSQLBuffer.append("from   cmenet_alu_05_02_01\n");
        indicatorSQLBuffer.append("group by cd_estado, ds_estado\n");
        indicatorSQLBuffer.append("order by \"value\" desc\n");
        indicatorSQL = indicatorSQLBuffer.toString();
        indicador = new IndicatorSQL("ALU.05.02.01", "Por estado", "CSE,CXAnet,DOCUMENTOSnet", indicatorSQL);
        indicador.setMaterializedViews("cme.cmenet_alu_05_02_01");
        indicador.setDescription("Contagem por estado das requisi\u00e7\u00f5es de documentos realizadas");
        indicador.addSeries(ChartType.PIE, "Total de requisi\u00e7\u00f5es", "Total de requisi\u00e7\u00f5es");
        indicador.setyAxisTitle("Documentos");
        indicador.setDescriptionTitle("Estado");
        indicador.setLimitTopRecords(Integer.valueOf(10));
        indicador.setLegend(true);
        indicador.setGroupTitle("Monitoriza\u00e7\u00e3o|Requisi\u00e7\u00e3o de documentos");
        alunos.addIndicator((IIndicator)indicador);
        DashBoard dashAlunos = new DashBoard("alunos", "ALU_DASH_01", "Alunos", "horizontal");
        dashAlunos.setIndicatorList("ALU.02.01.03;ALU.01.01.03,ALU.02.02.04");
        alunos.addDashBoard(dashAlunos);
    }

    private static void defineFilters() throws ConfigurationException {
        CMEnetConfiguration config = CMEnetConfiguration.getInstance();
        String periodos = config.getPeriodos();
        if (StringUtils.isNotEmpty((String)periodos)) {
            periodos = periodos.replaceAll(",", "','");
        }
        filtroLetivo = new Filter("letivo", "Ano letivo", "Todos os anos letivos da institui\u00e7\u00e3o", "cd_lectivo = ':value'", "select cd_lectivo id, calc.lect_formatado(cd_lectivo) value from tblectivo order by cd_lectivo desc", config.getAnoLectivo());
        filtroCurso = new Filter("curso", "Curso", "Todos os cursos da institui\u00e7\u00e3o", "cd_curso = :value", "select cd_curso id, nm_curso value from cursos order by nm_curso").setBindToProfileID(CMEUserProfileRegenciasDeCurso.class.getSimpleName());
        filtroAluAtvCSE = config.getFiltraApenasAlunosActivosCSE() != false ? " and ( cd_act_cse = 'S' or cd_act_cse is null )" : "";
        filtroAluAtvCXA = config.getFiltraApenasAlunosActivosCXA() != false ? " and ( cd_act_cxa = 'S' or cd_act_cxa is null )" : "";
        descAnoLetivo = "|ano letivo " + config.getAnoLectivoFormatado();
    }

    public static void registerDashboards() throws BusinessException, SQLException, ConfigurationException {
        CatalogIndicadoresCurso.defineFilters();
        CatalogIndicadoresCurso.addIndicadores();
        ((IDashboardPersistence)DIFIoCRegistry.getRegistry().getImplementation(IDashboardPersistence.class)).loadConfigurations(DashboardManager.getInstance((String)CATALOG_ID));
    }

    static {
        filtroAluAtvCSE = "";
        filtroAluAtvCXA = "";
    }
}

