/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice.helperclasses;

import java.util.ArrayList;
import java.util.List;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.FieldsGeneratorInnerTable;
import pt.digitalis.utils.common.StringUtils;

public class FieldsGenerator {
    private StringBuffer buf = new StringBuffer();
    private String flagOFFRepresentation;
    private String flagONRepresentation;
    private List<String> footnotes = new ArrayList<String>();

    public FieldsGenerator(String flagONRepresentation, String flagOFFRepresentation) {
        this.flagONRepresentation = flagONRepresentation;
        this.flagOFFRepresentation = flagOFFRepresentation;
    }

    public void addAreaTitleItem(String title) {
        this.addAreaTitleItem(title, 1);
    }

    public void addAreaTitleItem(String title, Integer colSpan) {
        this.endLine();
        this.buf.append("<td colspan=\"" + colSpan + "\"><h4>" + title + "<h4></td>\n");
        this.startLine();
    }

    public void addFlagField(String label, Character value) {
        this.addFlagField(label, StringUtils.toStringOrNull((Object)value));
    }

    public void addFlagField(String label, String value) {
        this.addItem(label, "S".equals(value) ? this.flagONRepresentation : this.flagOFFRepresentation, null);
    }

    public void addFootnote(String footnote) {
        this.footnotes.add(footnote);
    }

    public void addFootnote(String index, String footnote) {
        this.footnotes.add("<sup>" + index + "</sup>" + footnote);
    }

    public void addItem(String label, Object value, Object nullValue) {
        this.addItem(label, value, nullValue, 1);
    }

    public void addItem(String label, Object value, Object nullValue, Integer colSpan) {
        this.buf.append("<td colspan=\"" + colSpan + "\"><dl><dt class=\"themecolor01\">" + label + ":</dt><dd>" + StringUtils.nvl((String)StringUtils.toStringOrNull((Object)value), (String)StringUtils.nvl((String)StringUtils.toStringOrNull((Object)nullValue), (String)"")) + "</dd></dl></td>\n");
    }

    public void addTable(FieldsGeneratorInnerTable horasTable, Integer colSpan) {
        this.endLine();
        this.buf.append("<td colspan=\"" + colSpan + "\">" + horasTable.getGeneratedContent() + "</td>\n");
        this.startLine();
    }

    public void endLine() {
        this.buf.append("</tr>");
    }

    public String getGeneratedContent() {
        StringBuffer result = new StringBuffer();
        result.append("<table width=\"100%\" class=\"detaillist\" style=\"max-width:800px;\" class=\"borderNone\"><tbody>\n");
        result.append(this.buf.toString());
        result.append("</tbody></table>\n");
        if (!this.footnotes.isEmpty()) {
            result.append("<div class=\"footnote\"><ul>\n");
            for (String footnote : this.footnotes) {
                result.append("<li><sup>1</sup>" + footnote + "</li>");
            }
            result.append("</ul></div>\n");
        }
        return result.toString();
    }

    public void startLine() {
        this.buf.append("<tr>");
    }
}

