/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice.helperclasses;

import java.util.ArrayList;
import java.util.List;

public class NetQADashboardDefinition {
    private List<Line> lines = new ArrayList<Line>();

    public void addIndicator(int lineIndex, String areaID, String indicatorID, String title) {
        while (lineIndex > this.lines.size()) {
            this.lines.add(new Line(this.lines.size() + 1));
        }
        this.lines.get(lineIndex - 1).addIndicator(areaID, indicatorID, title);
    }

    public Integer getLineCount() {
        return this.lines.size();
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public class Line {
        private List<Indicator> indicators = new ArrayList<Indicator>();
        private Integer lineNumber;

        public Line(Integer lineNumber) {
            this.lineNumber = lineNumber;
        }

        public void addIndicator(String areaID, String indicatorID, String title) {
            Indicator indicator = new Indicator(areaID, indicatorID, title);
            indicator.setIsfirstInLine(this.indicators.isEmpty());
            this.indicators.add(indicator);
        }

        public int getIndicatorCount() {
            return this.indicators.size();
        }

        public List<Indicator> getIndicators() {
            return this.indicators;
        }

        public Integer getLineNumber() {
            return this.lineNumber;
        }
    }

    public class Indicator {
        private String areaID;
        private String indicatorID;
        private Boolean isfirstInLine = false;
        private String title;

        public Indicator(String areaID, String indicatorID, String title) {
            this.areaID = areaID;
            this.indicatorID = indicatorID;
            this.title = title;
        }

        public String getAreaID() {
            return this.areaID;
        }

        public String getId() {
            return this.areaID.replace(".", "") + "_" + this.indicatorID.replace(".", "");
        }

        public String getIndicatorID() {
            return this.indicatorID;
        }

        public Boolean getIsfirstInLine() {
            return this.isfirstInLine;
        }

        public String getTitle() {
            return this.title;
        }

        public void setIsfirstInLine(Boolean isfirstInLine) {
            this.isfirstInLine = isfirstInLine;
        }
    }
}

