/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.frontoffice.helperclasses;

import java.util.List;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.utils.extensions.cms.ContentItem;
import pt.digitalis.dif.utils.extensions.cms.IContentManager;
import pt.digitalis.dif.utils.extensions.cms.Node;
import pt.digitalis.dif.utils.extensions.cms.exception.ContentItemNotFoundException;
import pt.digitalis.dif.utils.extensions.cms.exception.ContentManagerException;
import pt.digitalis.dif.utils.extensions.cms.exception.NoAccessException;
import pt.digitalis.dif.utils.extensions.cms.exception.NodeNotFoundException;

public class NetQAPagesContentHelper {
    private static final String CONTENT_ID_GENERIC = "netQA_Generic";
    private static final String CONTENT_ID_PREFIX_CURSO = "netQA_Curso_Main";
    private static final String CONTENT_ID_PREFIX_DOCENTE = "netQA_Docente_Main";
    private static final String CONTENT_ID_PREFIX_INSTITUICAO = "netQA_Instituicao_Main";
    private static final String CONTENT_ID_PREFIX_UC = "netQA_UC_Main";
    private static IContentManager contentManager = (IContentManager)DIFIoCRegistry.getRegistry().getImplementation(IContentManager.class);

    private static ContentItem getContent(String parentNodeID, String contentID, IDIFUser user) throws ContentManagerException {
        ContentItem content = null;
        try {
            List contents = contentManager.getContentByName(contentID, user);
            if (contents != null && !contents.isEmpty()) {
                content = (ContentItem)contents.get(0);
            }
        }
        catch (ContentItemNotFoundException e) {
        }
        catch (NodeNotFoundException e) {
            // empty catch block
        }
        if (content == null && user != null) {
            List nodes = contentManager.getNodesByName(parentNodeID, user);
            Node parentNode = null;
            if (nodes.isEmpty()) {
                parentNode = new Node(null, parentNodeID, null, user);
                parentNode.setPublic(true);
                parentNode = contentManager.addNode(parentNode);
            } else {
                parentNode = (Node)nodes.get(0);
            }
            content = new ContentItem(parentNode.getId(), contentID, null, user);
            content.setContent("");
            content = contentManager.addContent(content);
        }
        return content;
    }

    public static ContentItem getContentForCurso(String codeCurso, IDIFUser user) throws NoAccessException, ContentManagerException {
        return NetQAPagesContentHelper.getContent(CONTENT_ID_PREFIX_CURSO, NetQAPagesContentHelper.getContentNodeIDForCurso(codeCurso), user);
    }

    public static ContentItem getContentForDocente(String codeDocente, IDIFUser user) throws NoAccessException, ContentManagerException {
        return NetQAPagesContentHelper.getContent(CONTENT_ID_PREFIX_DOCENTE, NetQAPagesContentHelper.getContentNodeIDForDocente(codeDocente), user);
    }

    public static ContentItem getContentForInstituicao(String codeInstituicao, IDIFUser user) throws NoAccessException, ContentManagerException {
        return NetQAPagesContentHelper.getContent(CONTENT_ID_PREFIX_INSTITUICAO, NetQAPagesContentHelper.getContentNodeIDForInstituicao(codeInstituicao), user);
    }

    public static ContentItem getContentForUC(String codeDiscip, IDIFUser user) throws NoAccessException, ContentManagerException {
        return NetQAPagesContentHelper.getContent(CONTENT_ID_PREFIX_UC, NetQAPagesContentHelper.getContentNodeIDForUC(codeDiscip), user);
    }

    private static String getContentNodeIDForCurso(String codeCurso) {
        return "netQA_Curso_Main_" + codeCurso;
    }

    private static String getContentNodeIDForDocente(String codeDocente) {
        return "netQA_Docente_Main_" + codeDocente;
    }

    private static String getContentNodeIDForInstituicao(String codeInstituicao) {
        return "netQA_Instituicao_Main_" + codeInstituicao;
    }

    private static String getContentNodeIDForUC(String codeDiscip) {
        return "netQA_UC_Main_" + codeDiscip;
    }

    public static ContentItem getGenericContent(String contentBusinessID, IDIFUser user) throws NoAccessException, ContentManagerException {
        return NetQAPagesContentHelper.getContent(CONTENT_ID_GENERIC, contentBusinessID, user);
    }
}

