/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.home;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.controller.interfaces.IDIFResponse;
import pt.digitalis.dif.dataminer.session.IDDMUserProfile;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.netqa.InjectNetQAUser;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.dem.annotations.stage.controller.DispatcherMode;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.presentation.entities.system.home.RightNavBar;
import pt.digitalis.dif.presentation.views.jsp.taglibs.TagLibUtils;
import pt.digitalis.netqa.entities.frontoffice.CursoStage;
import pt.digitalis.netqa.entities.frontoffice.UnidadeCurricularStage;
import pt.digitalis.netqa.model.InetQAService;
import pt.digitalis.netqa.model.data.UONode;
import pt.digitalis.netqa.rules.NetQAUser;
import pt.digitalis.netqa.rules.NetQAUtils;
import pt.digitalis.siges.cmenet.business.session.AbstractSiGESDDMUserProfile;
import pt.digitalis.siges.cmenet.business.session.CMEUserProfileCargoGestao;
import pt.digitalis.siges.cmenet.business.session.CMEUserProfileRegenciasDeCurso;
import pt.digitalis.siges.cmenet.business.session.CMEUserProfileRegenciasDeUnidadeCurricular;
import pt.digitalis.siges.presentation.utils.SideMenuOption;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.common.collections.CaseInsentiveArrayList;

@StageDefinition(id="customdifrightnavbar", name="Right Navigation Bar", service="difhomeservice", overrideDefault="difrightnavbar")
@View(target="internal/rightnavbar.jsp", defaultView=true)
@DispatcherMode(authenticate=false, authorize=false)
public class CustomRightNavBar
extends RightNavBar {
    @Inject
    protected InetQAService netQADatabaseService;
    @InjectNetQAUser
    protected NetQAUser netQAUser;

    @Execute
    public void execute() {
        ArrayList<String> cargos = new ArrayList<String>();
        ArrayList<String> cursos = new ArrayList<String>();
        ArrayList<String> ucs = new ArrayList<String>();
        for (IDDMUserProfile profile : this.getNetQAUser().getProfiles()) {
            if (!(profile instanceof AbstractSiGESDDMUserProfile)) continue;
            for (String instanceID : profile.getInstanceIDs()) {
                StringBuffer buffer = new StringBuffer();
                String name = profile.getProfileNameOnly(instanceID, this.context.getLanguage());
                String detail = profile.getProfileInstanceDescriptionOnly(instanceID, this.context.getLanguage());
                buffer.append(name);
                if (StringUtils.isNotBlank((String)detail)) {
                    buffer.append("<br/><span class='font85 themecolor00'>");
                    if (profile instanceof CMEUserProfileRegenciasDeUnidadeCurricular) {
                        buffer.insert(0, "<a href='" + TagLibUtils.getStageLinkWithParameters((String)UnidadeCurricularStage.class.getSimpleName(), (String)("codeDiscip=" + instanceID)) + "'>");
                        buffer.append(detail + "</a>");
                    } else if (profile instanceof CMEUserProfileRegenciasDeCurso) {
                        buffer.insert(0, "<a href='" + TagLibUtils.getStageLinkWithParameters((String)CursoStage.class.getSimpleName(), (String)("codeCurso=" + instanceID)) + "'>");
                        buffer.append(detail + "</a>");
                    } else {
                        buffer.append(detail);
                    }
                    buffer.append("</span>");
                }
                if (profile instanceof CMEUserProfileCargoGestao) {
                    cargos.add(buffer.toString());
                    continue;
                }
                if (profile instanceof CMEUserProfileRegenciasDeCurso) {
                    cursos.add(buffer.toString());
                    continue;
                }
                if (!(profile instanceof CMEUserProfileRegenciasDeUnidadeCurricular)) continue;
                ucs.add(buffer.toString());
            }
        }
        this.context.addStageResult("cargos", cargos);
        this.context.addStageResult("cursos", cursos);
        this.context.addStageResult("ucs", ucs);
    }

    public IStage getContentStage() {
        IDIFResponse mainResponse = (IDIFResponse)this.context.getRequest().getAttribute("mainResponseObject");
        if (mainResponse == null) {
            return (IStage)this;
        }
        return mainResponse.getStageInstance();
    }

    public boolean getHasContextMenu() {
        List<SideMenuOption> options = this.getRightNavBarLinks();
        return options != null && !options.isEmpty();
    }

    public Map<String, String> getNetQAMessages() {
        return NetQAUtils.getApplicationMessages((String)this.context.getLanguage());
    }

    public NetQAUser getNetQAUser() {
        return this.netQAUser;
    }

    public List<SideMenuOption> getRightNavBarLinks() {
        return SideMenuOption.getOptionsInMainResponse((IDIFContext)this.context);
    }

    public Boolean getShowUserInfo() {
        return false;
    }

    public List<UONode> getUOList() throws DataSetException {
        return this.netQADatabaseService.getUONodeDataSet().query().equals("visible", "true").sortBy("position").sortBy("name").asList();
    }

    public boolean isNetQAApplicationStage() {
        CaseInsentiveArrayList list = new CaseInsentiveArrayList();
        list.add("netqa");
        list.add("csenet");
        return list.contains((Object)this.getContentStage().getService().getApplication().getID());
    }
}

