/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.home;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.controller.interfaces.IDIFSession;
import pt.digitalis.dif.controller.security.managers.ISessionManager;
import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.netqa.InjectNetQAUser;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Context;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.InjectMessages;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.RuleGroupException;
import pt.digitalis.log.LogLevel;
import pt.digitalis.netqa.entities.frontoffice.HomePrivada;
import pt.digitalis.netqa.rules.NetQAUser;
import pt.digitalis.netqa.rules.NetQAUtils;
import pt.digitalis.netqa.rules.exceptions.NetQAException;
import pt.digitalis.utils.common.StringUtils;

@StageDefinition(name="Home", service="HomeService", overrideDefault="difhomestage")
@View(target="netqa/home.jsp")
@Callback
public class HomeNetQA {
    @Context
    protected IDIFContext context;
    @Parameter
    protected String netQASSOToken;
    @InjectNetQAUser
    protected NetQAUser netQAUser;
    @InjectMessages
    protected Map<String, String> stageMessages;

    @Execute
    public void execute() throws IdentityManagerException, DataSetException, MissingContextException, RuleGroupException, NetQAException {
        if (StringUtils.isNotBlank((String)this.netQASSOToken)) {
            try {
                NetQAUtils.authenticateWithSSOAuthenticationToken((String)this.netQASSOToken, (IDIFSession)this.context.getSession(), (boolean)false);
            }
            catch (Exception e) {
                new BusinessException("Cannot authenticate using SSO token: " + this.netQASSOToken, e).log(LogLevel.ERROR);
                this.context.addResultMessage("warn", this.stageMessages.get("ssoAuthenticateFailed"), this.stageMessages.get("ssoAuthenticateFailedDesc"));
            }
        }
        if (this.context.getSession().isLogged()) {
            if (this.netQAUser.isBOUser()) {
                HttpServletRequest originalRequest = (HttpServletRequest)this.context.getRequest().getAttribute("originalRequest");
                originalRequest.getSession().setAttribute("podeVisualizarPhoto", (Object)true);
                this.context.redirectTo(HomePrivada.class.getSimpleName());
            } else if (this.netQAUser.isAdministrator()) {
                this.context.redirectTo("difadminhomestage");
            } else if (this.context.getSession().getUser().canAccess(Entity.STAGE, HomePrivada.class.getSimpleName())) {
                this.context.redirectTo(HomePrivada.class.getSimpleName());
            } else {
                this.context.addResultMessage("warn", this.stageMessages.get("invalidUser"), this.stageMessages.get("invalidUserDesc"), true, true);
                ((ISessionManager)DIFIoCRegistry.getRegistry().getImplementation(ISessionManager.class)).logOut(this.context.getSession().getSessionID());
            }
        }
    }
}

