/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.integrations;

import com.google.inject.Inject;
import java.sql.SQLException;
import java.util.List;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.utils.extensions.cms.ContentItem;
import pt.digitalis.dif.utils.extensions.cms.exception.ContentManagerException;
import pt.digitalis.dif.utils.extensions.cms.exception.NoAccessException;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractFrontOfficeStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.NetQAPagesContentHelper;
import pt.digitalis.netqa.model.InetQAService;
import pt.digitalis.netqa.model.data.Integrations;

@StageDefinition(name="Links \u00fateis", service="IntegrationsPrivateService")
@View(target="netqa/frontoffice/integrations.jsp")
@Callback
public class IntegrationsStage
extends AbstractFrontOfficeStage {
    @Inject
    protected InetQAService netQAService;

    @Execute
    public void execute() throws NoAccessException, ContentManagerException, IdentityManagerException, BusinessException, SQLException {
        ContentItem contentItem = NetQAPagesContentHelper.getGenericContent("integrators", (IDIFUser)this.context.getSession().getUser());
        this.context.addStageResult("content", (Object)contentItem);
        if (this.context.getSession().isLogged()) {
            this.context.addStageResult("contentEditable", (Object)(this.netQAUser.isAdministrator() || this.netQAUser.isBOUser() ? 1 : 0));
            this.context.addStageResult("isLogged", (Object)true);
        }
    }

    public List<Integrations> getIntegrations() throws DataSetException {
        return this.netQAService.getIntegrationsDataSet().query().equals("active", "true").sortBy("orderNumber").asList();
    }
}

