/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.netqa.entities.reports;

import com.google.inject.Inject;
import java.sql.SQLException;
import java.util.List;
import pt.digitalis.dif.controller.objects.DIFUserInSession;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.dem.annotations.entities.StageDefinition;
import pt.digitalis.dif.dem.annotations.stage.Callback;
import pt.digitalis.dif.dem.annotations.stage.Execute;
import pt.digitalis.dif.dem.annotations.stage.View;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.utils.extensions.cms.ContentItem;
import pt.digitalis.dif.utils.extensions.cms.exception.ContentManagerException;
import pt.digitalis.dif.utils.extensions.cms.exception.NoAccessException;
import pt.digitalis.dif.utils.extensions.document.IDocumentRepositoryManager;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.AbstractFrontOfficeStage;
import pt.digitalis.netqa.entities.frontoffice.helperclasses.NetQAPagesContentHelper;
import pt.digitalis.netqa.model.InetQAService;
import pt.digitalis.netqa.model.data.Report;
import pt.digitalis.netqa.model.data.ReportCategory;
import pt.digitalis.utils.common.StringUtils;

@StageDefinition(name="Relat\u00f3rios", service="ReportsPrivateService")
@View(target="netqa/frontoffice/reports.jsp")
@Callback
public class ReportsStage
extends AbstractFrontOfficeStage {
    @Inject
    protected IDocumentRepositoryManager documentRepositoryManager;
    @Inject
    protected InetQAService netQAService;

    @Execute
    public void execute() throws NoAccessException, ContentManagerException, IdentityManagerException, BusinessException, SQLException {
        ContentItem contentItem = NetQAPagesContentHelper.getGenericContent("reports", (IDIFUser)this.context.getSession().getUser());
        this.context.addStageResult("content", (Object)contentItem);
        if (this.context.getSession().isLogged()) {
            this.context.addStageResult("contentEditable", (Object)(this.netQAUser.isAdministrator() || this.netQAUser.isBOUser() ? 1 : 0));
            this.context.addStageResult("isLogged", (Object)true);
        }
    }

    public List<ReportCategory> getReportCategories() throws DataSetException {
        Query query = this.netQAService.getReportCategoryDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ReportCategory.FK().reports(), JoinType.LEFT_OUTER_JOIN).equals(ReportCategory.FK().reports().VISIBLE(), "true").isNotNull(ReportCategory.FK().reports().DOCUMENTID()).sortBy("description").sortBy(ReportCategory.FK().reports().TITLE());
        query.setDistinctEntities(true);
        return query.asList();
    }

    public boolean validateAccessToReport(Report report) throws IdentityManagerException {
        if (report.getDocumentId() != null) {
            this.documentRepositoryManager.authorizeDocumentForCurrentSession(this.context.getSession(), report.getDocumentId());
        }
        if (StringUtils.isBlank((String)report.getRestrictAccessToGroups())) {
            return true;
        }
        DIFUserInSession currentUser = this.context.getSession().getUser();
        for (String groupToValidate : report.getRestrictAccessToGroups().split(",")) {
            if (!groupToValidate.equals(currentUser.getProfileID()) && !currentUser.getGroupIDs().contains(groupToValidate)) continue;
            return true;
        }
        return false;
    }
}

