package pt.digitalis.utils.documents;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * A generic document interface
 *
 * @author Antnio Silva <a href="mailto:asilva@digitalis.pt">asilva@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2008/08/01
 */
public interface IDocument
{

    /**
     * @return <code>OutputStream</code> with the
     */
    public ByteArrayOutputStream exportAsOutputStream();

    /**
     * @return the current document content as a byte[]
     */
    public byte[] getBytes();

    /**
     * @return the name
     */
    public String getName();

    /**
     * @param name the name to set
     */
    public void setName(String name);

    /**
     * Saves the current document to disk
     *
     * @param fileName the file name to save to
     *
     * @exception IOException if an error occurred
     */
    public void saveToFile(String fileName) throws IOException;
}
