package pt.digitalis.utils.documents.excel;

import java.util.HashMap;
import java.util.Map;

/**
 * A workbook row object
 *
 * @author Antnio Silva <a href="mailto:asilva@digitalis.pt">asilva@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2008/08/01
 */
public class ExcelRow
{

    /** the maximum cell inserted */
    Integer maxCellIndex = 0;

    /**
     * The workbook row cells
     */
    private Map<Integer, ExcelCell> cells = new HashMap<Integer, ExcelCell>();

    /**
     * Adds a new cell to the row
     *
     * @param index the index for the cell
     * @param value the cell value
     *
     * @return the new cell
     */
    public ExcelCell addCell(Integer index, String value)
    {
        if (index > maxCellIndex)
            maxCellIndex = index;

        ExcelCell cell = new ExcelCell();
        cell.setValue(value);

        cells.put(index, cell);

        return cell;
    }

    /**
     * Adds a new cell to the row
     *
     * @param value the cell value
     *
     * @return the new cell
     */
    public ExcelCell addCell(String value)
    {
        return addCell(maxCellIndex + 1, value);
    }

    /**
     * Gets a cell from the row
     *
     * @param index the index of the cell to get
     *
     * @return the cell
     */
    public ExcelCell getCell(Integer index)
    {

        ExcelCell cell = cells.get(index);

        if (cell == null)
            cell = addCell(index, null);

        return cell;
    }

    /**
     * @return the cells
     */
    public Map<Integer, ExcelCell> getCells()
    {
        return cells;
    }
}
