/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.utils.reporting;

/**
 * Defines the behavior of a data source field.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/12/10
 */
public interface IDataSourceField
{

    /**
     * Gets the field optional description.
     *
     * @return the optional description
     */
    public String getDescription();

    /**
     * Sets the field description.
     *
     * @param description the field description to set
     */
    public void setDescription(String description);

    /**
     * Gets the field unique name.
     *
     * @return the field's unique name
     */
    public String getName();

    /**
     * Gets the field value class.
     *
     * @return the field value class
     */
    @SuppressWarnings("rawtypes")
    public Class getValueClass();

    /**
     * Gets the field value class name.
     *
     * @return the field value class name
     */
    public String getValueClassName();
}
