/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.utils.reporting;

import pt.digitalis.utils.reporting.exception.ReportingException;

/**
 * Defines the behavior of a report data source.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/12/10
 */
public interface IReportDataSource
{

    /**
     * Gets the field value for the current position.
     *
     * @param field the field
     *
     * @return the field value
     *
     * @exception ReportingException if the field value can't be retrieved
     */
    public Object getFieldValue(IDataSourceField field) throws ReportingException;

    /**
     * Tries to position the cursor on the next element in the data source.
     *
     * @return T if there's a next element, F otherwise
     */
    public boolean next();
}
