package pt.digitalis.utils.reporting.exception;

/**
 * This is the exception for the reporting
 *
 * @author Antnio Silva <a href="mailto:asilva@digitalis.pt">asilva@digitalis.pt</a>
 * @created 2009/03/12
 */
public class ReportingException extends Exception
{

    /** The "The report can't be filled!" message as a constant. */
    final static public String REPORT_CANT_BE_FILLED_MESSAGE = "The report can't be filled!";

    /** The "The report can't be filled! Data source was null..." message as a constant. */
    final static public String NULL_DATA_SOURCE_MESSAGE = REPORT_CANT_BE_FILLED_MESSAGE + " Data source was null...";

    /** The "The report can't be filled! Input data stream was null..." message as a constant. */
    final static public String NULL_INPUT_STREAM_MESSAGE = REPORT_CANT_BE_FILLED_MESSAGE + " Input stream was null...";

    /** The "The report can't be compiled from template: " message as a constant. */
    final static public String REPORT_CANT_BE_COMPILED_MESSAGE = "The report can't be compiled from template: ";

    /** The "The report template cannot be found" message as a constant. */
    final static public String REPORT_TEMPLATE_NOT_FOUND_MESSAGE = "The report template is not acessible: ";

    /** The "Could not export report to " message as a constant. */
    final static public String REPORT_CANT_BE_EXPORTED_MESSAGE = "Could not export report to ";

    /** The "Invalid JDBC connection! Could not connect to: " message as a constant. */
    final static public String INVALID_CONNECTION = "Invalid JDBC connection! Could not connect to: ";

    /**
     * Serial version ID
     */
    private static final long serialVersionUID = 7222995925424029943L;

    /**
     * Constructs a new exception with a message.
     *
     * @param message the exception message
     */
    public ReportingException(String message)
    {
        super(message);
    }

    /**
     * Constructs a new exception with a message and a cause.
     *
     * @param message the exception message
     * @param cause   the exception cause
     */
    public ReportingException(String message, Throwable cause)
    {
        super(message, cause);
    }

    /**
     * Constructs a new exception with a cause.
     *
     * @param cause the exception cause
     */
    public ReportingException(Throwable cause)
    {
        super(cause);
    }
}
