/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.PPP_PCD_PATHWAY;
import ca.uhn.hl7v2.model.v23.group.PPP_PCD_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPP_PCD
extends AbstractMessage {
    public PPP_PCD() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public PPP_PCD(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(PID.class, true, false);
            this.add(PPP_PCD_PATIENT_VISIT.class, false, false);
            this.add(PPP_PCD_PATHWAY.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PPP_PCD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PPP_PCD_PATIENT_VISIT getPATIENT_VISIT() {
        return (PPP_PCD_PATIENT_VISIT)this.getTyped("PATIENT_VISIT", PPP_PCD_PATIENT_VISIT.class);
    }

    public PPP_PCD_PATHWAY getPATHWAY() {
        return (PPP_PCD_PATHWAY)this.getTyped("PATHWAY", PPP_PCD_PATHWAY.class);
    }

    public PPP_PCD_PATHWAY getPATHWAY(int rep) {
        return (PPP_PCD_PATHWAY)this.getTyped("PATHWAY", rep, PPP_PCD_PATHWAY.class);
    }

    public int getPATHWAYReps() {
        return this.getReps("PATHWAY");
    }

    public List<PPP_PCD_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", PPP_PCD_PATHWAY.class);
    }

    public void insertPATHWAY(PPP_PCD_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", (Structure)structure, rep);
    }

    public PPP_PCD_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (PPP_PCD_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public PPP_PCD_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (PPP_PCD_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }
}

