/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.VXX_V02_PIDNK1;
import ca.uhn.hl7v2.model.v231.segment.MSA;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.QRD;
import ca.uhn.hl7v2.model.v231.segment.QRF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VXX_V02
extends AbstractMessage {
    public VXX_V02() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public VXX_V02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(VXX_V02_PIDNK1.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating VXX_V02 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public QRD getQRD() {
        return (QRD)this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return (QRF)this.getTyped("QRF", QRF.class);
    }

    public VXX_V02_PIDNK1 getPIDNK1() {
        return (VXX_V02_PIDNK1)this.getTyped("PIDNK1", VXX_V02_PIDNK1.class);
    }

    public VXX_V02_PIDNK1 getPIDNK1(int rep) {
        return (VXX_V02_PIDNK1)this.getTyped("PIDNK1", rep, VXX_V02_PIDNK1.class);
    }

    public int getPIDNK1Reps() {
        return this.getReps("PIDNK1");
    }

    public List<VXX_V02_PIDNK1> getPIDNK1All() throws HL7Exception {
        return this.getAllAsList("PIDNK1", VXX_V02_PIDNK1.class);
    }

    public void insertPIDNK1(VXX_V02_PIDNK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("PIDNK1", (Structure)structure, rep);
    }

    public VXX_V02_PIDNK1 insertPIDNK1(int rep) throws HL7Exception {
        return (VXX_V02_PIDNK1)super.insertRepetition("PIDNK1", rep);
    }

    public VXX_V02_PIDNK1 removePIDNK1(int rep) throws HL7Exception {
        return (VXX_V02_PIDNK1)super.removeRepetition("PIDNK1", rep);
    }
}

