/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DT;
import ca.uhn.hl7v2.model.v26.datatype.EI;

public class PIP
extends AbstractComposite {
    private Type[] data;

    public PIP(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[5];
        this.data[0] = new CWE(this.getMessage());
        this.data[1] = new CWE(this.getMessage());
        this.data[2] = new DT(this.getMessage());
        this.data[3] = new DT(this.getMessage());
        this.data[4] = new EI(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CWE getPrivilege() {
        return (CWE)this.getTyped(0, CWE.class);
    }

    public CWE getPip1_Privilege() {
        return (CWE)this.getTyped(0, CWE.class);
    }

    public CWE getPrivilegeClass() {
        return (CWE)this.getTyped(1, CWE.class);
    }

    public CWE getPip2_PrivilegeClass() {
        return (CWE)this.getTyped(1, CWE.class);
    }

    public DT getExpirationDate() {
        return (DT)this.getTyped(2, DT.class);
    }

    public DT getPip3_ExpirationDate() {
        return (DT)this.getTyped(2, DT.class);
    }

    public DT getActivationDate() {
        return (DT)this.getTyped(3, DT.class);
    }

    public DT getPip4_ActivationDate() {
        return (DT)this.getTyped(3, DT.class);
    }

    public EI getFacility() {
        return (EI)this.getTyped(4, EI.class);
    }

    public EI getPip5_Facility() {
        return (EI)this.getTyped(4, EI.class);
    }
}

