/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing.metadata;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;

public class WSDLLocation {
    private static final QName WSDLI = new QName("http://www.w3.org/2006/01/wsdl-instance", "wsdlLocation", "wsdli");
    private String targetNamespace;
    private String wsdlURL;

    public WSDLLocation() {
    }

    public WSDLLocation(String targetNamespace, String wsdlURL) {
        this.targetNamespace = targetNamespace;
        this.wsdlURL = wsdlURL;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getLocation() {
        return this.wsdlURL;
    }

    public void setLocation(String wsdlURL) {
        this.wsdlURL = wsdlURL;
    }

    public OMAttribute toOM(OMFactory factory) {
        String value = this.targetNamespace + " " + this.wsdlURL;
        OMNamespace wsdliNs = factory.createOMNamespace(WSDLI.getNamespaceURI(), WSDLI.getPrefix());
        OMAttribute omAttribute = factory.createOMAttribute(WSDLI.getLocalPart(), wsdliNs, value);
        return omAttribute;
    }

    public void fromOM(OMAttribute omAttribute) throws AxisFault {
        String[] values;
        QName qname = omAttribute.getQName();
        if (WSDLI.equals(qname)) {
            String value = omAttribute.getAttributeValue().trim();
            values = value.split("\\s", 2);
            if (values.length != 2) {
                return;
            }
        } else {
            throw new AxisFault("Unrecognized element.");
        }
        this.targetNamespace = values[0];
        this.wsdlURL = values[1];
    }

    public static boolean isWSDLLocationAttribute(OMAttribute omAttribute) {
        boolean result = false;
        QName qname = omAttribute.getQName();
        if (WSDLI.equals(qname)) {
            result = true;
        }
        return result;
    }
}

