/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.nhttp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.nhttp.NHttpConfiguration;
import org.apache.axis2.transport.nhttp.PlainServerIOEventDispatch;
import org.apache.axis2.transport.nhttp.ServerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class HttpCoreNIOListener
implements TransportListener {
    private static final Log log = LogFactory.getLog((Class)HttpCoreNIOListener.class);
    private ConfigurationContext cfgCtx;
    private ListeningIOReactor ioReactor = null;
    private String serviceEPRPrefix;
    private int port = 8080;
    private String host = "localhost";
    private SSLContext sslContext = null;
    private SSLIOSessionHandler sslIOSessionHandler = null;

    private void startServerEngine(int port) {
        HttpParams params = this.getServerParameters();
        try {
            this.ioReactor = new DefaultListeningIOReactor(NHttpConfiguration.getInstance().getServerIOWorkers(), params);
        }
        catch (IOException e) {
            log.error((Object)"Error starting the IOReactor", (Throwable)e);
        }
        ServerHandler handler = new ServerHandler(this.cfgCtx, params, this.sslContext != null);
        IOEventDispatch ioEventDispatch = this.getEventDispatch(handler, this.sslContext, this.sslIOSessionHandler, params);
        try {
            this.ioReactor.listen((SocketAddress)new InetSocketAddress(port));
            this.ioReactor.execute(ioEventDispatch);
        }
        catch (InterruptedIOException ex) {
            log.fatal((Object)"Reactor Interrupted");
        }
        catch (IOException e) {
            log.fatal((Object)("Encountered an I/O error: " + e.getMessage()), (Throwable)e);
        }
        log.info((Object)"Listener Shutdown");
    }

    protected IOEventDispatch getEventDispatch(NHttpServiceHandler handler, SSLContext sslContext, SSLIOSessionHandler sslioSessionHandler, HttpParams params) {
        return new PlainServerIOEventDispatch(handler, params);
    }

    private HttpParams getServerParameters() {
        BasicHttpParams params = new BasicHttpParams();
        NHttpConfiguration cfg = NHttpConfiguration.getInstance();
        params.setIntParameter("http.socket.timeout", cfg.getProperty("http.socket.timeout", 60000)).setIntParameter("http.socket.buffer-size", cfg.getProperty("http.socket.buffer-size", 8192)).setBooleanParameter("http.connection.stalecheck", cfg.getProperty("http.connection.stalecheck", 0) == 1).setBooleanParameter("http.tcp.nodelay", cfg.getProperty("http.tcp.nodelay", 1) == 1).setParameter("http.origin-server", (Object)"Axis2-HttpComponents-NIO");
        return params;
    }

    public void init(ConfigurationContext cfgCtx, TransportInDescription transprtIn) throws AxisFault {
        this.cfgCtx = cfgCtx;
        Parameter param = transprtIn.getParameter("port");
        if (param != null) {
            this.port = Integer.parseInt((String)param.getValue());
        }
        if ((param = transprtIn.getParameter("hostname")) != null) {
            this.host = ((String)param.getValue()).trim();
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.warn((Object)"Unable to lookup local host name, using 'localhost'");
            }
        }
        this.sslContext = this.getSSLContext(transprtIn);
        this.serviceEPRPrefix = this.getServiceEPRPrefix(cfgCtx, this.host, this.port);
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String host, int port) {
        return "http://" + host + (port == 80 ? "" : ":" + port) + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    protected SSLContext getSSLContext(TransportInDescription transportIn) throws AxisFault {
        return null;
    }

    public void start() throws AxisFault {
        log.debug((Object)"Starting Listener...");
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    HttpCoreNIOListener.this.startServerEngine(HttpCoreNIOListener.this.port);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, "HttpCoreNIOListener");
        t.start();
        log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + " Listener starting on port : " + this.port));
    }

    public void stop() throws AxisFault {
        try {
            this.ioReactor.shutdown();
            log.info((Object)"Listener shut down");
        }
        catch (IOException e) {
            this.handleException("Error shutting down IOReactor", e);
        }
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return new EndpointReference(this.serviceEPRPrefix + serviceName + "/");
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        EndpointReference[] endpointReferences = new EndpointReference[]{new EndpointReference(this.serviceEPRPrefix + serviceName + "/")};
        return endpointReferences;
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public void destroy() {
        this.ioReactor = null;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, e);
    }
}

