/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.sampler;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.util.BSFTestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class BSFSampler
extends BSFTestElement
implements Sampler,
TestBean {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();

    public String getLabel() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SampleResult sample(Entry e) {
        SampleResult res;
        block10: {
            String label = this.getLabel();
            String request = this.getScript();
            String fileName = this.getFilename();
            log.debug(label + " " + fileName);
            res = new SampleResult();
            res.setSampleLabel(label);
            FileInputStream is = null;
            BSFEngine bsfEngine = null;
            BSFManager mgr = new BSFManager();
            res.setResponseCode("200");
            res.setResponseMessage("OK");
            res.setSuccessful(true);
            res.setDataType("text");
            res.sampleStart();
            try {
                this.initManager(mgr);
                mgr.declareBean("SampleResult", (Object)res, res.getClass());
                bsfEngine = mgr.loadScriptingEngine(this.getScriptLanguage());
                Object bsfOut = null;
                if (fileName.length() > 0) {
                    res.setSamplerData("File: " + fileName);
                    is = new FileInputStream(fileName);
                    bsfOut = bsfEngine.eval(fileName, 0, 0, (Object)IOUtils.toString((InputStream)is));
                } else {
                    res.setSamplerData(request);
                    bsfOut = bsfEngine.eval("script", 0, 0, (Object)request);
                }
                if (bsfOut != null) {
                    res.setResponseData(bsfOut.toString(), null);
                }
                res.sampleEnd();
            }
            catch (BSFException ex) {
                log.warn("BSF error", (Throwable)ex);
                res.setSuccessful(false);
                res.setResponseCode("500");
                res.setResponseMessage(ex.toString());
                break block10;
            }
            catch (Exception ex2) {
                log.warn("Problem evaluating the script", (Throwable)ex2);
                res.setSuccessful(false);
                res.setResponseCode("500");
                res.setResponseMessage(ex2.toString());
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                res.sampleEnd();
                IOUtils.closeQuietly(is);
                mgr.terminate();
            }
            IOUtils.closeQuietly((InputStream)is);
            mgr.terminate();
        }
        return res;
    }
}

