/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.mop.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import org.dynalang.mop.BaseMetaobjectProtocol;

public class AutoDiscovery {
    private static final String RESOURCE_PATH = "META-INF/services/org.dynalang.mop.BaseMetaobjectProtocol";

    private AutoDiscovery() {
    }

    public static BaseMetaobjectProtocol[] discoverBaseMetaobjectProtocols() throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        return AutoDiscovery.discoverBaseMetaobjectProtocols(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseMetaobjectProtocol[] discoverBaseMetaobjectProtocols(ClassLoader cl) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Enumeration<URL> urls;
        LinkedList<BaseMetaobjectProtocol> protocols = new LinkedList<BaseMetaobjectProtocol>();
        if (cl == null) {
            urls = ClassLoader.getSystemResources(RESOURCE_PATH);
            cl = ClassLoader.getSystemClassLoader();
        } else {
            urls = cl.getResources(RESOURCE_PATH);
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream in = url.openStream();
            try {
                String className;
                BufferedReader r = new BufferedReader(new InputStreamReader(in));
                while ((className = r.readLine()) != null) {
                    if ("".equals(className = className.trim()) || className.startsWith("#")) continue;
                    protocols.add((BaseMetaobjectProtocol)Class.forName(className.toString(), true, cl).newInstance());
                }
            }
            finally {
                in.close();
            }
        }
        return protocols.toArray(new BaseMetaobjectProtocol[protocols.size()]);
    }
}

