/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"Comparable"})
public class RubyComparable {
    public static RubyModule createComparable(Ruby runtime2) {
        RubyModule comparableModule = runtime2.defineModule("Comparable");
        runtime2.setComparable(comparableModule);
        comparableModule.defineAnnotatedMethods(RubyComparable.class);
        return comparableModule;
    }

    public static int cmpint(ThreadContext context, IRubyObject val, IRubyObject a, IRubyObject b) {
        if (val.isNil()) {
            RubyComparable.cmperr(a, b);
        }
        if (val instanceof RubyFixnum) {
            return RubyNumeric.fix2int((RubyFixnum)val);
        }
        if (val instanceof RubyBignum) {
            return ((RubyBignum)val).getValue().signum() == -1 ? 1 : -1;
        }
        RubyFixnum zero = RubyFixnum.zero(context.getRuntime());
        if (val.callMethod(context, ">", zero).isTrue()) {
            return 1;
        }
        if (val.callMethod(context, "<", zero).isTrue()) {
            return -1;
        }
        return 0;
    }

    public static IRubyObject cmperr(IRubyObject recv2, IRubyObject other) {
        IRubyObject target = other.isImmediate() || !other.isNil() && !other.isTrue() && other != recv2.getRuntime().getFalse() ? other.inspect() : other.getType();
        throw recv2.getRuntime().newArgumentError("comparison of " + recv2.getType() + " with " + target + " failed");
    }

    @JRubyMethod(name={"=="}, required=1)
    public static IRubyObject op_equal(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (recv2 == other) {
            return runtime2.getTrue();
        }
        try {
            IRubyObject result = recv2.callMethod(context, "<=>", other);
            return RubyBoolean.newBoolean(runtime2, RubyComparable.cmpint(context, result, recv2, other) == 0);
        }
        catch (RaiseException e) {
            if (e.getException().kind_of_p(context, runtime2.getStandardError()).isTrue()) {
                return runtime2.getNil();
            }
            throw e;
        }
    }

    @JRubyMethod(name={">"}, required=1)
    public static RubyBoolean op_gt(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result = recv2.callMethod(context, "<=>", other);
        if (result.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.getRuntime(), RubyComparable.cmpint(context, result, recv2, other) > 0);
    }

    @JRubyMethod(name={">="}, required=1)
    public static RubyBoolean op_ge(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result = recv2.callMethod(context, "<=>", other);
        if (result.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.getRuntime(), RubyComparable.cmpint(context, result, recv2, other) >= 0);
    }

    @JRubyMethod(name={"<"}, required=1)
    public static RubyBoolean op_lt(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result = recv2.callMethod(context, "<=>", other);
        if (result.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.getRuntime(), RubyComparable.cmpint(context, result, recv2, other) < 0);
    }

    @JRubyMethod(name={"<="}, required=1)
    public static RubyBoolean op_le(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        IRubyObject result = recv2.callMethod(context, "<=>", other);
        if (result.isNil()) {
            RubyComparable.cmperr(recv2, other);
        }
        return RubyBoolean.newBoolean(context.getRuntime(), RubyComparable.cmpint(context, result, recv2, other) <= 0);
    }

    @JRubyMethod(name={"between?"}, required=2)
    public static RubyBoolean between_p(ThreadContext context, IRubyObject recv2, IRubyObject first2, IRubyObject second) {
        return context.getRuntime().newBoolean(RubyComparable.op_lt(context, recv2, first2).isFalse() && RubyComparable.op_gt(context, recv2, second).isFalse());
    }
}

