/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Constants;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.ClassExtensionLibrary;
import org.jruby.runtime.load.ExternalScript;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.JarredScript;
import org.jruby.runtime.load.JavaCompiledScript;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.JRubyFile;

public class LoadService {
    protected static final Pattern sourcePattern = Pattern.compile("\\.(?:rb)$");
    protected static final Pattern extensionPattern = Pattern.compile("\\.(?:so|o|dll|jar)$");
    protected RubyArray loadPath;
    protected RubyArray loadedFeatures;
    protected List loadedFeaturesInternal;
    protected final Map<String, Library> builtinLibraries = new HashMap<String, Library>();
    protected final Map<String, JarFile> jarFiles = new HashMap<String, JarFile>();
    protected final Map<String, IAutoloadMethod> autoloadMap = new HashMap<String, IAutoloadMethod>();
    protected final Ruby runtime;
    private Map requireLocks = new Hashtable();
    private final List<LoadSearcher> searchers = new ArrayList<LoadSearcher>();

    public LoadService(Ruby runtime2) {
        this.searchers.add(new BailoutSearcher());
        this.searchers.add(new NormalSearcher());
        this.searchers.add(new ClassLoaderSearcher());
        this.searchers.add(new ExtensionSearcher());
        this.searchers.add(new ScriptClassSearcher());
        this.runtime = runtime2;
    }

    public void init(List additionalDirectories) {
        RubyString env_rubylib;
        this.loadPath = RubyArray.newArray(this.runtime);
        this.loadedFeatures = RubyArray.newArray(this.runtime);
        this.loadedFeaturesInternal = Collections.synchronizedList(this.loadedFeatures);
        Iterator iter = additionalDirectories.iterator();
        while (iter.hasNext()) {
            this.addPath((String)iter.next());
        }
        RubyHash env = (RubyHash)this.runtime.getObject().fastGetConstant("ENV");
        if (env.has_key_p(env_rubylib = this.runtime.newString("RUBYLIB")).isTrue()) {
            String rubylib = env.op_aref(this.runtime.getCurrentContext(), env_rubylib).toString();
            String[] paths = rubylib.split(File.pathSeparator);
            for (int i = 0; i < paths.length; ++i) {
                this.addPath(paths[i]);
            }
        }
        if (!Ruby.isSecurityRestricted()) {
            try {
                String jrubyHome = this.runtime.getJRubyHome();
                if (jrubyHome != null) {
                    char sep = '/';
                    String rubyDir = jrubyHome + sep + "lib" + sep + "ruby" + sep;
                    if (this.runtime.is1_9()) {
                        this.addPath(rubyDir + "site_ruby" + sep + Constants.RUBY1_9_MAJOR_VERSION);
                        this.addPath(rubyDir + "site_ruby");
                        this.addPath(rubyDir + Constants.RUBY1_9_MAJOR_VERSION);
                        this.addPath(rubyDir + Constants.RUBY1_9_MAJOR_VERSION + sep + "java");
                    } else {
                        this.addPath(rubyDir + "site_ruby" + sep + Constants.RUBY_MAJOR_VERSION);
                        this.addPath(rubyDir + "site_ruby");
                        this.addPath(rubyDir + Constants.RUBY_MAJOR_VERSION);
                        this.addPath(rubyDir + Constants.RUBY_MAJOR_VERSION + sep + "java");
                    }
                    this.addPath("lib" + sep + "ruby" + sep + Constants.RUBY_MAJOR_VERSION);
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        if (this.runtime.getSafeLevel() == 0) {
            this.addPath(".");
        }
    }

    private void addLoadedFeature(RubyString loadNameRubyString) {
        this.loadedFeaturesInternal.add(loadNameRubyString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPath(String path2) {
        if (path2 == null || path2.length() == 0) {
            return;
        }
        RubyArray rubyArray = this.loadPath;
        synchronized (rubyArray) {
            this.loadPath.append(this.runtime.newString(path2.replace('\\', '/')));
        }
    }

    public void load(String file2, boolean wrap2) {
        if (!this.runtime.getProfile().allowLoad(file2)) {
            throw this.runtime.newLoadError("No such file to load -- " + file2);
        }
        SearchState state = new SearchState(file2);
        state.prepareLoadSearch(file2);
        Library library2 = this.findBuiltinLibrary(state, state.searchFile, state.suffixType);
        if (library2 == null) {
            library2 = this.findLibraryWithoutCWD(state, state.searchFile, state.suffixType);
        }
        if (library2 == null && (library2 = this.findLibraryWithClassloaders(state, state.searchFile, state.suffixType)) == null) {
            throw this.runtime.newLoadError("No such file to load -- " + file2);
        }
        try {
            library2.load(this.runtime, wrap2);
        }
        catch (IOException e) {
            if (this.runtime.getDebug().isTrue()) {
                e.printStackTrace(this.runtime.getErr());
            }
            throw this.runtime.newLoadError("IO error -- " + file2);
        }
    }

    public SearchState findFileForLoad(String file2) throws AlreadyLoaded {
        SearchState state = new SearchState(file2);
        state.prepareRequireSearch(file2);
        for (LoadSearcher searcher : this.searchers) {
            if (!searcher.shouldTrySearch(state)) continue;
            searcher.trySearch(state);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockAndRequire(String requireName) {
        try {
            Object requireLock;
            Object object = this.requireLocks;
            synchronized (object) {
                requireLock = this.requireLocks.get(requireName);
                if (requireLock == null) {
                    requireLock = new Object();
                    this.requireLocks.put(requireName, requireLock);
                }
            }
            object = requireLock;
            synchronized (object) {
                boolean bl = this.require(requireName);
                return bl;
            }
        }
        finally {
            Map map = this.requireLocks;
            synchronized (map) {
                this.requireLocks.remove(requireName);
            }
        }
    }

    public boolean smartLoad(String file2) {
        this.checkEmptyLoad(file2);
        try {
            SearchState state = this.findFileForLoad(file2);
            return this.tryLoadingLibraryOrScript(this.runtime, state);
        }
        catch (AlreadyLoaded al) {
            return false;
        }
    }

    public boolean require(String file2) {
        if (!this.runtime.getProfile().allowRequire(file2)) {
            throw this.runtime.newLoadError("No such file to load -- " + file2);
        }
        return this.smartLoad(file2);
    }

    public IRubyObject getLoadPath() {
        return this.loadPath;
    }

    public IRubyObject getLoadedFeatures() {
        return this.loadedFeatures;
    }

    public IAutoloadMethod autoloadFor(String name2) {
        return this.autoloadMap.get(name2);
    }

    public void removeAutoLoadFor(String name2) {
        this.autoloadMap.remove(name2);
    }

    public IRubyObject autoload(String name2) {
        IAutoloadMethod loadMethod = this.autoloadMap.remove(name2);
        if (loadMethod != null) {
            return loadMethod.load(this.runtime, name2);
        }
        return null;
    }

    public void addAutoload(String name2, IAutoloadMethod loadMethod) {
        this.autoloadMap.put(name2, loadMethod);
    }

    public void addBuiltinLibrary(String name2, Library library2) {
        this.builtinLibraries.put(name2, library2);
    }

    public void removeBuiltinLibrary(String name2) {
        this.builtinLibraries.remove(name2);
    }

    public void removeInternalLoadedFeature(String name2) {
        this.loadedFeaturesInternal.remove(name2);
    }

    private boolean featureAlreadyLoaded(RubyString loadNameRubyString) {
        return this.loadedFeaturesInternal.contains(loadNameRubyString);
    }

    private boolean isJarfileLibrary(SearchState state, String file2) {
        return state.library instanceof JarredScript && file2.endsWith(".jar");
    }

    private void removeLoadedFeature(RubyString loadNameRubyString) {
        this.loadedFeaturesInternal.remove(loadNameRubyString);
    }

    private void reraiseRaiseExceptions(Throwable e) throws RaiseException {
        if (e instanceof RaiseException) {
            throw (RaiseException)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLoadingLibraryOrScript(Ruby runtime2, SearchState state) {
        RubyString loadNameRubyString = RubyString.newString(runtime2, state.loadName);
        try {
            List list2 = this.loadedFeaturesInternal;
            synchronized (list2) {
                if (this.loadedFeaturesInternal.contains(loadNameRubyString)) {
                    return false;
                }
                this.addLoadedFeature(loadNameRubyString);
            }
            state.library.load(runtime2, false);
            return true;
        }
        catch (MainExitException mee) {
            throw mee;
        }
        catch (Throwable e) {
            if (this.isJarfileLibrary(state, state.searchFile)) {
                return true;
            }
            this.removeLoadedFeature(loadNameRubyString);
            this.reraiseRaiseExceptions(e);
            if (runtime2.getDebug().isTrue()) {
                e.printStackTrace(runtime2.getErr());
            }
            RaiseException re = runtime2.newLoadError("IO error -- " + state.searchFile);
            re.initCause(e);
            throw re;
        }
    }

    private String buildClassName(String className) {
        if ((className = className.replaceFirst("^\\.\\/", "")).lastIndexOf(".") != -1) {
            className = className.substring(0, className.lastIndexOf("."));
        }
        className = className.replace("-", "_minus_").replace('.', '_');
        return className;
    }

    private void checkEmptyLoad(String file2) throws RaiseException {
        if (file2.equals("")) {
            throw this.runtime.newLoadError("No such file to load -- " + file2);
        }
    }

    private Library findBuiltinLibrary(SearchState state, String baseName, SuffixType suffixType) {
        for (String suffix : suffixType.getSuffixes()) {
            String namePlusSuffix = baseName + suffix;
            if (!this.builtinLibraries.containsKey(namePlusSuffix)) continue;
            state.loadName = namePlusSuffix;
            return this.builtinLibraries.get(namePlusSuffix);
        }
        return null;
    }

    private Library findLibraryWithoutCWD(SearchState state, String baseName, SuffixType suffixType) {
        Library library2 = null;
        switch (suffixType) {
            case Both: {
                library2 = this.findBuiltinLibrary(state, baseName, SuffixType.Source);
                if (library2 == null) {
                    library2 = this.createLibrary(state, this.tryResourceFromJarURL(state, baseName, SuffixType.Source));
                }
                if (library2 == null) {
                    library2 = this.createLibrary(state, this.tryResourceFromLoadPathOrURL(state, baseName, SuffixType.Source));
                }
                if (library2 == null) {
                    library2 = this.findBuiltinLibrary(state, baseName, SuffixType.Extension);
                }
                if (library2 == null) {
                    library2 = this.createLibrary(state, this.tryResourceFromJarURL(state, baseName, SuffixType.Extension));
                }
                if (library2 != null) break;
                library2 = this.createLibrary(state, this.tryResourceFromLoadPathOrURL(state, baseName, SuffixType.Extension));
                break;
            }
            case Source: 
            case Extension: {
                library2 = this.findBuiltinLibrary(state, baseName, suffixType);
                if (library2 == null) {
                    library2 = this.createLibrary(state, this.tryResourceFromJarURL(state, baseName, suffixType));
                }
                if (library2 != null) break;
                library2 = this.createLibrary(state, this.tryResourceFromLoadPathOrURL(state, baseName, suffixType));
                break;
            }
            case Neither: {
                library2 = this.createLibrary(state, this.tryResourceFromJarURL(state, baseName, SuffixType.Neither));
                if (library2 != null) break;
                library2 = this.createLibrary(state, this.tryResourceFromLoadPathOrURL(state, baseName, SuffixType.Neither));
            }
        }
        return library2;
    }

    private Library findLibraryWithClassloaders(SearchState state, String baseName, SuffixType suffixType) {
        for (String suffix : suffixType.getSuffixes()) {
            String file2 = baseName + suffix;
            LoadServiceResource resource2 = this.findFileInClasspath(file2);
            if (resource2 == null) continue;
            state.loadName = file2;
            return this.createLibrary(state, resource2);
        }
        return null;
    }

    private Library createLibrary(SearchState state, LoadServiceResource resource2) {
        if (resource2 == null) {
            return null;
        }
        String file2 = state.loadName;
        if (file2.contains(".so")) {
            throw this.runtime.newLoadError("JRuby does not support .so libraries from filesystem");
        }
        if (file2.endsWith(".jar")) {
            return new JarredScript(resource2);
        }
        if (file2.endsWith(".class")) {
            return new JavaCompiledScript(resource2);
        }
        return new ExternalScript(resource2, file2);
    }

    private LoadServiceResource tryResourceFromCWD(SearchState state, String baseName, SuffixType suffixType) throws RaiseException {
        LoadServiceResource foundResource = null;
        for (String suffix : suffixType.getSuffixes()) {
            String namePlusSuffix = baseName + suffix;
            try {
                JRubyFile file2 = JRubyFile.create(this.runtime.getCurrentDirectory(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                if (!file2.isFile() || !file2.isAbsolute()) continue;
                try {
                    foundResource = new LoadServiceResource(file2.toURI().toURL(), namePlusSuffix);
                    state.loadName = namePlusSuffix;
                    break;
                }
                catch (MalformedURLException e) {
                    throw this.runtime.newIOErrorFromException(e);
                }
            }
            catch (IllegalArgumentException illArgEx) {
            }
            catch (SecurityException secEx) {
                // empty catch block
            }
        }
        return foundResource;
    }

    private LoadServiceResource tryResourceFromJarURL(SearchState state, String baseName, SuffixType suffixType) {
        LoadServiceResource foundResource;
        block10: {
            block11: {
                foundResource = null;
                if (!baseName.startsWith("jar:")) break block11;
                for (String suffix : suffixType.getSuffixes()) {
                    String namePlusSuffix = baseName + suffix;
                    try {
                        URL url = new URL(namePlusSuffix);
                        if (url.openStream() != null) {
                            foundResource = new LoadServiceResource(url, namePlusSuffix);
                        }
                    }
                    catch (FileNotFoundException e) {
                    }
                    catch (MalformedURLException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                    catch (IOException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                    if (foundResource == null) continue;
                    state.loadName = namePlusSuffix;
                    break block10;
                }
                break block10;
            }
            if (!baseName.startsWith("file:") || baseName.indexOf("!/") == -1) break block10;
            for (String suffix : suffixType.getSuffixes()) {
                String namePlusSuffix = baseName + suffix;
                try {
                    JarFile file2 = new JarFile(namePlusSuffix.substring(5, namePlusSuffix.indexOf("!/")));
                    String filename2 = namePlusSuffix.substring(namePlusSuffix.indexOf("!/") + 2);
                    if (file2.getJarEntry(filename2) != null) {
                        foundResource = new LoadServiceResource(new URL("jar:" + namePlusSuffix), namePlusSuffix);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (foundResource == null) continue;
                state.loadName = namePlusSuffix;
                break;
            }
        }
        return foundResource;
    }

    private LoadServiceResource tryResourceFromLoadPathOrURL(SearchState state, String baseName, SuffixType suffixType) {
        LoadServiceResource foundResource = null;
        if (baseName.startsWith("./") && (foundResource = this.tryResourceFromCWD(state, baseName, suffixType)) != null) {
            state.loadName = foundResource.getName();
            return foundResource;
        }
        if (new File(baseName).isAbsolute()) {
            for (String suffix : suffixType.getSuffixes()) {
                String namePlusSuffix = baseName + suffix;
                foundResource = this.tryResourceAsIs(namePlusSuffix);
                if (foundResource == null) continue;
                state.loadName = namePlusSuffix;
                return foundResource;
            }
            return null;
        }
        Iterator pathIter = this.loadPath.getList().iterator();
        block1: while (pathIter.hasNext()) {
            String loadPathEntry = ((IRubyObject)pathIter.next()).toString();
            if (loadPathEntry.equals(".")) {
                foundResource = this.tryResourceFromCWD(state, baseName, suffixType);
                if (foundResource == null) continue;
                state.loadName = foundResource.getName();
                break;
            }
            for (String suffix : suffixType.getSuffixes()) {
                String namePlusSuffix = baseName + suffix;
                foundResource = this.loadPathLooksLikeJarURL(loadPathEntry) ? this.tryResourceFromJarURLWithLoadPath(namePlusSuffix, loadPathEntry) : this.tryResourceFromLoadPath(namePlusSuffix, loadPathEntry);
                if (foundResource == null) continue;
                state.loadName = namePlusSuffix;
                break block1;
            }
        }
        return foundResource;
    }

    private LoadServiceResource tryResourceFromJarURLWithLoadPath(String namePlusSuffix, String loadPathEntry) {
        String before;
        LoadServiceResource foundResource = null;
        JarFile current2 = this.jarFiles.get(loadPathEntry);
        boolean isFileJarUrl = loadPathEntry.startsWith("file:") && loadPathEntry.indexOf("!/") != -1;
        String after = isFileJarUrl ? loadPathEntry.substring(loadPathEntry.indexOf("!/") + 2) + "/" : "";
        String string2 = before = isFileJarUrl ? loadPathEntry.substring(0, loadPathEntry.indexOf("!/")) : loadPathEntry;
        if (null == current2) {
            try {
                current2 = loadPathEntry.startsWith("jar:") ? new JarFile(loadPathEntry.substring(4)) : (loadPathEntry.endsWith(".jar") ? new JarFile(loadPathEntry) : new JarFile(loadPathEntry.substring(5, loadPathEntry.indexOf("!/"))));
                this.jarFiles.put(loadPathEntry, current2);
            }
            catch (ZipException ignored) {
                if (this.runtime.getInstanceConfig().isVerbose()) {
                    this.runtime.getErr().println("ZipException trying to access " + loadPathEntry + ", stack trace follows:");
                    ignored.printStackTrace(this.runtime.getErr());
                }
            }
            catch (FileNotFoundException ignored) {
            }
            catch (IOException e) {
                throw this.runtime.newIOErrorFromException(e);
            }
        }
        String canonicalEntry = after + namePlusSuffix;
        if (after.length() > 0) {
            try {
                canonicalEntry = new File(after + namePlusSuffix).getCanonicalPath().substring(new File(".").getCanonicalPath().length() + 1).replaceAll("\\\\", "/");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (current2 != null && current2.getJarEntry(canonicalEntry) != null) {
            try {
                foundResource = loadPathEntry.endsWith(".jar") ? new LoadServiceResource(new URL("jar:file:" + loadPathEntry + "!/" + canonicalEntry), "/" + namePlusSuffix) : (loadPathEntry.startsWith("file:") ? new LoadServiceResource(new URL("jar:" + before + "!/" + canonicalEntry), loadPathEntry + "/" + namePlusSuffix) : new LoadServiceResource(new URL("jar:file:" + loadPathEntry.substring(4) + "!/" + namePlusSuffix), loadPathEntry + namePlusSuffix));
            }
            catch (MalformedURLException e) {
                throw this.runtime.newIOErrorFromException(e);
            }
        }
        return foundResource;
    }

    private boolean loadPathLooksLikeJarURL(String loadPathEntry) {
        return loadPathEntry.startsWith("jar:") || loadPathEntry.endsWith(".jar") || loadPathEntry.startsWith("file:") && loadPathEntry.indexOf("!/") != -1;
    }

    private LoadServiceResource tryResourceFromLoadPath(String namePlusSuffix, String loadPathEntry) throws RaiseException {
        LoadServiceResource foundResource;
        block7: {
            foundResource = null;
            try {
                JRubyFile actualPath;
                if (Ruby.isSecurityRestricted()) break block7;
                String reportedPath = loadPathEntry + "/" + namePlusSuffix;
                if (new File(reportedPath).isAbsolute()) {
                    actualPath = JRubyFile.create(loadPathEntry, RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                } else {
                    if (reportedPath.charAt(0) != '.') {
                        reportedPath = "./" + reportedPath;
                    }
                    actualPath = JRubyFile.create(JRubyFile.create(this.runtime.getCurrentDirectory(), loadPathEntry).getAbsolutePath(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                }
                if (!actualPath.isFile()) break block7;
                try {
                    foundResource = new LoadServiceResource(actualPath.toURI().toURL(), reportedPath);
                }
                catch (MalformedURLException e) {
                    throw this.runtime.newIOErrorFromException(e);
                }
            }
            catch (SecurityException secEx) {
                // empty catch block
            }
        }
        return foundResource;
    }

    private LoadServiceResource tryResourceAsIs(String namePlusSuffix) throws RaiseException {
        LoadServiceResource foundResource;
        block7: {
            foundResource = null;
            try {
                File actualPath;
                if (Ruby.isSecurityRestricted()) break block7;
                String reportedPath = namePlusSuffix;
                if (new File(reportedPath).isAbsolute()) {
                    actualPath = new File(RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                } else {
                    if (reportedPath.charAt(0) == '.' && reportedPath.charAt(1) == '/') {
                        reportedPath = reportedPath.replaceFirst("\\./", this.runtime.getCurrentDirectory());
                    }
                    actualPath = new File(RubyFile.expandUserPath(this.runtime.getCurrentContext(), reportedPath));
                }
                if (!actualPath.isFile()) break block7;
                try {
                    foundResource = new LoadServiceResource(actualPath.toURI().toURL(), reportedPath);
                }
                catch (MalformedURLException e) {
                    throw this.runtime.newIOErrorFromException(e);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return foundResource;
    }

    private LoadServiceResource findFileInClasspath(String name2) {
        ClassLoader classLoader = this.runtime.getJRubyClassLoader();
        if (Ruby.isSecurityRestricted() && classLoader == null) {
            classLoader = this.runtime.getInstanceConfig().getLoader();
        }
        Iterator pathIter = this.loadPath.getList().iterator();
        while (pathIter.hasNext()) {
            URL loc;
            String entry = pathIter.next().toString();
            if (entry.charAt(0) == '/' || entry.length() > 1 && entry.charAt(1) == ':' || !this.isRequireable(loc = classLoader.getResource(entry + "/" + name2))) continue;
            return new LoadServiceResource(loc, loc.getPath());
        }
        if (name2.charAt(0) == '/' || name2.length() > 1 && name2.charAt(1) == ':') {
            return null;
        }
        URL loc = classLoader.getResource(name2);
        return this.isRequireable(loc) ? new LoadServiceResource(loc, loc.getPath()) : null;
    }

    private boolean isRequireable(URL loc) {
        if (loc != null) {
            if (loc.getProtocol().equals("file") && new File(loc.getFile()).isDirectory()) {
                return false;
            }
            try {
                loc.openConnection();
                return true;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return false;
    }

    public class SearchState {
        public Library library;
        public String loadName;
        public SuffixType suffixType;
        public String searchFile;

        public SearchState(String file2) {
            this.loadName = file2;
        }

        public void prepareRequireSearch(String file2) {
            if (file2.lastIndexOf(46) > file2.lastIndexOf(47)) {
                Matcher matcher = null;
                matcher = sourcePattern.matcher(file2);
                if (matcher.find()) {
                    this.suffixType = SuffixType.Source;
                    this.searchFile = file2.substring(0, matcher.start());
                } else {
                    matcher = extensionPattern.matcher(file2);
                    if (matcher.find()) {
                        this.suffixType = SuffixType.Extension;
                        this.searchFile = file2.substring(0, matcher.start());
                    } else {
                        this.suffixType = SuffixType.Both;
                        this.searchFile = file2;
                    }
                }
            } else {
                this.suffixType = SuffixType.Both;
                this.searchFile = file2;
            }
        }

        public void prepareLoadSearch(String file2) {
            if (file2.lastIndexOf(46) > file2.lastIndexOf(47)) {
                Matcher matcher = null;
                matcher = sourcePattern.matcher(file2);
                if (matcher.find()) {
                    this.suffixType = SuffixType.Source;
                    this.searchFile = file2.substring(0, matcher.start());
                } else {
                    this.suffixType = SuffixType.Neither;
                    this.searchFile = file2;
                }
            } else {
                this.suffixType = SuffixType.Neither;
                this.searchFile = file2;
            }
        }
    }

    public class ScriptClassSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state) {
            return state.library == null;
        }

        public void trySearch(SearchState state) throws RaiseException {
            Script script;
            String className = LoadService.this.buildClassName(state.searchFile);
            int lastSlashIndex = className.lastIndexOf(47);
            if (lastSlashIndex > -1 && lastSlashIndex < className.length() - 1 && !Character.isJavaIdentifierStart(className.charAt(lastSlashIndex + 1))) {
                className = lastSlashIndex == -1 ? "_" + className : className.substring(0, lastSlashIndex + 1) + "_" + className.substring(lastSlashIndex + 1);
            }
            className = className.replace('/', '.');
            try {
                Class<?> scriptClass = Class.forName(className);
                script = (Script)scriptClass.newInstance();
            }
            catch (Exception cnfe) {
                throw LoadService.this.runtime.newLoadError("no such file to load -- " + state.searchFile);
            }
            state.library = new ScriptClassLibrary(script);
        }

        public class ScriptClassLibrary
        implements Library {
            private Script script;

            public ScriptClassLibrary(Script script) {
                this.script = script;
            }

            public void load(Ruby runtime2, boolean wrap2) {
                runtime2.loadScript(this.script);
            }
        }
    }

    public class ExtensionSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state) {
            return (state.library == null || state.library instanceof JarredScript) && !state.searchFile.equalsIgnoreCase("");
        }

        public void trySearch(SearchState state) {
            Library oldLibrary = state.library;
            String[] all = state.searchFile.split("/");
            StringBuilder finName = new StringBuilder();
            int j = all.length - 1;
            for (int i = 0; i < j; ++i) {
                finName.append(all[i].toLowerCase()).append(".");
            }
            try {
                String[] last2 = all[all.length - 1].split("_");
                int j2 = last2.length;
                for (int i = 0; i < j2; ++i) {
                    finName.append(Character.toUpperCase(last2[i].charAt(0))).append(last2[i].substring(1));
                }
                finName.append("Service");
                String className = finName.toString().replaceAll("^\\.*", "");
                if (state.library instanceof JarredScript) {
                    LoadService.this.runtime.getJRubyClassLoader().addURL(((JarredScript)state.library).getResource().getURL());
                }
                Class theClass = LoadService.this.runtime.getJavaSupport().loadJavaClassQuiet(className);
                state.library = new ClassExtensionLibrary(theClass);
            }
            catch (Exception ee) {
                state.library = null;
                LoadService.this.runtime.getGlobalVariables().set("$!", LoadService.this.runtime.getNil());
            }
            if (state.library == null && oldLibrary != null) {
                state.library = oldLibrary;
            }
        }
    }

    public class ClassLoaderSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state) {
            return state.library == null;
        }

        public void trySearch(SearchState state) {
            state.library = LoadService.this.findLibraryWithClassloaders(state, state.searchFile, state.suffixType);
        }
    }

    public class NormalSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state) {
            return state.library == null;
        }

        public void trySearch(SearchState state) {
            state.library = LoadService.this.findLibraryWithoutCWD(state, state.searchFile, state.suffixType);
        }
    }

    public class BailoutSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state) {
            return true;
        }

        public void trySearch(SearchState state) throws AlreadyLoaded {
            for (String suffix : state.suffixType.getSuffixes()) {
                String searchName = state.searchFile + suffix;
                RubyString searchNameString = RubyString.newString(LoadService.this.runtime, searchName);
                if (!LoadService.this.featureAlreadyLoaded(searchNameString)) continue;
                throw new AlreadyLoaded(searchNameString);
            }
        }
    }

    public class AlreadyLoaded
    extends Exception {
        private RubyString searchNameString;

        public AlreadyLoaded(RubyString searchNameString) {
            this.searchNameString = searchNameString;
        }

        public RubyString getSearchNameString() {
            return this.searchNameString;
        }
    }

    public static interface LoadSearcher {
        public boolean shouldTrySearch(SearchState var1);

        public void trySearch(SearchState var1) throws AlreadyLoaded;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SuffixType {
        Source,
        Extension,
        Both,
        Neither;

        public static final String[] sourceSuffixes;
        public static final String[] extensionSuffixes;
        private static final String[] allSuffixes;
        private static final String[] emptySuffixes;

        public String[] getSuffixes() {
            switch (this) {
                case Source: {
                    return sourceSuffixes;
                }
                case Extension: {
                    return extensionSuffixes;
                }
                case Both: {
                    return allSuffixes;
                }
                case Neither: {
                    return emptySuffixes;
                }
            }
            throw new RuntimeException("Unknown SuffixType: " + (Object)((Object)this));
        }

        static {
            sourceSuffixes = new String[]{".class", ".rb"};
            extensionSuffixes = new String[]{".so", ".jar"};
            allSuffixes = new String[]{".class", ".rb", ".so", ".jar"};
            emptySuffixes = new String[]{""};
        }
    }
}

