/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.struct;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.ParameterFlags;
import com.kenai.jaffl.Type;
import com.kenai.jaffl.struct.Constants;
import com.kenai.jaffl.util.EnumMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Struct {
    final Info __info = new Info();

    protected Struct() {
    }

    Struct(boolean isUnion) {
        this.__info.resetIndex = isUnion;
    }

    public void useMemory(MemoryIO address2) {
        this.__info.useMemory(address2);
    }

    public void useMemory(com.kenai.jaffl.Pointer address2) {
        this.__info.useMemory(MemoryIO.wrap(address2));
    }

    public java.lang.String toString() {
        StringBuilder sb = new StringBuilder();
        Field[] fields2 = this.getClass().getDeclaredFields();
        sb.append(this.getClass().getSimpleName() + " { \n");
        java.lang.String fieldPrefix = "    ";
        for (Field field2 : fields2) {
            try {
                sb.append("    ");
                sb.append(field2.getName()).append(" = ");
                sb.append(field2.get(this).toString());
                sb.append("\n");
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    protected final void arrayBegin() {
        this.__info.resetIndex = false;
    }

    protected final void arrayEnd() {
        this.__info.resetIndex = this.__info.isUnion;
    }

    protected <T extends Member> T[] array(T[] array) {
        this.arrayBegin();
        try {
            Class<?> arrayClass = array.getClass().getComponentType();
            Constructor<?> ctor = arrayClass.getDeclaredConstructor(arrayClass.getEnclosingClass());
            Object[] parameters2 = new Object[]{this};
            for (int i2 = 0; i2 < array.length; ++i2) {
                array[i2] = (Member)ctor.newInstance(parameters2);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed8[] array(Signed8[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new Signed8();
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned8[] array(Unsigned8[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new Unsigned8();
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed16[] array(Signed16[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new Signed16();
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned16[] array(Unsigned16[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new Unsigned16();
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed32[] array(Signed32[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new Signed32();
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned32[] array(Unsigned32[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new Unsigned32();
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed64[] array(Signed64[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new Signed64();
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned64[] array(Unsigned64[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new Unsigned64();
        }
        this.arrayEnd();
        return array;
    }

    protected final SignedLong[] array(SignedLong[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new SignedLong();
        }
        this.arrayEnd();
        return array;
    }

    protected final UnsignedLong[] array(UnsignedLong[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new UnsignedLong();
        }
        this.arrayEnd();
        return array;
    }

    protected final Float[] array(Float[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new Float();
        }
        this.arrayEnd();
        return array;
    }

    protected final Double[] array(Double[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new Double();
        }
        this.arrayEnd();
        return array;
    }

    protected final Address[] array(Address[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new Address();
        }
        this.arrayEnd();
        return array;
    }

    protected final Pointer[] array(Pointer[] array) {
        this.arrayBegin();
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = new Pointer();
        }
        this.arrayEnd();
        return array;
    }

    protected final <T extends Struct> T inner(Struct struct) {
        int salign = struct.__info.getMinimumAlignment();
        int off = salign + (this.__info.size - 1 & ~(salign - 1));
        struct.__info.enclosing = this;
        struct.__info.offset = off;
        this.__info.size = off + struct.__info.size;
        return (T)struct;
    }

    public final class Padding
    extends AbstractMember {
        public Padding(Type type2, int length2) {
            super(type2.size() * 8 * length2, type2.alignment() * 8);
        }
    }

    public class AsciiStringRef
    extends UTFStringRef {
        public AsciiStringRef(int size2) {
            super(size2, Charset.forName("ASCII"));
        }

        public AsciiStringRef() {
            super(Integer.MAX_VALUE, Charset.forName("ASCII"));
        }
    }

    public class UTF8StringRef
    extends UTFStringRef {
        public UTF8StringRef(int size2) {
            super(size2, Charset.forName("UTF-8"));
        }

        public UTF8StringRef() {
            super(Integer.MAX_VALUE, Charset.forName("UTF-8"));
        }
    }

    public class UTFStringRef
    extends String {
        public UTFStringRef(int length2, Charset cs) {
            super(Constants.ADDRESS_SIZE, Constants.ADDRESS_SIZE, length2, cs);
        }

        public UTFStringRef(Charset cs) {
            this(Integer.MAX_VALUE, cs);
        }

        protected MemoryIO getStringMemory() {
            return this.getMemoryIO().getMemoryIO(this.offset(), this.length());
        }
    }

    public class AsciiString
    extends UTFString {
        public AsciiString(int size2) {
            super(size2, Charset.forName("ASCII"));
        }
    }

    public class UTF8String
    extends UTFString {
        public UTF8String(int size2) {
            super(size2, Charset.forName("UTF-8"));
        }
    }

    public class UTFString
    extends String {
        public UTFString(int length2, Charset cs) {
            super(length2 * 8, 8, length2, cs);
        }

        protected MemoryIO getStringMemory() {
            return this.getMemoryIO().slice(this.offset(), this.length());
        }
    }

    public abstract class String
    extends AbstractMember {
        private final Charset charset;
        private final int length;

        protected String(int size2, int align, int length2, Charset cs) {
            super(size2, align);
            this.length = length2;
            this.charset = cs;
        }

        protected String(int size2, int align, Offset offset2, int length2, Charset cs) {
            super(size2, align, offset2);
            this.length = length2;
            this.charset = cs;
        }

        public final int length() {
            return this.length;
        }

        protected abstract MemoryIO getStringMemory();

        public final java.lang.String get() {
            return this.getStringMemory().getString(0L, this.length, this.charset);
        }

        public final void set(java.lang.String value2) {
            this.getStringMemory().putString(0L, value2, this.length, this.charset);
        }

        public final java.lang.String toString() {
            return this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum<T extends java.lang.Enum<T>>
    extends Enum32<T> {
        public Enum(Class<T> enumClass) {
            super(enumClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EnumLong<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public EnumLong(Class<E> enumClass) {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN, enumClass);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E value2) {
            this.getMemoryIO().putNativeLong(this.offset(), EnumMapper.getInstance().intValue((java.lang.Enum)value2));
        }

        @Override
        public void set(Number value2) {
            this.getMemoryIO().putNativeLong(this.offset(), value2.longValue());
        }

        @Override
        public final int intValue() {
            return (int)this.longValue();
        }

        @Override
        public final long longValue() {
            return this.getMemoryIO().getNativeLong(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum64<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum64(Class<E> enumClass) {
            super(64, Constants.INT64_ALIGN, enumClass);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E value2) {
            this.getMemoryIO().putLong(this.offset(), EnumMapper.getInstance().intValue((java.lang.Enum)value2));
        }

        @Override
        public void set(Number value2) {
            this.getMemoryIO().putLong(this.offset(), value2.longValue());
        }

        @Override
        public final int intValue() {
            return (int)this.longValue();
        }

        @Override
        public final long longValue() {
            return this.getMemoryIO().getLong(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum32<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum32(Class<E> enumClass) {
            super(32, enumClass);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E value2) {
            this.getMemoryIO().putInt(this.offset(), EnumMapper.getInstance().intValue((java.lang.Enum)value2));
        }

        @Override
        public void set(Number value2) {
            this.getMemoryIO().putInt(this.offset(), value2.intValue());
        }

        @Override
        public final int intValue() {
            return this.getMemoryIO().getInt(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum16<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum16(Class<E> enumClass) {
            super(16, enumClass);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E value2) {
            this.getMemoryIO().putShort(this.offset(), (short)EnumMapper.getInstance().intValue((java.lang.Enum)value2));
        }

        @Override
        public void set(Number value2) {
            this.getMemoryIO().putShort(this.offset(), value2.shortValue());
        }

        @Override
        public final int intValue() {
            return this.getMemoryIO().getShort(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum8<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum8(Class<E> enumClass) {
            super(8, enumClass);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E value2) {
            this.getMemoryIO().putByte(this.offset(), (byte)EnumMapper.getInstance().intValue((java.lang.Enum)value2));
        }

        @Override
        public void set(Number value2) {
            this.getMemoryIO().putByte(this.offset(), value2.byteValue());
        }

        @Override
        public final int intValue() {
            return this.getMemoryIO().getByte(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class EnumField<E>
    extends NumberField {
        protected final Class<E> enumClass;

        public EnumField(int size2, Class<E> enumClass) {
            this(size2, size2, enumClass);
        }

        public EnumField(int size2, Offset offset2, Class<E> enumClass) {
            this(size2, size2, offset2, enumClass);
        }

        public EnumField(int size2, int align, Class<E> enumClass) {
            super(size2, align);
            this.enumClass = enumClass;
        }

        public EnumField(int size2, int align, Offset offset2, Class<E> enumClass) {
            super(size2, align, offset2);
            this.enumClass = enumClass;
        }

        public abstract E get();

        @Override
        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public class Pointer
    extends NumberField {
        public Pointer() {
            super(Constants.ADDRESS_SIZE);
        }

        public Pointer(Offset offset2) {
            super(Constants.ADDRESS_SIZE, offset2);
        }

        public final com.kenai.jaffl.Pointer get() {
            return this.getMemoryIO().getPointer(this.offset());
        }

        public final int size() {
            return com.kenai.jaffl.Address.SIZE;
        }

        public final void set(com.kenai.jaffl.Pointer value2) {
            this.getMemoryIO().putPointer(this.offset(), value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putAddress(this.offset(), value2.longValue());
        }

        public final int intValue() {
            return (int)this.getMemoryIO().getAddress(this.offset());
        }

        public final long longValue() {
            return this.getMemoryIO().getAddress(this.offset());
        }

        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public class Address
    extends NumberField {
        public Address() {
            super(Constants.ADDRESS_SIZE);
        }

        public Address(Offset offset2) {
            super(Constants.ADDRESS_SIZE, offset2);
        }

        public final com.kenai.jaffl.Address get() {
            long value2 = this.getMemoryIO().getAddress(this.offset());
            return value2 != 0L ? new com.kenai.jaffl.Address(value2) : null;
        }

        public final void set(com.kenai.jaffl.Address value2) {
            this.getMemoryIO().putAddress(this.offset(), value2 != null ? value2.nativeAddress() : 0L);
        }

        public void set(Number value2) {
            this.getMemoryIO().putAddress(this.offset(), value2.longValue());
        }

        public final int intValue() {
            return this.get().intValue();
        }

        public final long longValue() {
            return this.get().longValue();
        }

        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public final class Double
    extends NumberField {
        public Double() {
            super(64, Constants.DOUBLE_ALIGN);
        }

        public Double(Offset offset2) {
            super(64, Constants.DOUBLE_ALIGN, offset2);
        }

        public final double get() {
            return this.getMemoryIO().getDouble(this.offset());
        }

        public final void set(double value2) {
            this.getMemoryIO().putDouble(this.offset(), value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putDouble(this.offset(), value2.doubleValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return (long)this.get();
        }

        public final float floatValue() {
            return (float)this.get();
        }

        public final double doubleValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return java.lang.String.valueOf(this.get());
        }
    }

    public class Float
    extends NumberField {
        public Float() {
            super(32, Constants.FLOAT_ALIGN);
        }

        public Float(Offset offset2) {
            super(32, Constants.FLOAT_ALIGN, offset2);
        }

        public final float get() {
            return this.getMemoryIO().getFloat(this.offset());
        }

        public final void set(float value2) {
            this.getMemoryIO().putFloat(this.offset(), value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putFloat(this.offset(), value2.floatValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final double doubleValue() {
            return this.get();
        }

        public final float floatValue() {
            return this.get();
        }

        public final long longValue() {
            return (long)this.get();
        }

        public final java.lang.String toString() {
            return java.lang.String.valueOf(this.get());
        }
    }

    public class UnsignedLong
    extends NumberField {
        public UnsignedLong() {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN);
        }

        public UnsignedLong(Offset offset2) {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN, offset2);
        }

        public final long get() {
            long value2 = this.getMemoryIO().getNativeLong(this.offset());
            return value2 < 0L ? (value2 & Constants.LONG_MASK) + Constants.LONG_MASK + 1L : value2;
        }

        public final void set(long value2) {
            this.getMemoryIO().putNativeLong(this.offset(), value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putNativeLong(this.offset(), value2.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class SignedLong
    extends NumberField {
        public SignedLong() {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN);
        }

        public SignedLong(Offset offset2) {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN, offset2);
        }

        public final long get() {
            return this.getMemoryIO().getNativeLong(this.offset());
        }

        public final void set(long value2) {
            this.getMemoryIO().putNativeLong(this.offset(), value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putNativeLong(this.offset(), value2.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Unsigned64
    extends NumberField {
        public Unsigned64() {
            super(64, Constants.INT64_ALIGN);
        }

        public Unsigned64(Offset offset2) {
            super(64, Constants.INT64_ALIGN, offset2);
        }

        public final long get() {
            return this.getMemoryIO().getLong(this.offset());
        }

        public final void set(long value2) {
            this.getMemoryIO().putLong(this.offset(), value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putLong(this.offset(), value2.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Signed64
    extends NumberField {
        public Signed64() {
            super(64, Constants.INT64_ALIGN);
        }

        public Signed64(Offset offset2) {
            super(64, Constants.INT64_ALIGN, offset2);
        }

        public final long get() {
            return this.getMemoryIO().getLong(this.offset());
        }

        public final void set(long value2) {
            this.getMemoryIO().putLong(this.offset(), value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putLong(this.offset(), value2.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Unsigned32
    extends NumberField {
        public Unsigned32() {
            super(32);
        }

        public Unsigned32(Offset offset2) {
            super(32, offset2);
        }

        public final long get() {
            long value2 = this.getMemoryIO().getInt(this.offset());
            return value2 < 0L ? (value2 & Integer.MAX_VALUE) + 0x80000000L : value2;
        }

        public final void set(long value2) {
            this.getMemoryIO().putInt(this.offset(), (int)value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putInt(this.offset(), value2.intValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }
    }

    public class Signed32
    extends NumberField {
        public Signed32() {
            super(32);
        }

        public Signed32(Offset offset2) {
            super(32, offset2);
        }

        public final int get() {
            return this.getMemoryIO().getInt(this.offset());
        }

        public final void set(int value2) {
            this.getMemoryIO().putInt(this.offset(), value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putInt(this.offset(), value2.intValue());
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Unsigned16
    extends NumberField {
        public Unsigned16() {
            super(16);
        }

        public Unsigned16(Offset offset2) {
            super(16, offset2);
        }

        public final int get() {
            int value2 = this.getMemoryIO().getShort(this.offset());
            return value2 < 0 ? (value2 & Short.MAX_VALUE) + 32768 : value2;
        }

        public final void set(int value2) {
            this.getMemoryIO().putShort(this.offset(), (short)value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putShort(this.offset(), value2.shortValue());
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Signed16
    extends NumberField {
        public Signed16() {
            super(16);
        }

        public Signed16(Offset offset2) {
            super(16, offset2);
        }

        public final short get() {
            return this.getMemoryIO().getShort(this.offset());
        }

        public final void set(short value2) {
            this.getMemoryIO().putShort(this.offset(), value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putShort(this.offset(), value2.shortValue());
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Unsigned8
    extends NumberField {
        public Unsigned8() {
            super(8);
        }

        public Unsigned8(Offset offset2) {
            super(8, offset2);
        }

        public final short get() {
            short value2 = this.getMemoryIO().getByte(this.offset());
            return value2 < 0 ? (short)((value2 & 0x7F) + 128) : value2;
        }

        public final void set(short value2) {
            this.getMemoryIO().putByte(this.offset(), (byte)value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putByte(this.offset(), value2.byteValue());
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Signed8
    extends NumberField {
        public Signed8() {
            super(8);
        }

        public Signed8(Offset offset2) {
            super(8, offset2);
        }

        public final byte get() {
            return this.getMemoryIO().getByte(this.offset());
        }

        public final void set(byte value2) {
            this.getMemoryIO().putByte(this.offset(), value2);
        }

        public void set(Number value2) {
            this.getMemoryIO().putByte(this.offset(), value2.byteValue());
        }

        public final byte byteValue() {
            return this.get();
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    protected abstract class NumberField
    extends Number
    implements Member {
        private final int offset;

        protected NumberField(int size2) {
            this(size2, size2);
        }

        protected NumberField(int size2, Offset offset2) {
            this(size2, size2, offset2);
        }

        protected NumberField(int size2, int align, Offset offset2) {
            this.offset = Struct.this.__info.addField(size2, align, offset2);
        }

        protected NumberField(int size2, int align) {
            this.offset = Struct.this.__info.addField(size2, align);
        }

        public final MemoryIO getMemoryIO() {
            return Struct.this.__info.getMemoryIO();
        }

        public final Struct struct() {
            return Struct.this;
        }

        public final long offset() {
            return this.offset + Struct.this.__info.offset;
        }

        public abstract void set(Number var1);

        public double doubleValue() {
            return this.longValue();
        }

        public float floatValue() {
            return this.intValue();
        }

        public long longValue() {
            return this.intValue();
        }

        public java.lang.String toString() {
            return Integer.toString(this.intValue(), 10);
        }
    }

    public final class WBOOL
    extends AbstractBoolean {
        public WBOOL() {
            super(Type.SINT);
        }

        public final boolean get() {
            return (this.getMemoryIO().getInt(this.offset()) & 1) != 0;
        }

        public final void set(boolean value2) {
            this.getMemoryIO().putInt(this.offset(), value2 ? 1 : 0);
        }
    }

    public final class Boolean
    extends AbstractBoolean {
        public Boolean() {
            super(Type.SCHAR);
        }

        public final boolean get() {
            return (this.getMemoryIO().getByte(this.offset()) & 1) != 0;
        }

        public final void set(boolean value2) {
            this.getMemoryIO().putByte(this.offset(), (byte)(value2 ? 1 : 0));
        }
    }

    public abstract class AbstractBoolean
    extends AbstractMember {
        public AbstractBoolean(Type type2) {
            super(type2);
        }

        protected AbstractBoolean(Type type2, Offset offset2) {
            super(type2, offset2);
        }

        public abstract boolean get();

        public abstract void set(boolean var1);

        public java.lang.String toString() {
            return java.lang.Boolean.toString(this.get());
        }
    }

    public abstract class AbstractMember
    implements Member {
        private final int offset;

        protected AbstractMember(int size2) {
            this(size2, size2);
        }

        protected AbstractMember(int size2, int align, Offset offset2) {
            this.offset = Struct.this.__info.addField(size2, align, offset2);
        }

        protected AbstractMember(int size2, int align) {
            this.offset = Struct.this.__info.addField(size2, align);
        }

        protected AbstractMember(Type type2) {
            this.offset = Struct.this.__info.addField(type2.size() * 8, type2.alignment() * 8);
        }

        protected AbstractMember(Type type2, Offset offset2) {
            this.offset = Struct.this.__info.addField(type2.size() * 8, type2.alignment() * 8, offset2);
        }

        public final MemoryIO getMemoryIO() {
            return Struct.this.__info.getMemoryIO();
        }

        public final Struct struct() {
            return Struct.this;
        }

        public final long offset() {
            return this.offset + Struct.this.__info.offset;
        }
    }

    protected static interface Member {
        public Struct struct();

        public MemoryIO getMemoryIO();

        public long offset();
    }

    public static final class Offset
    extends Number {
        private final int offset;

        public Offset(int offset2) {
            this.offset = offset2;
        }

        public int intValue() {
            return this.offset;
        }

        public long longValue() {
            return this.offset;
        }

        public float floatValue() {
            return this.offset;
        }

        public double doubleValue() {
            return this.offset;
        }
    }

    static final class Info {
        Struct enclosing = null;
        int offset = 0;
        MemoryIO io;
        int size = 0;
        int minAlign = 1;
        boolean isUnion = false;
        boolean resetIndex = false;

        Info() {
        }

        public final MemoryIO getMemoryIO(int flags) {
            return this.enclosing != null ? this.enclosing.__info.getMemoryIO(flags) : (this.io != null ? this.io : (this.io = this.allocateMemory(flags)));
        }

        public final MemoryIO getMemoryIO() {
            return this.getMemoryIO(16);
        }

        final boolean isDirect() {
            return this.enclosing != null && this.enclosing.__info.isDirect() || this.io != null && this.io.isDirect();
        }

        final int size() {
            return this.size;
        }

        final int getMinimumAlignment() {
            return this.minAlign;
        }

        private final MemoryIO allocateMemory(int flags) {
            if (ParameterFlags.isDirect(flags)) {
                return MemoryIO.allocateDirect(this.size(), true);
            }
            return MemoryIO.allocate(this.size());
        }

        public final void useMemory(MemoryIO io2) {
            this.io = io2;
        }

        protected final int addField(int sizeBits, int alignBits, Offset offset2) {
            this.size = Math.max(this.size, offset2.intValue() + (sizeBits >> 3));
            this.minAlign = Math.max(this.minAlign, alignBits >> 3);
            return offset2.intValue();
        }

        protected final int addField(int sizeBits, int alignBits) {
            int off;
            int mask = (alignBits >> 3) - 1;
            int n = off = this.resetIndex ? 0 : this.size;
            if ((off & mask) != 0) {
                off = (off & ~mask) + (alignBits >> 3);
            }
            this.size = Math.max(this.size, off + (sizeBits >> 3));
            this.minAlign = Math.max(this.minAlign, alignBits >> 3);
            return off;
        }
    }
}

