/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteOrder;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafePropertyAccessor;

public class Platform {
    public static final CPU_TYPE CPU = Platform.determineCPU();
    public static final OS_TYPE OS = Platform.determineOS();
    public static final String NAME = (Object)((Object)CPU) + "-" + (Object)((Object)OS);
    public static final String LIBPREFIX = OS == OS_TYPE.WINDOWS ? "" : "lib";
    public static final String LIBSUFFIX = Platform.determineLibExt();
    public static final String LIBC = Platform.determineLibC();
    public static final int BIG_ENDIAN = 4321;
    public static final int LITTLE_ENDIAN = 1234;
    public static final int BYTE_ORDER = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 4321 : 1234;
    protected final int addressSize;
    protected final int longSize;
    private final long addressMask;
    protected final Pattern libPattern;
    private final int javaVersionMajor;

    private static final OS_TYPE determineOS() {
        String osName = System.getProperty("os.name").split(" ")[0].toLowerCase();
        if (osName.startsWith("mac") || osName.startsWith("darwin") || osName.equalsIgnoreCase("darwin")) {
            return OS_TYPE.DARWIN;
        }
        if (osName.startsWith("sunos") || osName.startsWith("solaris")) {
            return OS_TYPE.SOLARIS;
        }
        for (OS_TYPE os : OS.values()) {
            if (!osName.startsWith(os.toString().toLowerCase())) continue;
            return os;
        }
        return OS_TYPE.UNKNOWN;
    }

    private static final Platform determinePlatform(OS_TYPE os) {
        switch (os) {
            case DARWIN: {
                return new Darwin();
            }
            case LINUX: {
                return new Linux();
            }
            case AIX: {
                return new AIX();
            }
            case WINDOWS: {
                return new Windows();
            }
            case UNKNOWN: {
                return new Unsupported(os);
            }
        }
        return new Default(os);
    }

    private static final CPU_TYPE determineCPU() {
        String archString = System.getProperty("os.arch").toLowerCase();
        if ("x86".equals(archString) || "i386".equals(archString) || "i86pc".equals(archString)) {
            return CPU_TYPE.I386;
        }
        if ("x86_64".equals(archString) || "amd64".equals(archString)) {
            return CPU_TYPE.X86_64;
        }
        if ("ppc".equals(archString) || "powerpc".equals(archString)) {
            return CPU_TYPE.POWERPC;
        }
        if ("ppc64".equals(archString)) {
            return CPU_TYPE.POWERPC64;
        }
        if ("sparc".equals(archString)) {
            return CPU_TYPE.SPARC;
        }
        if ("sparcv9".equals(archString)) {
            return CPU_TYPE.SPARCV9;
        }
        if ("s390x".equals(archString)) {
            return CPU_TYPE.S390X;
        }
        if ("universal".equals(archString)) {
            String bits = SafePropertyAccessor.getProperty("sun.arch.data.model");
            if ("32".equals(bits)) {
                System.setProperty("os.arch", "i386");
                return CPU_TYPE.I386;
            }
            if ("64".equals(bits)) {
                System.setProperty("os.arch", "x86_64");
                return CPU_TYPE.X86_64;
            }
        }
        return CPU_TYPE.UNKNOWN;
    }

    private static final String determineLibC() {
        switch (OS) {
            case WINDOWS: {
                return "msvcrt.dll";
            }
            case LINUX: {
                return "libc.so.6";
            }
            case AIX: {
                if (Integer.getInteger("sun.arch.data.model") == 32) {
                    return "libc.a(shr.o)";
                }
                return "libc.a(shr_64.o)";
            }
        }
        return LIBPREFIX + "c." + LIBSUFFIX;
    }

    private static final String determineLibExt() {
        switch (OS) {
            case WINDOWS: {
                return "dll";
            }
            case AIX: {
                return "a";
            }
            case DARWIN: {
                return "dylib";
            }
        }
        return "so";
    }

    protected Platform(OS_TYPE os) {
        int dataModel = Integer.getInteger("sun.arch.data.model");
        if (dataModel != 32 && dataModel != 64) {
            switch (CPU) {
                case I386: 
                case POWERPC: 
                case SPARC: {
                    dataModel = 32;
                    break;
                }
                case X86_64: 
                case POWERPC64: 
                case SPARCV9: 
                case S390X: {
                    dataModel = 64;
                    break;
                }
                default: {
                    dataModel = 0;
                }
            }
        }
        this.addressSize = dataModel;
        this.addressMask = this.addressSize == 32 ? 0xFFFFFFFFL : -1L;
        this.longSize = os == OS_TYPE.WINDOWS ? 32 : this.addressSize;
        String libpattern = null;
        switch (os) {
            case WINDOWS: {
                libpattern = ".*\\.dll$";
                break;
            }
            case DARWIN: {
                libpattern = "lib.*\\.(dylib|jnilib)$";
                break;
            }
            case AIX: {
                libpattern = "lib.*\\.a$";
                break;
            }
            default: {
                libpattern = "lib.*\\.so.*$";
            }
        }
        this.libPattern = Pattern.compile(libpattern);
        int version = 5;
        try {
            String versionString = System.getProperty("java.version");
            if (versionString != null) {
                String[] v = versionString.split("\\.");
                version = Integer.valueOf(v[1]);
            }
        }
        catch (Exception ex) {
            version = 0;
        }
        this.javaVersionMajor = version;
    }

    public static final Platform getPlatform() {
        return SingletonHolder.PLATFORM;
    }

    public final OS_TYPE getOS() {
        return OS;
    }

    public final CPU_TYPE getCPU() {
        return CPU;
    }

    public final int getJavaMajorVersion() {
        return this.javaVersionMajor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBSD() {
        if (OS == OS_TYPE.FREEBSD) return true;
        if (OS == OS_TYPE.OPENBSD) return true;
        if (OS == OS_TYPE.NETBSD) return true;
        if (OS != OS_TYPE.DARWIN) return false;
        return true;
    }

    public final boolean isUnix() {
        return OS != OS_TYPE.WINDOWS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSupported() {
        if (OS == OS_TYPE.UNKNOWN) return false;
        if (CPU == CPU_TYPE.UNKNOWN) return false;
        if (this.addressSize != 32) {
            if (this.addressSize != 64) return false;
        }
        if (this.javaVersionMajor < 5) return false;
        return true;
    }

    public static void createPlatformModule(Ruby runtime2, RubyModule ffi2) {
        RubyModule module = ffi2.defineModuleUnder("Platform");
        Platform platform = Platform.getPlatform();
        OS_TYPE os = platform.getOS();
        module.defineConstant("ADDRESS_SIZE", runtime2.newFixnum(platform.addressSize));
        module.defineConstant("LONG_SIZE", runtime2.newFixnum(platform.longSize));
        module.defineConstant("OS", runtime2.newString(OS.toString()));
        module.defineConstant("ARCH", runtime2.newString(platform.getCPU().toString()));
        module.defineConstant("NAME", runtime2.newString(platform.getName()));
        module.defineConstant("IS_WINDOWS", runtime2.newBoolean(os == OS_TYPE.WINDOWS));
        module.defineConstant("IS_BSD", runtime2.newBoolean(platform.isBSD()));
        module.defineConstant("IS_FREEBSD", runtime2.newBoolean(os == OS_TYPE.FREEBSD));
        module.defineConstant("IS_OPENBSD", runtime2.newBoolean(os == OS_TYPE.OPENBSD));
        module.defineConstant("IS_SOLARIS", runtime2.newBoolean(os == OS_TYPE.SOLARIS));
        module.defineConstant("IS_LINUX", runtime2.newBoolean(os == OS_TYPE.LINUX));
        module.defineConstant("IS_MAC", runtime2.newBoolean(os == OS_TYPE.DARWIN));
        module.defineConstant("LIBC", runtime2.newString(LIBC));
        module.defineConstant("LIBPREFIX", runtime2.newString(LIBPREFIX));
        module.defineConstant("LIBSUFFIX", runtime2.newString(LIBSUFFIX));
        module.defineConstant("BYTE_ORDER", runtime2.newFixnum(BYTE_ORDER));
        module.defineConstant("BIG_ENDIAN", runtime2.newFixnum(4321));
        module.defineConstant("LITTLE_ENDIAN", runtime2.newFixnum(1234));
        module.defineAnnotatedMethods(Platform.class);
    }

    @JRubyMethod(name={"windows?"}, module=true)
    public static IRubyObject windows_p(ThreadContext context, IRubyObject recv2) {
        return context.getRuntime().newBoolean(OS == OS_TYPE.WINDOWS);
    }

    @JRubyMethod(name={"mac?"}, module=true)
    public static IRubyObject mac_p(ThreadContext context, IRubyObject recv2) {
        return context.getRuntime().newBoolean(OS == OS_TYPE.DARWIN);
    }

    @JRubyMethod(name={"unix?"}, module=true)
    public static IRubyObject unix_p(ThreadContext context, IRubyObject recv2) {
        return context.getRuntime().newBoolean(Platform.getPlatform().isUnix());
    }

    @JRubyMethod(name={"bsd?"}, module=true)
    public static IRubyObject bsd_p(ThreadContext context, IRubyObject recv2) {
        return context.getRuntime().newBoolean(Platform.getPlatform().isBSD());
    }

    @JRubyMethod(name={"linux?"}, module=true)
    public static IRubyObject linux_p(ThreadContext context, IRubyObject recv2) {
        return context.getRuntime().newBoolean(OS == OS_TYPE.LINUX);
    }

    @JRubyMethod(name={"solaris?"}, module=true)
    public static IRubyObject solaris_p(ThreadContext context, IRubyObject recv2) {
        return context.getRuntime().newBoolean(OS == OS_TYPE.SOLARIS);
    }

    public static String getProperty(String property, String defValue) {
        try {
            return System.getProperty(property, defValue);
        }
        catch (SecurityException se) {
            return defValue;
        }
    }

    public final int longSize() {
        return this.longSize;
    }

    public final int addressSize() {
        return this.addressSize;
    }

    public final long addressMask() {
        return this.addressMask;
    }

    public String getName() {
        return (Object)((Object)CPU) + "-" + (Object)((Object)OS);
    }

    public String mapLibraryName(String libName) {
        if (this.libPattern.matcher(libName).find()) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    static /* synthetic */ OS_TYPE access$000() {
        return Platform.determineOS();
    }

    static /* synthetic */ Platform access$100(OS_TYPE x0) {
        return Platform.determinePlatform(x0);
    }

    private static class Windows
    extends Supported {
        public Windows() {
            super(OS_TYPE.WINDOWS);
        }
    }

    private static final class AIX
    extends Supported {
        public AIX() {
            super(OS_TYPE.AIX);
        }

        public String mapLibraryName(String libName) {
            return "c".equals(libName) || "libc.so".equals(libName) ? LIBC : super.mapLibraryName(libName);
        }
    }

    private static final class Linux
    extends Supported {
        public Linux() {
            super(OS_TYPE.LINUX);
        }

        public String mapLibraryName(String libName) {
            return "c".equals(libName) || "libc.so".equals(libName) ? "libc.so.6" : super.mapLibraryName(libName);
        }
    }

    private static final class Darwin
    extends Supported {
        public Darwin() {
            super(OS_TYPE.DARWIN);
        }

        public String mapLibraryName(String libName) {
            if (this.libPattern.matcher(libName).find()) {
                return libName;
            }
            return "lib" + libName + ".dylib";
        }
    }

    private static final class Default
    extends Platform {
        public Default(OS_TYPE os) {
            super(os);
        }
    }

    private static class Unsupported
    extends Platform {
        public Unsupported(OS_TYPE os) {
            super(os);
        }
    }

    private static class Supported
    extends Platform {
        public Supported(OS_TYPE os) {
            super(os);
        }
    }

    private static final class SingletonHolder {
        private static final Platform PLATFORM = Platform.access$100(Platform.access$000());

        private SingletonHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CPU_TYPE {
        I386,
        X86_64,
        POWERPC,
        POWERPC64,
        SPARC,
        SPARCV9,
        S390X,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS_TYPE {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        LINUX,
        SOLARIS,
        AIX,
        WINDOWS,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

