/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaAccessibleObject
extends RubyObject {
    protected JavaAccessibleObject(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public static void registerRubyMethods(Ruby runtime2, RubyClass result2) {
        result2.defineAnnotatedMethods(JavaAccessibleObject.class);
    }

    protected abstract AccessibleObject accessibleObject();

    public boolean equals(Object other) {
        return other instanceof JavaAccessibleObject && this.accessibleObject() == ((JavaAccessibleObject)other).accessibleObject();
    }

    public int hashCode() {
        return this.accessibleObject().hashCode();
    }

    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @JRubyMethod(name={"==", "eql?"})
    public IRubyObject op_equal(IRubyObject other) {
        return other instanceof JavaAccessibleObject && this.accessibleObject().equals(((JavaAccessibleObject)other).accessibleObject()) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"equal?"})
    public IRubyObject same(IRubyObject other) {
        return this.getRuntime().newBoolean(this.equals(other));
    }

    @JRubyMethod(name={"accessible?"})
    public RubyBoolean isAccessible() {
        return new RubyBoolean(this.getRuntime(), this.accessibleObject().isAccessible());
    }

    @JRubyMethod(name={"accessible="})
    public IRubyObject setAccessible(IRubyObject object) {
        this.accessibleObject().setAccessible(object.isTrue());
        return object;
    }

    @JRubyMethod
    public IRubyObject annotation(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getAnnotation(((JavaClass)annoClass).javaClass()));
    }

    @JRubyMethod
    public IRubyObject annotations() {
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getAnnotations());
    }

    @JRubyMethod(name={"annotations?"})
    public RubyBoolean annotations_p() {
        return this.getRuntime().newBoolean(this.accessibleObject().getAnnotations().length > 0);
    }

    @JRubyMethod
    public IRubyObject declared_annotations() {
        return Java.getInstance(this.getRuntime(), this.accessibleObject().getDeclaredAnnotations());
    }

    @JRubyMethod(name={"declared_annotations?"})
    public RubyBoolean declared_annotations_p() {
        return this.getRuntime().newBoolean(this.accessibleObject().getDeclaredAnnotations().length > 0);
    }

    @JRubyMethod(name={"annotation_present?"})
    public IRubyObject annotation_present_p(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return this.getRuntime().newBoolean(this.accessibleObject().isAnnotationPresent(((JavaClass)annoClass).javaClass()));
    }

    @JRubyMethod
    public IRubyObject declaring_class() {
        Class<?> clazz = ((Member)((Object)this.accessibleObject())).getDeclaringClass();
        if (clazz != null) {
            return JavaClass.get(this.getRuntime(), clazz);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject modifiers() {
        return this.getRuntime().newFixnum(((Member)((Object)this.accessibleObject())).getModifiers());
    }

    @JRubyMethod
    public IRubyObject name() {
        return this.getRuntime().newString(((Member)((Object)this.accessibleObject())).getName());
    }

    @JRubyMethod(name={"synthetic?"})
    public IRubyObject synthetic_p() {
        return this.getRuntime().newBoolean(((Member)((Object)this.accessibleObject())).isSynthetic());
    }

    @JRubyMethod(name={"to_s", "to_string"})
    public RubyString to_string() {
        return this.getRuntime().newString(this.accessibleObject().toString());
    }
}

